/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.generic;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.MutableDecimal;
import org.decimal4j.factory.DecimalFactory;
import org.decimal4j.factory.Factories;
import org.decimal4j.generic.GenericImmutableDecimal;
import org.decimal4j.generic.GenericMutableDecimal;
import org.decimal4j.scale.ScaleMetrics;

public final class GenericDecimalFactory<S extends ScaleMetrics>
implements DecimalFactory<S> {
    private final S scaleMetrics;

    public GenericDecimalFactory(S scaleMetrics) {
        this.scaleMetrics = (ScaleMetrics)Objects.requireNonNull(scaleMetrics, "scaleMetrics cannot be null");
    }

    @Override
    public S getScaleMetrics() {
        return this.scaleMetrics;
    }

    @Override
    public int getScale() {
        return this.getScaleMetrics().getScale();
    }

    @Override
    public Class<? extends GenericImmutableDecimal<S>> immutableType() {
        return GenericImmutableDecimal.class;
    }

    @Override
    public Class<? extends MutableDecimal<S>> mutableType() {
        return GenericMutableDecimal.class;
    }

    @Override
    public GenericDecimalFactory<?> deriveFactory(int scale) {
        return Factories.getGenericDecimalFactory(scale);
    }

    @Override
    public <T extends ScaleMetrics> GenericDecimalFactory<T> deriveFactory(T scaleMetrics) {
        return Factories.getGenericDecimalFactory(scaleMetrics);
    }

    @Override
    public GenericImmutableDecimal<S> valueOf(long value) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getDefaultCheckedArithmetic().fromLong(value));
    }

    @Override
    public GenericImmutableDecimal<S> valueOf(float value) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getDefaultCheckedArithmetic().fromFloat(value));
    }

    @Override
    public GenericImmutableDecimal<S> valueOf(float value, RoundingMode roundingMode) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    @Override
    public GenericImmutableDecimal<S> valueOf(double value) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getDefaultCheckedArithmetic().fromDouble(value));
    }

    @Override
    public GenericImmutableDecimal<S> valueOf(double value, RoundingMode roundingMode) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    @Override
    public GenericImmutableDecimal<S> valueOf(BigInteger value) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getDefaultCheckedArithmetic().fromBigInteger(value));
    }

    @Override
    public GenericImmutableDecimal<S> valueOf(BigDecimal value) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getDefaultCheckedArithmetic().fromBigDecimal(value));
    }

    @Override
    public GenericImmutableDecimal<S> valueOf(BigDecimal value, RoundingMode roundingMode) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    @Override
    public GenericImmutableDecimal<S> valueOf(Decimal<?> value) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getDefaultCheckedArithmetic().fromUnscaled(value.unscaledValue(), value.getScale()));
    }

    @Override
    public GenericImmutableDecimal<S> valueOf(Decimal<?> value, RoundingMode roundingMode) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getCheckedArithmetic(roundingMode).fromUnscaled(value.unscaledValue(), value.getScale()));
    }

    @Override
    public GenericImmutableDecimal<S> parse(String value) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getDefaultCheckedArithmetic().parse(value));
    }

    @Override
    public GenericImmutableDecimal<S> parse(String value, RoundingMode roundingMode) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getCheckedArithmetic(roundingMode).parse(value));
    }

    @Override
    public GenericImmutableDecimal<S> valueOfUnscaled(long unscaled) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, unscaled);
    }

    @Override
    public GenericImmutableDecimal<S> valueOfUnscaled(long unscaledValue, int scale) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getDefaultCheckedArithmetic().fromUnscaled(unscaledValue, scale));
    }

    @Override
    public GenericImmutableDecimal<S> valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, this.scaleMetrics.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    public GenericImmutableDecimal<S>[] newArray(int length) {
        return new GenericImmutableDecimal[length];
    }

    @Override
    public GenericMutableDecimal<S> newMutable() {
        return new GenericMutableDecimal<S>(this.scaleMetrics);
    }

    public GenericMutableDecimal<S>[] newMutableArray(int length) {
        return new GenericMutableDecimal[length];
    }
}

