/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable11f;
import org.decimal4j.factory.Factory11f;
import org.decimal4j.mutable.MutableDecimal11f;
import org.decimal4j.scale.Scale11f;

public final class Decimal11f
extends AbstractImmutableDecimal<Scale11f, Decimal11f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 11;
    public static final Scale11f METRICS = Scale11f.INSTANCE;
    public static final Factory11f FACTORY = Factory11f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal11f ZERO = new Decimal11f(0L);
    public static final Decimal11f ULP = new Decimal11f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal11f[] POS_CONST = new Decimal11f[11];
    private static final Decimal11f[] NEG_CONST = new Decimal11f[11];
    public static final Decimal11f ONE;
    public static final Decimal11f TWO;
    public static final Decimal11f THREE;
    public static final Decimal11f FOUR;
    public static final Decimal11f FIVE;
    public static final Decimal11f SIX;
    public static final Decimal11f SEVEN;
    public static final Decimal11f EIGHT;
    public static final Decimal11f NINE;
    public static final Decimal11f TEN;
    public static final Decimal11f HUNDRED;
    public static final Decimal11f THOUSAND;
    public static final Decimal11f MILLION;
    public static final Decimal11f MINUS_ONE;
    public static final Decimal11f HALF;
    public static final Decimal11f TENTH;
    public static final Decimal11f HUNDREDTH;
    public static final Decimal11f THOUSANDTH;
    public static final Decimal11f MILLIONTH;
    public static final Decimal11f BILLIONTH;
    public static final Decimal11f MAX_VALUE;
    public static final Decimal11f MAX_INTEGER_VALUE;
    public static final Decimal11f MIN_VALUE;
    public static final Decimal11f MIN_INTEGER_VALUE;

    private Decimal11f(long unscaled) {
        super(unscaled);
    }

    public Decimal11f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale11f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 11;
    }

    public final Factory11f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal11f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal11f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal11f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal11f valueOf(float value) {
        return Decimal11f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal11f valueOf(float value, RoundingMode roundingMode) {
        return Decimal11f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal11f valueOf(double value) {
        return Decimal11f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal11f valueOf(double value, RoundingMode roundingMode) {
        return Decimal11f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal11f valueOf(BigInteger value) {
        return Decimal11f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal11f valueOf(BigDecimal value) {
        return Decimal11f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal11f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal11f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal11f valueOf(Decimal<?> value) {
        if (value instanceof Decimal11f) {
            return (Decimal11f)value;
        }
        return Decimal11f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal11f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal11f) {
            return (Decimal11f)value;
        }
        return Decimal11f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal11f valueOf(String value) {
        return Decimal11f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal11f valueOf(String value, RoundingMode roundingMode) {
        return Decimal11f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal11f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal11f(unscaledValue);
    }

    public static Decimal11f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal11f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal11f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal11f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal11f createOrAssign(long unscaled) {
        return Decimal11f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal11f create(long unscaled) {
        return Decimal11f.valueOfUnscaled(unscaled);
    }

    protected Decimal11f[] createArray(int length) {
        return new Decimal11f[length];
    }

    public Multipliable11f multiplyExact() {
        return new Multipliable11f(this);
    }

    public MutableDecimal11f toMutableDecimal() {
        return new MutableDecimal11f(this);
    }

    public Decimal11f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal11f.POS_CONST[i] = new Decimal11f(ONE_UNSCALED * (long)i);
            Decimal11f.NEG_CONST[i] = new Decimal11f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal11f.valueOf(1L);
        TWO = Decimal11f.valueOf(2L);
        THREE = Decimal11f.valueOf(3L);
        FOUR = Decimal11f.valueOf(4L);
        FIVE = Decimal11f.valueOf(5L);
        SIX = Decimal11f.valueOf(6L);
        SEVEN = Decimal11f.valueOf(7L);
        EIGHT = Decimal11f.valueOf(8L);
        NINE = Decimal11f.valueOf(9L);
        TEN = Decimal11f.valueOf(10L);
        HUNDRED = new Decimal11f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal11f(1000L * ONE_UNSCALED);
        MILLION = new Decimal11f(1000000L * ONE_UNSCALED);
        MINUS_ONE = Decimal11f.valueOf(-1L);
        HALF = new Decimal11f(ONE_UNSCALED / 2L);
        TENTH = new Decimal11f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal11f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal11f(ONE_UNSCALED / 1000L);
        MILLIONTH = new Decimal11f(ONE_UNSCALED / 1000000L);
        BILLIONTH = new Decimal11f(ONE_UNSCALED / 1000000000L);
        MAX_VALUE = new Decimal11f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal11f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal11f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal11f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

