/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable13f;
import org.decimal4j.factory.Factory13f;
import org.decimal4j.mutable.MutableDecimal13f;
import org.decimal4j.scale.Scale13f;

public final class Decimal13f
extends AbstractImmutableDecimal<Scale13f, Decimal13f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 13;
    public static final Scale13f METRICS = Scale13f.INSTANCE;
    public static final Factory13f FACTORY = Factory13f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal13f ZERO = new Decimal13f(0L);
    public static final Decimal13f ULP = new Decimal13f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal13f[] POS_CONST = new Decimal13f[11];
    private static final Decimal13f[] NEG_CONST = new Decimal13f[11];
    public static final Decimal13f ONE;
    public static final Decimal13f TWO;
    public static final Decimal13f THREE;
    public static final Decimal13f FOUR;
    public static final Decimal13f FIVE;
    public static final Decimal13f SIX;
    public static final Decimal13f SEVEN;
    public static final Decimal13f EIGHT;
    public static final Decimal13f NINE;
    public static final Decimal13f TEN;
    public static final Decimal13f HUNDRED;
    public static final Decimal13f THOUSAND;
    public static final Decimal13f MINUS_ONE;
    public static final Decimal13f HALF;
    public static final Decimal13f TENTH;
    public static final Decimal13f HUNDREDTH;
    public static final Decimal13f THOUSANDTH;
    public static final Decimal13f MILLIONTH;
    public static final Decimal13f BILLIONTH;
    public static final Decimal13f TRILLIONTH;
    public static final Decimal13f MAX_VALUE;
    public static final Decimal13f MAX_INTEGER_VALUE;
    public static final Decimal13f MIN_VALUE;
    public static final Decimal13f MIN_INTEGER_VALUE;

    private Decimal13f(long unscaled) {
        super(unscaled);
    }

    public Decimal13f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale13f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 13;
    }

    public final Factory13f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal13f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal13f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal13f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal13f valueOf(float value) {
        return Decimal13f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal13f valueOf(float value, RoundingMode roundingMode) {
        return Decimal13f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal13f valueOf(double value) {
        return Decimal13f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal13f valueOf(double value, RoundingMode roundingMode) {
        return Decimal13f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal13f valueOf(BigInteger value) {
        return Decimal13f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal13f valueOf(BigDecimal value) {
        return Decimal13f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal13f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal13f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal13f valueOf(Decimal<?> value) {
        if (value instanceof Decimal13f) {
            return (Decimal13f)value;
        }
        return Decimal13f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal13f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal13f) {
            return (Decimal13f)value;
        }
        return Decimal13f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal13f valueOf(String value) {
        return Decimal13f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal13f valueOf(String value, RoundingMode roundingMode) {
        return Decimal13f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal13f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal13f(unscaledValue);
    }

    public static Decimal13f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal13f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal13f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal13f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal13f createOrAssign(long unscaled) {
        return Decimal13f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal13f create(long unscaled) {
        return Decimal13f.valueOfUnscaled(unscaled);
    }

    protected Decimal13f[] createArray(int length) {
        return new Decimal13f[length];
    }

    public Multipliable13f multiplyExact() {
        return new Multipliable13f(this);
    }

    public MutableDecimal13f toMutableDecimal() {
        return new MutableDecimal13f(this);
    }

    public Decimal13f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal13f.POS_CONST[i] = new Decimal13f(ONE_UNSCALED * (long)i);
            Decimal13f.NEG_CONST[i] = new Decimal13f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal13f.valueOf(1L);
        TWO = Decimal13f.valueOf(2L);
        THREE = Decimal13f.valueOf(3L);
        FOUR = Decimal13f.valueOf(4L);
        FIVE = Decimal13f.valueOf(5L);
        SIX = Decimal13f.valueOf(6L);
        SEVEN = Decimal13f.valueOf(7L);
        EIGHT = Decimal13f.valueOf(8L);
        NINE = Decimal13f.valueOf(9L);
        TEN = Decimal13f.valueOf(10L);
        HUNDRED = new Decimal13f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal13f(1000L * ONE_UNSCALED);
        MINUS_ONE = Decimal13f.valueOf(-1L);
        HALF = new Decimal13f(ONE_UNSCALED / 2L);
        TENTH = new Decimal13f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal13f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal13f(ONE_UNSCALED / 1000L);
        MILLIONTH = new Decimal13f(ONE_UNSCALED / 1000000L);
        BILLIONTH = new Decimal13f(ONE_UNSCALED / 1000000000L);
        TRILLIONTH = new Decimal13f(ONE_UNSCALED / 1000000000000L);
        MAX_VALUE = new Decimal13f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal13f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal13f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal13f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

