/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable15f;
import org.decimal4j.factory.Factory15f;
import org.decimal4j.mutable.MutableDecimal15f;
import org.decimal4j.scale.Scale15f;

public final class Decimal15f
extends AbstractImmutableDecimal<Scale15f, Decimal15f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 15;
    public static final Scale15f METRICS = Scale15f.INSTANCE;
    public static final Factory15f FACTORY = Factory15f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal15f ZERO = new Decimal15f(0L);
    public static final Decimal15f ULP = new Decimal15f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal15f[] POS_CONST = new Decimal15f[11];
    private static final Decimal15f[] NEG_CONST = new Decimal15f[11];
    public static final Decimal15f ONE;
    public static final Decimal15f TWO;
    public static final Decimal15f THREE;
    public static final Decimal15f FOUR;
    public static final Decimal15f FIVE;
    public static final Decimal15f SIX;
    public static final Decimal15f SEVEN;
    public static final Decimal15f EIGHT;
    public static final Decimal15f NINE;
    public static final Decimal15f TEN;
    public static final Decimal15f HUNDRED;
    public static final Decimal15f THOUSAND;
    public static final Decimal15f MINUS_ONE;
    public static final Decimal15f HALF;
    public static final Decimal15f TENTH;
    public static final Decimal15f HUNDREDTH;
    public static final Decimal15f THOUSANDTH;
    public static final Decimal15f MILLIONTH;
    public static final Decimal15f BILLIONTH;
    public static final Decimal15f TRILLIONTH;
    public static final Decimal15f QUADRILLIONTH;
    public static final Decimal15f MAX_VALUE;
    public static final Decimal15f MAX_INTEGER_VALUE;
    public static final Decimal15f MIN_VALUE;
    public static final Decimal15f MIN_INTEGER_VALUE;

    private Decimal15f(long unscaled) {
        super(unscaled);
    }

    public Decimal15f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale15f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 15;
    }

    public final Factory15f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal15f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal15f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal15f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal15f valueOf(float value) {
        return Decimal15f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal15f valueOf(float value, RoundingMode roundingMode) {
        return Decimal15f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal15f valueOf(double value) {
        return Decimal15f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal15f valueOf(double value, RoundingMode roundingMode) {
        return Decimal15f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal15f valueOf(BigInteger value) {
        return Decimal15f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal15f valueOf(BigDecimal value) {
        return Decimal15f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal15f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal15f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal15f valueOf(Decimal<?> value) {
        if (value instanceof Decimal15f) {
            return (Decimal15f)value;
        }
        return Decimal15f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal15f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal15f) {
            return (Decimal15f)value;
        }
        return Decimal15f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal15f valueOf(String value) {
        return Decimal15f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal15f valueOf(String value, RoundingMode roundingMode) {
        return Decimal15f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal15f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal15f(unscaledValue);
    }

    public static Decimal15f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal15f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal15f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal15f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal15f createOrAssign(long unscaled) {
        return Decimal15f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal15f create(long unscaled) {
        return Decimal15f.valueOfUnscaled(unscaled);
    }

    protected Decimal15f[] createArray(int length) {
        return new Decimal15f[length];
    }

    public Multipliable15f multiplyExact() {
        return new Multipliable15f(this);
    }

    public MutableDecimal15f toMutableDecimal() {
        return new MutableDecimal15f(this);
    }

    public Decimal15f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal15f.POS_CONST[i] = new Decimal15f(ONE_UNSCALED * (long)i);
            Decimal15f.NEG_CONST[i] = new Decimal15f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal15f.valueOf(1L);
        TWO = Decimal15f.valueOf(2L);
        THREE = Decimal15f.valueOf(3L);
        FOUR = Decimal15f.valueOf(4L);
        FIVE = Decimal15f.valueOf(5L);
        SIX = Decimal15f.valueOf(6L);
        SEVEN = Decimal15f.valueOf(7L);
        EIGHT = Decimal15f.valueOf(8L);
        NINE = Decimal15f.valueOf(9L);
        TEN = Decimal15f.valueOf(10L);
        HUNDRED = new Decimal15f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal15f(1000L * ONE_UNSCALED);
        MINUS_ONE = Decimal15f.valueOf(-1L);
        HALF = new Decimal15f(ONE_UNSCALED / 2L);
        TENTH = new Decimal15f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal15f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal15f(ONE_UNSCALED / 1000L);
        MILLIONTH = new Decimal15f(ONE_UNSCALED / 1000000L);
        BILLIONTH = new Decimal15f(ONE_UNSCALED / 1000000000L);
        TRILLIONTH = new Decimal15f(ONE_UNSCALED / 1000000000000L);
        QUADRILLIONTH = new Decimal15f(ONE_UNSCALED / 1000000000000000L);
        MAX_VALUE = new Decimal15f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal15f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal15f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal15f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

