/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable1f;
import org.decimal4j.factory.Factory1f;
import org.decimal4j.mutable.MutableDecimal1f;
import org.decimal4j.scale.Scale1f;

public final class Decimal1f
extends AbstractImmutableDecimal<Scale1f, Decimal1f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 1;
    public static final Scale1f METRICS = Scale1f.INSTANCE;
    public static final Factory1f FACTORY = Factory1f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal1f ZERO = new Decimal1f(0L);
    public static final Decimal1f ULP = new Decimal1f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal1f[] POS_CONST = new Decimal1f[11];
    private static final Decimal1f[] NEG_CONST = new Decimal1f[11];
    public static final Decimal1f ONE;
    public static final Decimal1f TWO;
    public static final Decimal1f THREE;
    public static final Decimal1f FOUR;
    public static final Decimal1f FIVE;
    public static final Decimal1f SIX;
    public static final Decimal1f SEVEN;
    public static final Decimal1f EIGHT;
    public static final Decimal1f NINE;
    public static final Decimal1f TEN;
    public static final Decimal1f HUNDRED;
    public static final Decimal1f THOUSAND;
    public static final Decimal1f MILLION;
    public static final Decimal1f BILLION;
    public static final Decimal1f TRILLION;
    public static final Decimal1f QUADRILLION;
    public static final Decimal1f MINUS_ONE;
    public static final Decimal1f HALF;
    public static final Decimal1f TENTH;
    public static final Decimal1f MAX_VALUE;
    public static final Decimal1f MAX_INTEGER_VALUE;
    public static final Decimal1f MIN_VALUE;
    public static final Decimal1f MIN_INTEGER_VALUE;

    private Decimal1f(long unscaled) {
        super(unscaled);
    }

    public Decimal1f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale1f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 1;
    }

    public final Factory1f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal1f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal1f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal1f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal1f valueOf(float value) {
        return Decimal1f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal1f valueOf(float value, RoundingMode roundingMode) {
        return Decimal1f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal1f valueOf(double value) {
        return Decimal1f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal1f valueOf(double value, RoundingMode roundingMode) {
        return Decimal1f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal1f valueOf(BigInteger value) {
        return Decimal1f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal1f valueOf(BigDecimal value) {
        return Decimal1f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal1f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal1f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal1f valueOf(Decimal<?> value) {
        if (value instanceof Decimal1f) {
            return (Decimal1f)value;
        }
        return Decimal1f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal1f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal1f) {
            return (Decimal1f)value;
        }
        return Decimal1f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal1f valueOf(String value) {
        return Decimal1f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal1f valueOf(String value, RoundingMode roundingMode) {
        return Decimal1f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal1f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal1f(unscaledValue);
    }

    public static Decimal1f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal1f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal1f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal1f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal1f createOrAssign(long unscaled) {
        return Decimal1f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal1f create(long unscaled) {
        return Decimal1f.valueOfUnscaled(unscaled);
    }

    protected Decimal1f[] createArray(int length) {
        return new Decimal1f[length];
    }

    public Multipliable1f multiplyExact() {
        return new Multipliable1f(this);
    }

    public MutableDecimal1f toMutableDecimal() {
        return new MutableDecimal1f(this);
    }

    public Decimal1f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal1f.POS_CONST[i] = new Decimal1f(ONE_UNSCALED * (long)i);
            Decimal1f.NEG_CONST[i] = new Decimal1f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal1f.valueOf(1L);
        TWO = Decimal1f.valueOf(2L);
        THREE = Decimal1f.valueOf(3L);
        FOUR = Decimal1f.valueOf(4L);
        FIVE = Decimal1f.valueOf(5L);
        SIX = Decimal1f.valueOf(6L);
        SEVEN = Decimal1f.valueOf(7L);
        EIGHT = Decimal1f.valueOf(8L);
        NINE = Decimal1f.valueOf(9L);
        TEN = Decimal1f.valueOf(10L);
        HUNDRED = new Decimal1f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal1f(1000L * ONE_UNSCALED);
        MILLION = new Decimal1f(1000000L * ONE_UNSCALED);
        BILLION = new Decimal1f(1000000000L * ONE_UNSCALED);
        TRILLION = new Decimal1f(1000000000000L * ONE_UNSCALED);
        QUADRILLION = new Decimal1f(1000000000000000L * ONE_UNSCALED);
        MINUS_ONE = Decimal1f.valueOf(-1L);
        HALF = new Decimal1f(ONE_UNSCALED / 2L);
        TENTH = new Decimal1f(ONE_UNSCALED / 10L);
        MAX_VALUE = new Decimal1f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal1f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal1f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal1f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

