/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable2f;
import org.decimal4j.factory.Factory2f;
import org.decimal4j.mutable.MutableDecimal2f;
import org.decimal4j.scale.Scale2f;

public final class Decimal2f
extends AbstractImmutableDecimal<Scale2f, Decimal2f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 2;
    public static final Scale2f METRICS = Scale2f.INSTANCE;
    public static final Factory2f FACTORY = Factory2f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal2f ZERO = new Decimal2f(0L);
    public static final Decimal2f ULP = new Decimal2f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal2f[] POS_CONST = new Decimal2f[11];
    private static final Decimal2f[] NEG_CONST = new Decimal2f[11];
    public static final Decimal2f ONE;
    public static final Decimal2f TWO;
    public static final Decimal2f THREE;
    public static final Decimal2f FOUR;
    public static final Decimal2f FIVE;
    public static final Decimal2f SIX;
    public static final Decimal2f SEVEN;
    public static final Decimal2f EIGHT;
    public static final Decimal2f NINE;
    public static final Decimal2f TEN;
    public static final Decimal2f HUNDRED;
    public static final Decimal2f THOUSAND;
    public static final Decimal2f MILLION;
    public static final Decimal2f BILLION;
    public static final Decimal2f TRILLION;
    public static final Decimal2f QUADRILLION;
    public static final Decimal2f MINUS_ONE;
    public static final Decimal2f HALF;
    public static final Decimal2f TENTH;
    public static final Decimal2f HUNDREDTH;
    public static final Decimal2f MAX_VALUE;
    public static final Decimal2f MAX_INTEGER_VALUE;
    public static final Decimal2f MIN_VALUE;
    public static final Decimal2f MIN_INTEGER_VALUE;

    private Decimal2f(long unscaled) {
        super(unscaled);
    }

    public Decimal2f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale2f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 2;
    }

    public final Factory2f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal2f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal2f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal2f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal2f valueOf(float value) {
        return Decimal2f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal2f valueOf(float value, RoundingMode roundingMode) {
        return Decimal2f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal2f valueOf(double value) {
        return Decimal2f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal2f valueOf(double value, RoundingMode roundingMode) {
        return Decimal2f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal2f valueOf(BigInteger value) {
        return Decimal2f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal2f valueOf(BigDecimal value) {
        return Decimal2f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal2f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal2f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal2f valueOf(Decimal<?> value) {
        if (value instanceof Decimal2f) {
            return (Decimal2f)value;
        }
        return Decimal2f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal2f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal2f) {
            return (Decimal2f)value;
        }
        return Decimal2f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal2f valueOf(String value) {
        return Decimal2f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal2f valueOf(String value, RoundingMode roundingMode) {
        return Decimal2f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal2f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal2f(unscaledValue);
    }

    public static Decimal2f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal2f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal2f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal2f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal2f createOrAssign(long unscaled) {
        return Decimal2f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal2f create(long unscaled) {
        return Decimal2f.valueOfUnscaled(unscaled);
    }

    protected Decimal2f[] createArray(int length) {
        return new Decimal2f[length];
    }

    public Multipliable2f multiplyExact() {
        return new Multipliable2f(this);
    }

    public MutableDecimal2f toMutableDecimal() {
        return new MutableDecimal2f(this);
    }

    public Decimal2f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal2f.POS_CONST[i] = new Decimal2f(ONE_UNSCALED * (long)i);
            Decimal2f.NEG_CONST[i] = new Decimal2f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal2f.valueOf(1L);
        TWO = Decimal2f.valueOf(2L);
        THREE = Decimal2f.valueOf(3L);
        FOUR = Decimal2f.valueOf(4L);
        FIVE = Decimal2f.valueOf(5L);
        SIX = Decimal2f.valueOf(6L);
        SEVEN = Decimal2f.valueOf(7L);
        EIGHT = Decimal2f.valueOf(8L);
        NINE = Decimal2f.valueOf(9L);
        TEN = Decimal2f.valueOf(10L);
        HUNDRED = new Decimal2f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal2f(1000L * ONE_UNSCALED);
        MILLION = new Decimal2f(1000000L * ONE_UNSCALED);
        BILLION = new Decimal2f(1000000000L * ONE_UNSCALED);
        TRILLION = new Decimal2f(1000000000000L * ONE_UNSCALED);
        QUADRILLION = new Decimal2f(1000000000000000L * ONE_UNSCALED);
        MINUS_ONE = Decimal2f.valueOf(-1L);
        HALF = new Decimal2f(ONE_UNSCALED / 2L);
        TENTH = new Decimal2f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal2f(ONE_UNSCALED / 100L);
        MAX_VALUE = new Decimal2f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal2f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal2f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal2f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

