/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable5f;
import org.decimal4j.factory.Factory5f;
import org.decimal4j.mutable.MutableDecimal5f;
import org.decimal4j.scale.Scale5f;

public final class Decimal5f
extends AbstractImmutableDecimal<Scale5f, Decimal5f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 5;
    public static final Scale5f METRICS = Scale5f.INSTANCE;
    public static final Factory5f FACTORY = Factory5f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal5f ZERO = new Decimal5f(0L);
    public static final Decimal5f ULP = new Decimal5f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal5f[] POS_CONST = new Decimal5f[11];
    private static final Decimal5f[] NEG_CONST = new Decimal5f[11];
    public static final Decimal5f ONE;
    public static final Decimal5f TWO;
    public static final Decimal5f THREE;
    public static final Decimal5f FOUR;
    public static final Decimal5f FIVE;
    public static final Decimal5f SIX;
    public static final Decimal5f SEVEN;
    public static final Decimal5f EIGHT;
    public static final Decimal5f NINE;
    public static final Decimal5f TEN;
    public static final Decimal5f HUNDRED;
    public static final Decimal5f THOUSAND;
    public static final Decimal5f MILLION;
    public static final Decimal5f BILLION;
    public static final Decimal5f TRILLION;
    public static final Decimal5f MINUS_ONE;
    public static final Decimal5f HALF;
    public static final Decimal5f TENTH;
    public static final Decimal5f HUNDREDTH;
    public static final Decimal5f THOUSANDTH;
    public static final Decimal5f MAX_VALUE;
    public static final Decimal5f MAX_INTEGER_VALUE;
    public static final Decimal5f MIN_VALUE;
    public static final Decimal5f MIN_INTEGER_VALUE;

    private Decimal5f(long unscaled) {
        super(unscaled);
    }

    public Decimal5f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale5f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 5;
    }

    public final Factory5f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal5f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal5f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal5f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal5f valueOf(float value) {
        return Decimal5f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal5f valueOf(float value, RoundingMode roundingMode) {
        return Decimal5f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal5f valueOf(double value) {
        return Decimal5f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal5f valueOf(double value, RoundingMode roundingMode) {
        return Decimal5f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal5f valueOf(BigInteger value) {
        return Decimal5f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal5f valueOf(BigDecimal value) {
        return Decimal5f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal5f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal5f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal5f valueOf(Decimal<?> value) {
        if (value instanceof Decimal5f) {
            return (Decimal5f)value;
        }
        return Decimal5f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal5f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal5f) {
            return (Decimal5f)value;
        }
        return Decimal5f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal5f valueOf(String value) {
        return Decimal5f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal5f valueOf(String value, RoundingMode roundingMode) {
        return Decimal5f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal5f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal5f(unscaledValue);
    }

    public static Decimal5f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal5f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal5f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal5f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal5f createOrAssign(long unscaled) {
        return Decimal5f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal5f create(long unscaled) {
        return Decimal5f.valueOfUnscaled(unscaled);
    }

    protected Decimal5f[] createArray(int length) {
        return new Decimal5f[length];
    }

    public Multipliable5f multiplyExact() {
        return new Multipliable5f(this);
    }

    public MutableDecimal5f toMutableDecimal() {
        return new MutableDecimal5f(this);
    }

    public Decimal5f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal5f.POS_CONST[i] = new Decimal5f(ONE_UNSCALED * (long)i);
            Decimal5f.NEG_CONST[i] = new Decimal5f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal5f.valueOf(1L);
        TWO = Decimal5f.valueOf(2L);
        THREE = Decimal5f.valueOf(3L);
        FOUR = Decimal5f.valueOf(4L);
        FIVE = Decimal5f.valueOf(5L);
        SIX = Decimal5f.valueOf(6L);
        SEVEN = Decimal5f.valueOf(7L);
        EIGHT = Decimal5f.valueOf(8L);
        NINE = Decimal5f.valueOf(9L);
        TEN = Decimal5f.valueOf(10L);
        HUNDRED = new Decimal5f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal5f(1000L * ONE_UNSCALED);
        MILLION = new Decimal5f(1000000L * ONE_UNSCALED);
        BILLION = new Decimal5f(1000000000L * ONE_UNSCALED);
        TRILLION = new Decimal5f(1000000000000L * ONE_UNSCALED);
        MINUS_ONE = Decimal5f.valueOf(-1L);
        HALF = new Decimal5f(ONE_UNSCALED / 2L);
        TENTH = new Decimal5f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal5f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal5f(ONE_UNSCALED / 1000L);
        MAX_VALUE = new Decimal5f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal5f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal5f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal5f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

