/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable8f;
import org.decimal4j.factory.Factory8f;
import org.decimal4j.mutable.MutableDecimal8f;
import org.decimal4j.scale.Scale8f;

public final class Decimal8f
extends AbstractImmutableDecimal<Scale8f, Decimal8f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 8;
    public static final Scale8f METRICS = Scale8f.INSTANCE;
    public static final Factory8f FACTORY = Factory8f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal8f ZERO = new Decimal8f(0L);
    public static final Decimal8f ULP = new Decimal8f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal8f[] POS_CONST = new Decimal8f[11];
    private static final Decimal8f[] NEG_CONST = new Decimal8f[11];
    public static final Decimal8f ONE;
    public static final Decimal8f TWO;
    public static final Decimal8f THREE;
    public static final Decimal8f FOUR;
    public static final Decimal8f FIVE;
    public static final Decimal8f SIX;
    public static final Decimal8f SEVEN;
    public static final Decimal8f EIGHT;
    public static final Decimal8f NINE;
    public static final Decimal8f TEN;
    public static final Decimal8f HUNDRED;
    public static final Decimal8f THOUSAND;
    public static final Decimal8f MILLION;
    public static final Decimal8f BILLION;
    public static final Decimal8f MINUS_ONE;
    public static final Decimal8f HALF;
    public static final Decimal8f TENTH;
    public static final Decimal8f HUNDREDTH;
    public static final Decimal8f THOUSANDTH;
    public static final Decimal8f MILLIONTH;
    public static final Decimal8f MAX_VALUE;
    public static final Decimal8f MAX_INTEGER_VALUE;
    public static final Decimal8f MIN_VALUE;
    public static final Decimal8f MIN_INTEGER_VALUE;

    private Decimal8f(long unscaled) {
        super(unscaled);
    }

    public Decimal8f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale8f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 8;
    }

    public final Factory8f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal8f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal8f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal8f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal8f valueOf(float value) {
        return Decimal8f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal8f valueOf(float value, RoundingMode roundingMode) {
        return Decimal8f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal8f valueOf(double value) {
        return Decimal8f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal8f valueOf(double value, RoundingMode roundingMode) {
        return Decimal8f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal8f valueOf(BigInteger value) {
        return Decimal8f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal8f valueOf(BigDecimal value) {
        return Decimal8f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal8f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal8f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal8f valueOf(Decimal<?> value) {
        if (value instanceof Decimal8f) {
            return (Decimal8f)value;
        }
        return Decimal8f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal8f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal8f) {
            return (Decimal8f)value;
        }
        return Decimal8f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal8f valueOf(String value) {
        return Decimal8f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal8f valueOf(String value, RoundingMode roundingMode) {
        return Decimal8f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal8f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal8f(unscaledValue);
    }

    public static Decimal8f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal8f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal8f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal8f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal8f createOrAssign(long unscaled) {
        return Decimal8f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal8f create(long unscaled) {
        return Decimal8f.valueOfUnscaled(unscaled);
    }

    protected Decimal8f[] createArray(int length) {
        return new Decimal8f[length];
    }

    public Multipliable8f multiplyExact() {
        return new Multipliable8f(this);
    }

    public MutableDecimal8f toMutableDecimal() {
        return new MutableDecimal8f(this);
    }

    public Decimal8f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal8f.POS_CONST[i] = new Decimal8f(ONE_UNSCALED * (long)i);
            Decimal8f.NEG_CONST[i] = new Decimal8f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal8f.valueOf(1L);
        TWO = Decimal8f.valueOf(2L);
        THREE = Decimal8f.valueOf(3L);
        FOUR = Decimal8f.valueOf(4L);
        FIVE = Decimal8f.valueOf(5L);
        SIX = Decimal8f.valueOf(6L);
        SEVEN = Decimal8f.valueOf(7L);
        EIGHT = Decimal8f.valueOf(8L);
        NINE = Decimal8f.valueOf(9L);
        TEN = Decimal8f.valueOf(10L);
        HUNDRED = new Decimal8f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal8f(1000L * ONE_UNSCALED);
        MILLION = new Decimal8f(1000000L * ONE_UNSCALED);
        BILLION = new Decimal8f(1000000000L * ONE_UNSCALED);
        MINUS_ONE = Decimal8f.valueOf(-1L);
        HALF = new Decimal8f(ONE_UNSCALED / 2L);
        TENTH = new Decimal8f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal8f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal8f(ONE_UNSCALED / 1000L);
        MILLIONTH = new Decimal8f(ONE_UNSCALED / 1000000L);
        MAX_VALUE = new Decimal8f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal8f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal8f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal8f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

