/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable9f;
import org.decimal4j.factory.Factory9f;
import org.decimal4j.mutable.MutableDecimal9f;
import org.decimal4j.scale.Scale9f;

public final class Decimal9f
extends AbstractImmutableDecimal<Scale9f, Decimal9f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 9;
    public static final Scale9f METRICS = Scale9f.INSTANCE;
    public static final Factory9f FACTORY = Factory9f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal9f ZERO = new Decimal9f(0L);
    public static final Decimal9f ULP = new Decimal9f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal9f[] POS_CONST = new Decimal9f[11];
    private static final Decimal9f[] NEG_CONST = new Decimal9f[11];
    public static final Decimal9f ONE;
    public static final Decimal9f TWO;
    public static final Decimal9f THREE;
    public static final Decimal9f FOUR;
    public static final Decimal9f FIVE;
    public static final Decimal9f SIX;
    public static final Decimal9f SEVEN;
    public static final Decimal9f EIGHT;
    public static final Decimal9f NINE;
    public static final Decimal9f TEN;
    public static final Decimal9f HUNDRED;
    public static final Decimal9f THOUSAND;
    public static final Decimal9f MILLION;
    public static final Decimal9f BILLION;
    public static final Decimal9f MINUS_ONE;
    public static final Decimal9f HALF;
    public static final Decimal9f TENTH;
    public static final Decimal9f HUNDREDTH;
    public static final Decimal9f THOUSANDTH;
    public static final Decimal9f MILLIONTH;
    public static final Decimal9f BILLIONTH;
    public static final Decimal9f MAX_VALUE;
    public static final Decimal9f MAX_INTEGER_VALUE;
    public static final Decimal9f MIN_VALUE;
    public static final Decimal9f MIN_INTEGER_VALUE;

    private Decimal9f(long unscaled) {
        super(unscaled);
    }

    public Decimal9f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale9f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 9;
    }

    public final Factory9f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal9f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal9f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal9f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal9f valueOf(float value) {
        return Decimal9f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal9f valueOf(float value, RoundingMode roundingMode) {
        return Decimal9f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal9f valueOf(double value) {
        return Decimal9f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal9f valueOf(double value, RoundingMode roundingMode) {
        return Decimal9f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal9f valueOf(BigInteger value) {
        return Decimal9f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal9f valueOf(BigDecimal value) {
        return Decimal9f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal9f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal9f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal9f valueOf(Decimal<?> value) {
        if (value instanceof Decimal9f) {
            return (Decimal9f)value;
        }
        return Decimal9f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal9f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal9f) {
            return (Decimal9f)value;
        }
        return Decimal9f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal9f valueOf(String value) {
        return Decimal9f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal9f valueOf(String value, RoundingMode roundingMode) {
        return Decimal9f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal9f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal9f(unscaledValue);
    }

    public static Decimal9f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal9f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal9f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal9f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal9f createOrAssign(long unscaled) {
        return Decimal9f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal9f create(long unscaled) {
        return Decimal9f.valueOfUnscaled(unscaled);
    }

    protected Decimal9f[] createArray(int length) {
        return new Decimal9f[length];
    }

    public Multipliable9f multiplyExact() {
        return new Multipliable9f(this);
    }

    public MutableDecimal9f toMutableDecimal() {
        return new MutableDecimal9f(this);
    }

    public Decimal9f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal9f.POS_CONST[i] = new Decimal9f(ONE_UNSCALED * (long)i);
            Decimal9f.NEG_CONST[i] = new Decimal9f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal9f.valueOf(1L);
        TWO = Decimal9f.valueOf(2L);
        THREE = Decimal9f.valueOf(3L);
        FOUR = Decimal9f.valueOf(4L);
        FIVE = Decimal9f.valueOf(5L);
        SIX = Decimal9f.valueOf(6L);
        SEVEN = Decimal9f.valueOf(7L);
        EIGHT = Decimal9f.valueOf(8L);
        NINE = Decimal9f.valueOf(9L);
        TEN = Decimal9f.valueOf(10L);
        HUNDRED = new Decimal9f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal9f(1000L * ONE_UNSCALED);
        MILLION = new Decimal9f(1000000L * ONE_UNSCALED);
        BILLION = new Decimal9f(1000000000L * ONE_UNSCALED);
        MINUS_ONE = Decimal9f.valueOf(-1L);
        HALF = new Decimal9f(ONE_UNSCALED / 2L);
        TENTH = new Decimal9f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal9f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal9f(ONE_UNSCALED / 1000L);
        MILLIONTH = new Decimal9f(ONE_UNSCALED / 1000000L);
        BILLIONTH = new Decimal9f(ONE_UNSCALED / 1000000000L);
        MAX_VALUE = new Decimal9f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal9f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal9f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal9f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

