/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.scale;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.CheckedScale0fRoundingArithmetic;
import org.decimal4j.arithmetic.CheckedScale0fTruncatingArithmetic;
import org.decimal4j.arithmetic.UncheckedScale0fRoundingArithmetic;
import org.decimal4j.arithmetic.UncheckedScale0fTruncatingArithmetic;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.truncate.DecimalRounding;
import org.decimal4j.truncate.OverflowMode;
import org.decimal4j.truncate.TruncationPolicy;

public enum Scale0f implements ScaleMetrics
{
    INSTANCE;

    public static final int SCALE = 0;
    public static final long SCALE_FACTOR = 1L;
    private static final int NLZ_SCALE_FACTOR = 63;
    private static final long LONG_MASK = 0xFFFFFFFFL;
    private static final DecimalArithmetic[] UNCHECKED_ARITHMETIC;
    private static final DecimalArithmetic[] CHECKED_ARITHMETIC;
    private static final DecimalArithmetic DEFAULT_ARITHMETIC;
    private static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC;
    private static final DecimalArithmetic ROUNDING_DOWN_ARITHMETIC;
    private static final DecimalArithmetic ROUNDING_FLOOR_ARITHMETIC;
    private static final DecimalArithmetic ROUNDING_HALF_EVEN_ARITHMETIC;
    private static final DecimalArithmetic ROUNDING_UNNECESSARY_ARITHMETIC;

    private static final DecimalArithmetic[] initArithmetic(OverflowMode overflowMode) {
        boolean checked = overflowMode == OverflowMode.CHECKED;
        DecimalArithmetic[] arith = new DecimalArithmetic[DecimalRounding.VALUES.size()];
        for (DecimalRounding dr : DecimalRounding.VALUES) {
            int index = dr.getRoundingMode().ordinal();
            if (dr == DecimalRounding.DOWN) {
                arith[index] = checked ? CheckedScale0fTruncatingArithmetic.INSTANCE : UncheckedScale0fTruncatingArithmetic.INSTANCE;
                continue;
            }
            arith[index] = checked ? new CheckedScale0fRoundingArithmetic(dr) : new UncheckedScale0fRoundingArithmetic(dr);
        }
        return arith;
    }

    @Override
    public final int getScale() {
        return 0;
    }

    @Override
    public final long getScaleFactor() {
        return 1L;
    }

    @Override
    public final int getScaleFactorNumberOfLeadingZeros() {
        return 63;
    }

    @Override
    public final BigInteger getScaleFactorAsBigInteger() {
        return BigInteger.ONE;
    }

    @Override
    public final BigDecimal getScaleFactorAsBigDecimal() {
        return BigDecimal.ONE;
    }

    @Override
    public final long getMaxIntegerValue() {
        return Long.MAX_VALUE;
    }

    @Override
    public final long getMinIntegerValue() {
        return Long.MIN_VALUE;
    }

    @Override
    public final boolean isValidIntegerValue(long value) {
        return true;
    }

    @Override
    public final long multiplyByScaleFactor(long factor) {
        return factor;
    }

    @Override
    public final long multiplyByScaleFactorExact(long factor) {
        return factor;
    }

    @Override
    public final long mulloByScaleFactor(int factor) {
        return (long)factor & 0xFFFFFFFFL;
    }

    @Override
    public final long mulhiByScaleFactor(int factor) {
        return 0L;
    }

    @Override
    public final long divideByScaleFactor(long dividend) {
        return dividend;
    }

    @Override
    public final long divideUnsignedByScaleFactor(long unsignedDividend) {
        return unsignedDividend;
    }

    @Override
    public final long moduloByScaleFactor(long dividend) {
        return 0L;
    }

    @Override
    public final String toString(long value) {
        return Long.toString(value);
    }

    @Override
    public final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    public final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    public final DecimalArithmetic getRoundingDownArithmetic() {
        return ROUNDING_DOWN_ARITHMETIC;
    }

    @Override
    public final DecimalArithmetic getRoundingFloorArithmetic() {
        return ROUNDING_FLOOR_ARITHMETIC;
    }

    @Override
    public final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return ROUNDING_HALF_EVEN_ARITHMETIC;
    }

    @Override
    public final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return ROUNDING_UNNECESSARY_ARITHMETIC;
    }

    @Override
    public final DecimalArithmetic getArithmetic(RoundingMode roundingMode) {
        return UNCHECKED_ARITHMETIC[roundingMode.ordinal()];
    }

    @Override
    public final DecimalArithmetic getCheckedArithmetic(RoundingMode roundingMode) {
        return CHECKED_ARITHMETIC[roundingMode.ordinal()];
    }

    @Override
    public final DecimalArithmetic getArithmetic(TruncationPolicy truncationPolicy) {
        OverflowMode overflow = truncationPolicy.getOverflowMode();
        RoundingMode rounding = truncationPolicy.getRoundingMode();
        return (overflow == OverflowMode.UNCHECKED ? UNCHECKED_ARITHMETIC : CHECKED_ARITHMETIC)[rounding.ordinal()];
    }

    public final String toString() {
        return "Scale0f";
    }

    static {
        UNCHECKED_ARITHMETIC = Scale0f.initArithmetic(OverflowMode.UNCHECKED);
        CHECKED_ARITHMETIC = Scale0f.initArithmetic(OverflowMode.CHECKED);
        DEFAULT_ARITHMETIC = UNCHECKED_ARITHMETIC[RoundingMode.HALF_UP.ordinal()];
        DEFAULT_CHECKED_ARITHMETIC = CHECKED_ARITHMETIC[RoundingMode.HALF_UP.ordinal()];
        ROUNDING_DOWN_ARITHMETIC = UNCHECKED_ARITHMETIC[RoundingMode.DOWN.ordinal()];
        ROUNDING_FLOOR_ARITHMETIC = UNCHECKED_ARITHMETIC[RoundingMode.FLOOR.ordinal()];
        ROUNDING_HALF_EVEN_ARITHMETIC = UNCHECKED_ARITHMETIC[RoundingMode.HALF_EVEN.ordinal()];
        ROUNDING_UNNECESSARY_ARITHMETIC = UNCHECKED_ARITHMETIC[RoundingMode.UNNECESSARY.ordinal()];
    }
}

