/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.truncate;

import java.math.RoundingMode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.decimal4j.truncate.TruncatedPart;

public enum DecimalRounding {
    UP{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.UP;
        }

        @Override
        public final int calculateRoundingIncrement(int sgn, long truncatedValue, TruncatedPart truncatedPart) {
            if (truncatedPart.isGreaterThanZero()) {
                return sgn;
            }
            return 0;
        }
    }
    ,
    DOWN{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.DOWN;
        }

        @Override
        public final int calculateRoundingIncrement(int sgn, long truncatedValue, TruncatedPart truncatedPart) {
            return 0;
        }
    }
    ,
    CEILING{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.CEILING;
        }

        @Override
        public final int calculateRoundingIncrement(int sgn, long truncatedValue, TruncatedPart truncatedPart) {
            if (sgn > 0 && truncatedPart.isGreaterThanZero()) {
                return 1;
            }
            return 0;
        }
    }
    ,
    FLOOR{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.FLOOR;
        }

        @Override
        public final int calculateRoundingIncrement(int sgn, long truncatedValue, TruncatedPart truncatedPart) {
            if (sgn < 0 && truncatedPart.isGreaterThanZero()) {
                return -1;
            }
            return 0;
        }
    }
    ,
    HALF_UP{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.HALF_UP;
        }

        @Override
        public final int calculateRoundingIncrement(int sgn, long truncatedValue, TruncatedPart truncatedPart) {
            if (truncatedPart.isGreaterEqualHalf()) {
                return sgn;
            }
            return 0;
        }
    }
    ,
    HALF_DOWN{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.HALF_DOWN;
        }

        @Override
        public final int calculateRoundingIncrement(int sgn, long truncatedValue, TruncatedPart truncatedPart) {
            if (truncatedPart.isGreaterThanHalf()) {
                return sgn;
            }
            return 0;
        }
    }
    ,
    HALF_EVEN{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.HALF_EVEN;
        }

        @Override
        public final int calculateRoundingIncrement(int sgn, long truncatedValue, TruncatedPart truncatedPart) {
            if (truncatedPart.isGreaterEqualHalf() && truncatedPart.isGreaterThanHalf() | (truncatedValue & 1L) != 0L) {
                return sgn;
            }
            return 0;
        }
    }
    ,
    UNNECESSARY{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.UNNECESSARY;
        }

        @Override
        public final int calculateRoundingIncrement(int sgn, long truncatedValue, TruncatedPart truncatedPart) {
            if (truncatedPart.isGreaterThanZero()) {
                throw new ArithmeticException("Rounding necessary");
            }
            return 0;
        }
    };

    public static final Set<DecimalRounding> VALUES;

    public abstract RoundingMode getRoundingMode();

    public abstract int calculateRoundingIncrement(int var1, long var2, TruncatedPart var4);

    public static final DecimalRounding valueOf(RoundingMode roundingMode) {
        return ByRoundingMode.VALUES_BY_ROUNDING_MODE_ORDINAL[roundingMode.ordinal()];
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(DecimalRounding.class));
    }

    private static class ByRoundingMode {
        private static final DecimalRounding[] VALUES_BY_ROUNDING_MODE_ORDINAL = ByRoundingMode.sortByRoundingModeOrdinal();

        private ByRoundingMode() {
        }

        private static final DecimalRounding[] sortByRoundingModeOrdinal() {
            DecimalRounding[] sorted = new DecimalRounding[VALUES.size()];
            Iterator<DecimalRounding> i$ = VALUES.iterator();
            while (i$.hasNext()) {
                DecimalRounding dr;
                sorted[dr.getRoundingMode().ordinal()] = dr = i$.next();
            }
            return sorted;
        }
    }
}

