/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.truncate;

import java.math.RoundingMode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.decimal4j.truncate.CheckedRounding;
import org.decimal4j.truncate.OverflowMode;
import org.decimal4j.truncate.TruncationPolicy;

public enum UncheckedRounding implements TruncationPolicy
{
    UP{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.UP;
        }

        @Override
        public final CheckedRounding toCheckedRounding() {
            return CheckedRounding.UP;
        }
    }
    ,
    DOWN{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.DOWN;
        }

        @Override
        public final CheckedRounding toCheckedRounding() {
            return CheckedRounding.DOWN;
        }
    }
    ,
    CEILING{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.CEILING;
        }

        @Override
        public final CheckedRounding toCheckedRounding() {
            return CheckedRounding.CEILING;
        }
    }
    ,
    FLOOR{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.FLOOR;
        }

        @Override
        public final CheckedRounding toCheckedRounding() {
            return CheckedRounding.FLOOR;
        }
    }
    ,
    HALF_UP{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.HALF_UP;
        }

        @Override
        public final CheckedRounding toCheckedRounding() {
            return CheckedRounding.HALF_UP;
        }
    }
    ,
    HALF_DOWN{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.HALF_DOWN;
        }

        @Override
        public final CheckedRounding toCheckedRounding() {
            return CheckedRounding.HALF_DOWN;
        }
    }
    ,
    HALF_EVEN{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.HALF_EVEN;
        }

        @Override
        public final CheckedRounding toCheckedRounding() {
            return CheckedRounding.HALF_EVEN;
        }
    }
    ,
    UNNECESSARY{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.UNNECESSARY;
        }

        @Override
        public final CheckedRounding toCheckedRounding() {
            return CheckedRounding.UNNECESSARY;
        }
    };

    public static final Set<UncheckedRounding> VALUES;

    @Override
    public final OverflowMode getOverflowMode() {
        return OverflowMode.UNCHECKED;
    }

    public abstract CheckedRounding toCheckedRounding();

    public final String toString() {
        return "UNCHECKED/" + this.name();
    }

    public static final UncheckedRounding valueOf(RoundingMode roundingMode) {
        return ByRoundingMode.VALUES_BY_ROUNDING_MODE_ORDINAL[roundingMode.ordinal()];
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(UncheckedRounding.class));
    }

    private static class ByRoundingMode {
        private static final UncheckedRounding[] VALUES_BY_ROUNDING_MODE_ORDINAL = ByRoundingMode.sortByRoundingModeOrdinal();

        private ByRoundingMode() {
        }

        private static final UncheckedRounding[] sortByRoundingModeOrdinal() {
            UncheckedRounding[] sorted = new UncheckedRounding[VALUES.size()];
            Iterator<UncheckedRounding> i$ = VALUES.iterator();
            while (i$.hasNext()) {
                UncheckedRounding dr;
                sorted[dr.getRoundingMode().ordinal()] = dr = i$.next();
            }
            return sorted;
        }
    }
}

