/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.util;

import java.math.RoundingMode;
import java.util.Objects;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;

public final class DoubleRounder {
    private final ScaleMetrics scaleMetrics;
    private final double ulp;

    public DoubleRounder(int precision) {
        this(DoubleRounder.toScaleMetrics(precision));
    }

    public DoubleRounder(ScaleMetrics scaleMetrics) {
        this.scaleMetrics = Objects.requireNonNull(scaleMetrics, "scaleMetrics cannot be null");
        this.ulp = scaleMetrics.getRoundingHalfEvenArithmetic().toDouble(1L);
    }

    public int getPrecision() {
        return this.scaleMetrics.getScale();
    }

    public double round(double value) {
        return DoubleRounder.round(value, this.scaleMetrics.getDefaultArithmetic(), this.scaleMetrics.getRoundingHalfEvenArithmetic(), this.ulp);
    }

    public double round(double value, RoundingMode roundingMode) {
        return DoubleRounder.round(value, roundingMode, this.scaleMetrics.getRoundingHalfEvenArithmetic(), this.ulp);
    }

    public int hashCode() {
        return this.scaleMetrics.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DoubleRounder) {
            return this.scaleMetrics.equals(((DoubleRounder)obj).scaleMetrics);
        }
        return false;
    }

    public String toString() {
        return "DoubleRounder[precision=" + this.getPrecision() + "]";
    }

    public static final double round(double value, int precision) {
        ScaleMetrics sm = DoubleRounder.toScaleMetrics(precision);
        DecimalArithmetic halfEvenArith = sm.getRoundingHalfEvenArithmetic();
        return DoubleRounder.round(value, sm.getDefaultArithmetic(), halfEvenArith, halfEvenArith.toDouble(1L));
    }

    public static final double round(double value, int precision, RoundingMode roundingMode) {
        ScaleMetrics sm = DoubleRounder.toScaleMetrics(precision);
        DecimalArithmetic halfEvenArith = sm.getRoundingHalfEvenArithmetic();
        return DoubleRounder.round(value, roundingMode, halfEvenArith, halfEvenArith.toDouble(1L));
    }

    private static final double round(double value, RoundingMode roundingMode, DecimalArithmetic halfEvenArith, double ulp) {
        if (roundingMode == RoundingMode.UNNECESSARY) {
            return DoubleRounder.checkRoundingUnnecessary(value, halfEvenArith, ulp);
        }
        return DoubleRounder.round(value, halfEvenArith.deriveArithmetic(roundingMode), halfEvenArith, ulp);
    }

    private static final double round(double value, DecimalArithmetic roundingArith, DecimalArithmetic halfEvenArith, double ulp) {
        if (!DoubleRounder.isFinite(value) || 2.0 * ulp <= Math.ulp(value)) {
            return value;
        }
        long uDecimal = roundingArith.fromDouble(value);
        return halfEvenArith.toDouble(uDecimal);
    }

    private static final double checkRoundingUnnecessary(double value, DecimalArithmetic halfEvenArith, double ulp) {
        long uDecimal;
        if (DoubleRounder.isFinite(value) && 2.0 * ulp > Math.ulp(value) && halfEvenArith.toDouble(uDecimal = halfEvenArith.fromDouble(value)) != value) {
            throw new ArithmeticException("Rounding necessary for precision " + halfEvenArith.getScale() + ": " + value);
        }
        return value;
    }

    private static final ScaleMetrics toScaleMetrics(int precision) {
        if (precision < 0 | precision > 18) {
            throw new IllegalArgumentException("Precision must be in [0,18] but was " + precision);
        }
        return Scales.getScaleMetrics(precision);
    }

    private static boolean isFinite(double d) {
        return Math.abs(d) <= Double.MAX_VALUE;
    }
}

