/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param;

import com.google.common.collect.Lists;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import io.milvus.param.QueryNodeSingleSearch;
import io.milvus.param.ServerAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;

public class MultiConnectParam {
    private final List<ServerAddress> hosts;
    private final QueryNodeSingleSearch queryNodeSingleSearch;
    private final long connectTimeoutMs;
    private final long keepAliveTimeMs;
    private final long keepAliveTimeoutMs;
    private final boolean keepAliveWithoutCalls;
    private final boolean secure;
    private final long idleTimeoutMs;
    private final String authorization;

    private MultiConnectParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.hosts = builder.hosts;
        this.queryNodeSingleSearch = builder.queryNodeSingleSearch;
        this.connectTimeoutMs = builder.connectTimeoutMs;
        this.keepAliveTimeMs = builder.keepAliveTimeMs;
        this.keepAliveTimeoutMs = builder.keepAliveTimeoutMs;
        this.keepAliveWithoutCalls = builder.keepAliveWithoutCalls;
        this.secure = builder.secure;
        this.idleTimeoutMs = builder.idleTimeoutMs;
        this.authorization = builder.authorization;
    }

    public List<ServerAddress> getHosts() {
        return this.hosts;
    }

    public QueryNodeSingleSearch getQueryNodeSingleSearch() {
        return this.queryNodeSingleSearch;
    }

    public long getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public long getKeepAliveTimeMs() {
        return this.keepAliveTimeMs;
    }

    public long getKeepAliveTimeoutMs() {
        return this.keepAliveTimeoutMs;
    }

    public boolean isKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public long getIdleTimeoutMs() {
        return this.idleTimeoutMs;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MultiConnectParam{");
        sb.append("hosts=").append(this.hosts);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private List<ServerAddress> hosts;
        private QueryNodeSingleSearch queryNodeSingleSearch;
        private long connectTimeoutMs = 10000L;
        private long keepAliveTimeMs = Long.MAX_VALUE;
        private long keepAliveTimeoutMs = 20000L;
        private boolean keepAliveWithoutCalls = false;
        private boolean secure = false;
        private long idleTimeoutMs = TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
        private String authorization = "";

        private Builder() {
        }

        public Builder withHosts(@NonNull List<ServerAddress> hosts) {
            if (hosts == null) {
                throw new NullPointerException("hosts is marked non-null but is null");
            }
            this.hosts = hosts;
            return this;
        }

        public Builder withQueryNodeSingleSearch(@NonNull QueryNodeSingleSearch queryNodeSingleSearch) {
            if (queryNodeSingleSearch == null) {
                throw new NullPointerException("queryNodeSingleSearch is marked non-null but is null");
            }
            this.queryNodeSingleSearch = queryNodeSingleSearch;
            return this;
        }

        public Builder withConnectTimeout(long connectTimeout, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.connectTimeoutMs = timeUnit.toMillis(connectTimeout);
            return this;
        }

        public Builder withKeepAliveTime(long keepAliveTime, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.keepAliveTimeMs = timeUnit.toMillis(keepAliveTime);
            return this;
        }

        public Builder withKeepAliveTimeout(long keepAliveTimeout, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.keepAliveTimeoutMs = timeUnit.toNanos(keepAliveTimeout);
            return this;
        }

        public Builder keepAliveWithoutCalls(boolean enable) {
            this.keepAliveWithoutCalls = enable;
            return this;
        }

        public Builder secure(boolean enable) {
            this.secure = enable;
            return this;
        }

        public Builder withSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder withIdleTimeout(long idleTimeout, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.idleTimeoutMs = timeUnit.toMillis(idleTimeout);
            return this;
        }

        public Builder withAuthorization(@NonNull String username, @NonNull String password) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            if (password == null) {
                throw new NullPointerException("password is marked non-null but is null");
            }
            this.authorization = Base64.getEncoder().encodeToString(String.format("%s:%s", username, password).getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public MultiConnectParam build() throws ParamException {
            if (CollectionUtils.isEmpty(this.hosts)) {
                throw new ParamException("Server addresses is empty!");
            }
            ArrayList hostAddress = Lists.newArrayList();
            for (ServerAddress serverAddress : this.hosts) {
                String host = serverAddress.getHost();
                ParamUtils.CheckNullEmptyString(host, "Host name");
                if (host.startsWith("https://")) {
                    host = host.replace("https://", "");
                    this.secure = true;
                } else if (host.startsWith("http://")) {
                    host = host.replace("http://", "");
                }
                hostAddress.add(ServerAddress.newBuilder().withHost(host).withPort(serverAddress.getPort()).withHealthPort(serverAddress.getHealthPort()).build());
                if (serverAddress.getPort() >= 0 && serverAddress.getPort() <= 65535) continue;
                throw new ParamException("Port is out of range!");
            }
            this.withHosts(hostAddress);
            if (this.keepAliveTimeMs <= 0L) {
                throw new ParamException("Keep alive time must be positive!");
            }
            if (this.connectTimeoutMs <= 0L) {
                throw new ParamException("Connect timeout must be positive!");
            }
            if (this.keepAliveTimeoutMs <= 0L) {
                throw new ParamException("Keep alive timeout must be positive!");
            }
            if (this.idleTimeoutMs <= 0L) {
                throw new ParamException("Idle timeout must be positive!");
            }
            return new MultiConnectParam(this);
        }
    }
}

