/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardBigIntegers;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardCurveHelper;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKeyHelper;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardPublicKey;
import cfca.sadk.extend.session.util.Args;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.PrivateKey;

public final class ECCCardExternalPrivateKey
extends BCECPrivateKey
implements ECCCardKey {
    private static final long serialVersionUID = 6668848308980508543L;
    private static final int MAX_STRENGTH = 66;
    private final ECCCurveId curveId;
    private byte[] keyData;
    private String pubKeyInfo;
    private final ECCCardPublicKey eccPublicKey;

    public ECCCardExternalPrivateKey(BCECPrivateKey key, int curveId) throws CryptoException {
        super("EC", Args.notNull(key, "ECPrivateKey"));
        ECCCurveId curve = ECCCurveId.findECCCurveId(curveId);
        if (curve == null) {
            throw new CryptoException("unknown curve name: " + curveId);
        }
        this.curveId = curve;
        this.eccPublicKey = this.buildPublicKey(this.getD(), this.getDomainParameters(), curveId);
        this.keyData = this.buildKeyData();
    }

    public ECCCardExternalPrivateKey(BCECPrivateKey key) throws CryptoException {
        super("EC", Args.notNull(key, "ECPrivateKey"));
        ECCCurveId curve = ECCCurveId.findECCCurveId(this.getParameters());
        if (curve == null) {
            throw new CryptoException("unknown curve key");
        }
        this.curveId = curve;
        this.eccPublicKey = this.buildPublicKey(this.getD(), this.getDomainParameters(), curve.getCurveId());
        this.keyData = this.buildKeyData();
    }

    public ECCCardExternalPrivateKey(ECPrivateKeyParameters ecParams, int curveId) throws CryptoException {
        super("EC", ecParams, ECCCardCurveHelper.buildECParameterSpec(ecParams));
        ECCCurveId curve = ECCCurveId.findECCCurveId(curveId);
        if (curve == null) {
            throw new CryptoException("unknown curve name: " + curveId);
        }
        this.curveId = curve;
        this.eccPublicKey = this.buildPublicKey(this.getD(), ecParams.getParameters(), curveId);
        this.keyData = this.buildKeyData();
    }

    public static PrivateKey buildExternalSoftKey(byte[] priKeyData) throws CryptoException {
        int curveId = ECCCardBigIntegers.parseInt(priKeyData, 0);
        return new ECCCardExternalPrivateKey(ECCCardExternalPrivateKey.parseEccKey(priKeyData), curveId);
    }

    private final ECDomainParameters getDomainParameters() {
        return ECCCardCurveHelper.buildECDomainParameters(this.getParameters());
    }

    private final ECCCardPublicKey buildPublicKey(BigInteger d, ECDomainParameters params, int curveId) throws CryptoException {
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        ECPoint Q = multiplier.multiply(params.getG(), d).normalize();
        return new ECCCardPublicKey(new ECPublicKeyParameters(Q, params), curveId);
    }

    private static BCECPrivateKey parseEccKey(byte[] priKeyData) throws CryptoException {
        int id = ECCCardBigIntegers.parseInt(priKeyData, 0);
        ECCCurveId curveId = ECCCurveId.findECCCurveId(id);
        if (curveId == null) {
            throw new CryptoException("unknown curve id: " + id);
        }
        int bitLength = ECCCardBigIntegers.parseInt(priKeyData, 4);
        if (bitLength != curveId.getCurveBitLength()) {
            throw new CryptoException("invalid curve bitLength: " + bitLength + " for " + (Object)((Object)curveId));
        }
        byte[] dBytes = ECCCardBigIntegers.parseBytes(priKeyData, 8, 66);
        ECDomainParameters params = ECCCardCurveHelper.buildECDomainParameters(curveId.getCurveParams());
        ECPrivateKeyParameters pubKeyParams = new ECPrivateKeyParameters(new BigInteger(1, dBytes), params);
        ECParameterSpec ecSpec = curveId.getCurveParams();
        return new BCECPrivateKey("EC", pubKeyParams, ecSpec);
    }

    public final boolean isInternalKey() {
        return false;
    }

    public final int getKeyIndex() {
        return 0;
    }

    public int getKeyUsage() {
        return 0;
    }

    public ECCCurveId getCurveId() {
        return this.curveId == null ? null : this.curveId;
    }

    public final int getCurveBitLength() {
        return this.curveId == null ? 0 : this.curveId.getCurveBitLength();
    }

    public final int getCurveByteLength() {
        return this.curveId == null ? 0 : this.curveId.getCurveBytesLength();
    }

    public final ECCCardPublicKey getECCPublicKey() {
        return this.eccPublicKey;
    }

    public final String dumpPublicKey() {
        ECCCardPublicKey pubKey;
        if (this.pubKeyInfo == null && (pubKey = this.getECCPublicKey()) != null) {
            this.pubKeyInfo = ECCCardKeyHelper.dumpPublicKey(pubKey.getPubX(), pubKey.getPubY(), pubKey.getPubH());
        }
        return this.pubKeyInfo;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ECCCardExternalPrivateKey [curveId=").append((Object)this.curveId);
        builder.append(",isInternalKey=").append(this.isInternalKey());
        builder.append(",pubX=").append(DataHelper.toHexString(this.getPubX()));
        builder.append(",pubY=").append(DataHelper.toHexString(this.getPubY()));
        builder.append(",pubH=").append(DataHelper.toHexString(this.getPubH()));
        builder.append(",md5D=").append(NumberHelper.md5(this.getSecD()));
        builder.append("]");
        return builder.toString();
    }

    public byte[] getPubX() {
        ECCCardPublicKey pubKey = this.getECCPublicKey();
        byte[] pubX = null;
        if (pubKey != null) {
            pubX = pubKey.getPubX();
        }
        return pubX;
    }

    public byte[] getPubY() {
        ECCCardPublicKey pubKey = this.getECCPublicKey();
        byte[] pubY = null;
        if (pubKey != null) {
            pubY = pubKey.getPubY();
        }
        return pubY;
    }

    public byte[] getSecD() {
        ECCCardPublicKey pubKey = this.getECCPublicKey();
        byte[] pubY = null;
        if (pubKey != null) {
            pubY = pubKey.getPubY();
        }
        return pubY;
    }

    public byte[] getPubH() {
        ECCCardPublicKey pubKey = this.getECCPublicKey();
        byte[] pubH = null;
        if (pubKey != null) {
            pubH = pubKey.getPubH();
        }
        return pubH;
    }

    public byte[] keyData() throws CryptoException {
        return this.keyData == null ? null : (byte[])this.keyData.clone();
    }

    private final byte[] buildKeyData() {
        byte[] keyData = new byte[74];
        int offset = 0;
        try {
            byte[] xBytes = ECCCardBigIntegers.fillBytes("ECC#pubD", this.getD().toByteArray(), 66);
            offset += ECCCardBigIntegers.copyInteger(this.curveId.getCurveId(), keyData, offset);
            offset += ECCCardBigIntegers.copyInteger(this.curveId.getCurveBitLength(), keyData, offset);
            offset += ECCCardBigIntegers.copyBytes("ECC#pubD", xBytes, keyData, offset);
        }
        catch (CryptoException e) {
            throw new IllegalArgumentException("buildKeyData failure", e);
        }
        return keyData;
    }
}

