/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardExternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardInternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardPublicKey;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.jcajce.provider.SADKProvider;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECKey;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class ECCCardKeyHelper {
    private ECCCardKeyHelper() {
    }

    public static final PublicKey decodeECPublicKey(byte[] x509SoftKeyData) throws CryptoException {
        if (x509SoftKeyData == null) {
            throw new CryptoParameterException("ECCCard decodeECPublicKey failure with null publicKey");
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("EC", SADKProvider.INSTANCE());
            X509EncodedKeySpec x509spec = new X509EncodedKeySpec(x509SoftKeyData);
            PublicKey pubKey = kf.generatePublic(x509spec);
            return new ECCCardPublicKey((BCECPublicKey)pubKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoParameterException("ECCCard decodeECPublicKey failure with NoSuchAlgorithm", e);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoParameterException("ECCCard decodeECPublicKey failure with InvalidKeySpec", e);
        }
    }

    public static final PrivateKey decodeECPrivateKey(byte[] pkcs8SoftKeyData) throws CryptoException {
        if (pkcs8SoftKeyData == null) {
            throw new CryptoParameterException("ECCCard decodeECPrivateKey failure with null privateKey");
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("EC", SADKProvider.INSTANCE());
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8SoftKeyData);
            PrivateKey privKey = kf.generatePrivate(keySpec);
            return new ECCCardExternalPrivateKey((BCECPrivateKey)privKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoParameterException("ECCCard decodeECPrivateKey failure with NoSuchAlgorithm", e);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoParameterException("ECCCard decodeECPrivateKey failure with InvalidKeySpec", e);
        }
    }

    public static final PublicKey buildPublicKey(PublicKey publicKey) throws CryptoException {
        ECCCardPublicKey pubKey;
        if (publicKey == null) {
            throw new CryptoParameterException("ECCCard buildExternalPublicKey failure with null publicKey");
        }
        if (publicKey instanceof ECCCardPublicKey) {
            pubKey = (ECCCardPublicKey)publicKey;
        } else if (publicKey instanceof BCECPublicKey) {
            pubKey = new ECCCardPublicKey((BCECPublicKey)publicKey);
        } else {
            throw new CryptoException("ECCCard buildExternalPublicKey failure with not support key: " + publicKey.getClass());
        }
        return pubKey;
    }

    public static final PrivateKey buildPrivateKey(PrivateKey privateKey) throws CryptoException {
        ECKey privKey;
        if (privateKey == null) {
            throw new CryptoParameterException("ECCCard buildExternalPrivateKey failure with null privateKey");
        }
        if (privateKey instanceof ECCCardInternalPrivateKey) {
            privKey = (ECCCardInternalPrivateKey)privateKey;
        } else if (privateKey instanceof ECCCardExternalPrivateKey) {
            privKey = (ECCCardExternalPrivateKey)privateKey;
        } else if (privateKey instanceof BCECPrivateKey) {
            privKey = new ECCCardExternalPrivateKey((BCECPrivateKey)privateKey);
        } else {
            throw new CryptoException("ECCCard buildExternalPrivateKey failure with not support key: " + privateKey.getClass());
        }
        return privKey;
    }

    public static final String dumpPublicKey(byte[] pubX, byte[] pubY, byte[] pubH) {
        return String.format("X|Y|H=%s|%s|%s", DataHelper.toHexString(pubX), DataHelper.toHexString(pubY), DataHelper.toHexString(pubH));
    }
}

