/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardBigIntegers;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardKey;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardRefPublicKeyParams;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;

public final class RSACardPublicKey
extends BCRSAPublicKey
implements RSACardKey {
    private static final long serialVersionUID = 1980104964921838735L;
    private final int bitLength;
    private final int keyIndex;
    private final int keyUsage;
    private final byte[] keyData;

    private RSACardPublicKey(int keyIndex, int keyUsage, byte[] pubKeyData) throws CryptoException {
        super(new RSACardRefPublicKeyParams((byte[])pubKeyData).params);
        this.bitLength = RSACardBigIntegers.parseBitLength(pubKeyData);
        this.keyIndex = keyIndex;
        this.keyUsage = keyUsage;
        this.keyData = pubKeyData;
    }

    static final RSACardPublicKey buildExternalSoftKey(byte[] pubKeyData) throws CryptoException {
        return new RSACardPublicKey(-1, -1, pubKeyData);
    }

    static final RSACardPublicKey buildInternalHardKey(int keyIndex, int keyUsage, byte[] pubKeyData) throws CryptoException {
        if (keyIndex <= 0) {
            throw new CryptoException("RSACard buildInternalHardKey failure with keyIndex=" + keyIndex);
        }
        return new RSACardPublicKey(keyIndex, keyUsage, pubKeyData);
    }

    public final String getAlgorithm() {
        return "RSA";
    }

    public final String getFormat() {
        return "X.509";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RSACardPublicKey [bitLength=").append(this.bitLength);
        builder.append(",keyIndex=").append(this.keyIndex);
        builder.append(",keyUsage=").append(this.keyUsage);
        builder.append(",isInternalKey=").append(this.isInternalKey());
        builder.append(",pubKeyData=").append(DataHelper.toHexString(this.keyData));
        builder.append("]");
        return builder.toString();
    }

    public final byte[] getEncoded() {
        return super.getEncoded();
    }

    public final boolean isInternalKey() {
        return this.keyIndex > 0;
    }

    public final int getKeyIndex() {
        return this.keyIndex;
    }

    public int getKeyUsage() {
        return this.keyUsage;
    }

    public final int modulusBitsLength() {
        return this.bitLength;
    }

    public final int modulusByteLength() {
        return this.bitLength >> 3;
    }

    public final byte[] keyData() throws CryptoException {
        return (byte[])this.keyData.clone();
    }

    public final String dumpPublicKey() {
        return "pubKeyData=" + DataHelper.toHexString(this.keyData, 0, 1028);
    }
}

