/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.sm2;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardBigIntegers;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardKey;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPublicKey;
import java.math.BigInteger;

public final class SM2CardPublicKey
extends GMTPublicKey
implements SM2CardKey {
    private static final long serialVersionUID = -8898247181202392135L;
    private static final int STRENGTH = 32;
    private final int bitLength;
    private final int keyIndex;
    private final int keyUsage;
    private final byte[] keyData;
    private String pubKeyInfo;

    public SM2CardPublicKey(ECPublicKeyParameters ecParams) {
        super(ecParams);
        this.bitLength = 256;
        this.keyIndex = 0;
        this.keyUsage = 0;
        this.keyData = this.buildKeyData();
    }

    public SM2CardPublicKey(byte[] bPubX, byte[] bPubY) {
        super(bPubX, bPubY);
        this.bitLength = 256;
        this.keyIndex = 0;
        this.keyUsage = 0;
        this.keyData = this.buildKeyData();
    }

    public SM2CardPublicKey(byte[] encoded) {
        super(encoded);
        this.bitLength = 256;
        this.keyIndex = 0;
        this.keyUsage = 0;
        this.keyData = this.buildKeyData();
    }

    public SM2CardPublicKey(BigInteger iPubX, BigInteger iPubY) {
        super(iPubX, iPubY);
        this.bitLength = 256;
        this.keyIndex = 0;
        this.keyUsage = 0;
        this.keyData = this.buildKeyData();
    }

    private SM2CardPublicKey(int keyIndex, int keyUsage, byte[] pubKeyData) throws CryptoException {
        super(SM2CardPublicKey.parsePubX(pubKeyData), SM2CardPublicKey.parsePubY(pubKeyData));
        this.bitLength = SM2CardBigIntegers.parseBitLength(pubKeyData);
        this.keyIndex = keyIndex;
        this.keyUsage = 0;
        this.keyData = pubKeyData;
    }

    static final SM2CardPublicKey buildInternalKey(int keyIndex, int keyUsage, byte[] pubKeyData) throws CryptoException {
        if (keyIndex <= 0) {
            throw new CryptoException("SM2Card buildInternalKey failure with keyIndex=" + keyIndex);
        }
        return new SM2CardPublicKey(keyIndex, keyIndex, pubKeyData);
    }

    static final SM2CardPublicKey buildExternalKey(byte[] pubKeyData) throws CryptoException {
        return new SM2CardPublicKey(-1, -1, pubKeyData);
    }

    private static final byte[] parsePubX(byte[] pubKeyData) throws CryptoException {
        return SM2CardBigIntegers.parseBytes(pubKeyData, 4, 32);
    }

    private static final byte[] parsePubY(byte[] pubKeyData) throws CryptoException {
        return SM2CardBigIntegers.parseBytes(pubKeyData, 36, 32);
    }

    private final byte[] buildKeyData() {
        byte[] pubX = this.getPubX();
        if (pubX == null || pubX.length != 32) {
            throw new IllegalArgumentException("buildKeyData failure invalid SM2#pubX");
        }
        byte[] pubY = this.getPubY();
        if (pubY == null || pubY.length != 32) {
            throw new IllegalArgumentException("buildKeyData failure invalid SM2#pubY");
        }
        byte[] keyData = new byte[68];
        int offset = 0;
        try {
            offset += SM2CardBigIntegers.copyBitLength(this.bitLength, keyData, offset);
            offset += SM2CardBigIntegers.copyBytes("SM2#pubX", pubX, keyData, offset);
            offset += SM2CardBigIntegers.copyBytes("SM2#pubY", pubY, keyData, offset);
        }
        catch (CryptoException e) {
            throw new IllegalArgumentException("buildKeyData failure", e);
        }
        return keyData;
    }

    static final String buildKeyInfo(byte[] pubX, byte[] pubY, byte[] defaultZ) {
        return String.format("X|Y|Z=%s|%s|%s", DataHelper.toHexString(pubX), DataHelper.toHexString(pubY), DataHelper.toHexString(defaultZ));
    }

    public final String getAlgorithm() {
        return "SM2";
    }

    public final String getFormat() {
        return "X.509";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SM2CardPublicKey [bitLength=").append(this.bitLength);
        builder.append(",keyIndex=").append(this.keyIndex);
        builder.append(",keyUsage=").append(this.keyUsage);
        builder.append(",isInternalKey=").append(this.isInternalKey());
        builder.append(",pubX=").append(DataHelper.toHexString(this.getPubX()));
        builder.append(",pubY=").append(DataHelper.toHexString(this.getPubY()));
        builder.append(",defZ=").append(DataHelper.toHexString(this.getDefaultZ()));
        builder.append(",pubKeyData=").append(DataHelper.toHexString(this.keyData));
        builder.append("]");
        return builder.toString();
    }

    public final byte[] getEncoded() {
        return super.getEncoded();
    }

    public final boolean isInternalKey() {
        return this.keyIndex > 0;
    }

    public final int getKeyIndex() {
        return this.keyIndex;
    }

    public int getKeyUsage() {
        return this.keyUsage;
    }

    public final int modulusBitsLength() {
        return this.bitLength;
    }

    public final int modulusByteLength() {
        return this.bitLength >> 3;
    }

    public final byte[] keyData() throws CryptoException {
        return (byte[])this.keyData.clone();
    }

    public final String dumpPublicKey() {
        if (this.pubKeyInfo == null) {
            this.pubKeyInfo = SM2CardPublicKey.buildKeyInfo(this.getPubX(), this.getPubY(), this.getDefaultZ());
        }
        return this.pubKeyInfo;
    }
}

