/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.cavium;

import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.logging.LoggerManager;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Formatter;

final class CaviumRSAPublicKey
implements RSAPublicKey {
    private static final long serialVersionUID = 4067087213271390746L;
    private final RSAPublicKey publicKeyRef;
    private final byte[] x509EncodedBytes;
    final byte[] jniEncodedBytes;
    final int moduleBytesLength;

    public CaviumRSAPublicKey(RSAPublicKey publicKeyRef) throws CardException {
        if (publicKeyRef == null) {
            throw new CardParameterException("missing publicKeyRef");
        }
        this.publicKeyRef = publicKeyRef;
        this.jniEncodedBytes = this.buildEncodedBytes(publicKeyRef);
        this.moduleBytesLength = (7 + publicKeyRef.getModulus().bitLength()) / 8;
        try {
            this.x509EncodedBytes = publicKeyRef.getEncoded();
        }
        catch (Exception e) {
            throw new CardParameterException("invalid publicKeyRef with x509EncodedBytes", e);
        }
    }

    public String getAlgorithm() {
        return this.publicKeyRef.getAlgorithm();
    }

    public String getFormat() {
        return this.publicKeyRef.getFormat();
    }

    public byte[] getEncoded() {
        return this.x509EncodedBytes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.jniEncodedBytes);
        result = 31 * result + this.moduleBytesLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CaviumRSAPublicKey other = (CaviumRSAPublicKey)obj;
        if (!Arrays.equals(this.jniEncodedBytes, other.jniEncodedBytes)) {
            return false;
        }
        return this.moduleBytesLength == other.moduleBytesLength;
    }

    public String toString() {
        Formatter builder = new Formatter();
        builder.format("CaviumRSAPublicKey ", new Object[0]);
        try {
            builder.format("\n%8s%20s=0x%s", "", "Modulus", this.publicKeyRef.getModulus().toString(16));
            builder.format("\n%8s%20s=0x%s", "", "PublicExponent", this.publicKeyRef.getPublicExponent().toString(16));
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("CaviumRSAPublicKey dump detail invalid", (Throwable)e);
            builder.format("\n%8s%20s=0x%s", "", "k", "failure");
        }
        builder.format("\n%4s%20s=0x%s", "", "jniEncodedBytes", Hex.toHexString(this.jniEncodedBytes));
        builder.format("\n%4s%20s=%s", "", "moduleBytesLength", this.moduleBytesLength);
        String output = builder.toString();
        builder.close();
        return output;
    }

    private final byte[] buildEncodedBytes(RSAPublicKey publicKey) throws CardException {
        byte[] jniEncodedBytes = null;
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new ASN1Integer(publicKey.getModulus()));
            v.add(new ASN1Integer(publicKey.getPublicExponent()));
            jniEncodedBytes = new DERSequence(v).getEncoded();
        }
        catch (IOException e) {
            throw new CardParameterException("buildEncodedBytes failure", e);
        }
        return jniEncodedBytes;
    }

    public BigInteger getModulus() {
        return this.publicKeyRef.getModulus();
    }

    public BigInteger getPublicExponent() {
        return this.publicKeyRef.getPublicExponent();
    }
}

