/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.ASN1GeneralizedTime;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1UTCTime;
import cfca.sadk.org.bouncycastle.asn1.cms.Time;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x500.X500NameStyle;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.x509.certificate.CRLCertTag;
import cfca.sadk.x509.certificate.CRLLengths;
import cfca.sadk.x509.certificate.CRLTag;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;

final class CRLStructure {
    final CRLTag contextTag;
    final CRLTag algorithmTag;
    final CRLTag signatureTag;
    final CRLCertTag context;
    final AlgorithmIdentifier signatureAlgorithm;
    final byte[] signatureValue;

    CRLStructure(RandomAccessFile randomFile, int position, long fileLength, byte[] encoding) throws PKIException {
        int index = position;
        this.contextTag = this.lengthsFrom(randomFile, 48, fileLength, index, "tbsCertList", encoding);
        this.algorithmTag = this.lengthsFrom(randomFile, 48, fileLength, index += this.contextTag.length, "signatureAlgorithm", encoding);
        this.signatureTag = this.lengthsFrom(randomFile, 3, fileLength, index += this.algorithmTag.length, "signatureValue", encoding);
        this.context = this.decodeCRLTBSCertList(randomFile, this.contextTag, fileLength, encoding);
        this.signatureAlgorithm = this.decodeSignatureAlgorithm(randomFile, this.algorithmTag, encoding);
        this.signatureValue = this.decodeSignatureValue(randomFile, this.signatureTag, encoding);
    }

    final String getIssuer(X500NameStyle style) {
        String value = null;
        if (this.context == null || this.context.issuer == null) {
            value = null;
        } else {
            X500Name x500IssuerName = this.context.issuer;
            X500Name cfca_issuer = new X500Name(style, x500IssuerName);
            value = cfca_issuer.toString();
        }
        return value;
    }

    final Date getThisUpdate() {
        Date value = null;
        value = this.context == null || this.context.thisUpdate == null ? null : this.context.thisUpdate.getDate();
        return value;
    }

    final Date getNextUpdate() {
        Date value = null;
        value = this.context == null || this.context.nextUpdate == null ? null : this.context.nextUpdate.getDate();
        return value;
    }

    final byte[] getSignature() {
        return this.signatureValue == null ? null : (byte[])this.signatureValue.clone();
    }

    final String getSignatureAlgName() {
        String value = null;
        if (this.signatureAlgorithm != null) {
            value = Mechanism.getSignatureAlgName(this.signatureAlgorithm);
        }
        return value;
    }

    final String getSignatureAlgOID() {
        String value = null;
        if (this.signatureAlgorithm != null) {
            value = this.signatureAlgorithm.getAlgorithm().getId();
        }
        return value;
    }

    final byte[] getTBSEncoded(byte[] encoding) throws PKIException {
        byte[] tbsEncodedData = null;
        try {
            tbsEncodedData = new byte[this.contextTag.length];
            System.arraycopy(encoding, this.contextTag.begin, tbsEncodedData, 0, tbsEncodedData.length);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.TBSCRL_BYTES, PKIException.TBSCRL_BYTES_DES, e);
        }
        catch (Throwable e) {
            throw new PKIException(PKIException.TBSCRL_BYTES, PKIException.TBSCRL_BYTES_DES + "-->" + e.getMessage());
        }
        return tbsEncodedData;
    }

    final boolean isNoneCertTag() {
        return this.context == null || this.context.certsTag == null;
    }

    final StringBuffer dump(StringBuffer builder) {
        builder.append("\n\t contextTag=");
        builder.append(this.contextTag);
        builder.append(this.context);
        builder.append("\n\t algorithmTag=");
        builder.append(this.algorithmTag);
        if (this.signatureAlgorithm != null) {
            builder.append("\n\t\t oid=");
            builder.append(this.signatureAlgorithm.getAlgorithm());
            builder.append("(");
            builder.append(Mechanism.getSignatureAlgName(this.signatureAlgorithm));
            builder.append(")");
        }
        builder.append("\n\t signatureTag=");
        builder.append(this.signatureTag);
        if (this.signatureValue != null) {
            builder.append("\n\t\t value=0x");
            builder.append(Hex.toHexString(this.signatureValue));
        }
        return builder;
    }

    final AlgorithmIdentifier decodeSignatureAlgorithm(RandomAccessFile randomFile, CRLTag algorithmTag, byte[] encoding) throws PKIException {
        try {
            byte[] signatureAlgorithmBytes = null;
            signatureAlgorithmBytes = encoding != null ? algorithmTag.valueFrom(encoding) : algorithmTag.valueFrom(randomFile, algorithmTag.begin, 1024);
            AlgorithmIdentifier signatureAlgorithm = AlgorithmIdentifier.getInstance(signatureAlgorithmBytes);
            return signatureAlgorithm;
        }
        catch (Exception e) {
            throw new PKIException("Failure when decodeAlgorithm", e);
        }
    }

    final byte[] decodeSignatureValue(RandomAccessFile randomFile, CRLTag signatureTag, byte[] encoding) throws PKIException {
        try {
            byte[] signatureValueBytes = null;
            signatureValueBytes = encoding != null ? signatureTag.valueFrom(encoding) : signatureTag.valueFrom(randomFile, signatureTag.begin, 1024);
            CRLLengths lengths = CRLLengths.buildLengthsFrom(signatureValueBytes, 0, 3);
            byte[] signatureValue = null;
            if (signatureValueBytes[lengths.headLength] == 0 && lengths.valueLength % 64 != 0) {
                signatureValue = new byte[lengths.valueLength - 1];
                System.arraycopy(signatureValueBytes, lengths.headLength + 1, signatureValue, 0, signatureValue.length);
            }
            return signatureValue;
        }
        catch (Exception e) {
            throw new PKIException("Failure when decodeSignatureValue", e);
        }
    }

    final CRLCertTag decodeCRLTBSCertList(RandomAccessFile randomFile, CRLTag contextTag, long fileLength, byte[] encoding) throws PKIException {
        X500Name issuer;
        AlgorithmIdentifier signature;
        CRLLengths asn1Lentgs;
        boolean fileCRL;
        int textLength = contextTag.length;
        int offset = 0;
        if (encoding == null) {
            encoding = this.contentPartFrom(randomFile, contextTag, fileLength);
            offset = 0;
            fileCRL = true;
        } else {
            offset = contextTag.begin;
            fileCRL = false;
        }
        try {
            asn1Lentgs = CRLLengths.buildLengthsFrom(encoding, offset, 48);
        }
        catch (Exception e) {
            throw new PKIException("Failure on decodeCRLTBSCertList  when readTBSCertList-Head", e);
        }
        if (asn1Lentgs.asn1Length != textLength) {
            throw new PKIException("Failure on decodeCRLTBSCertList  with invalid asn1Length --> " + asn1Lentgs.asn1Length);
        }
        offset += asn1Lentgs.headLength;
        byte[] value = null;
        ASN1Integer version = null;
        try {
            if (encoding[offset] == 2) {
                value = this.valueFrom(encoding, offset);
                version = ASN1Integer.getInstance(value);
                offset += value.length;
            }
        }
        catch (Exception e) {
            throw new PKIException("Failure on decodeCRLTBSCertList  when readVersion", e);
        }
        try {
            value = this.valueFrom(encoding, offset);
            signature = AlgorithmIdentifier.getInstance(value);
            offset += value.length;
        }
        catch (Exception e) {
            throw new PKIException("Failure on decodeCRLTBSCertList  when readSignatureAlgorithm", e);
        }
        try {
            value = this.valueFrom(encoding, offset);
            issuer = X500Name.getInstance(value);
        }
        catch (Exception e) {
            throw new PKIException("Failure on decodeCRLTBSCertList  when readIssuerDN", e);
        }
        Time thisUpdate = null;
        if (encoding[offset += value.length] == 24 || encoding[offset] == 23) {
            try {
                value = this.valueFrom(encoding, offset);
                thisUpdate = encoding[offset] == 24 ? Time.getInstance(ASN1GeneralizedTime.getInstance(value)) : Time.getInstance(ASN1UTCTime.getInstance(value));
                offset += value.length;
            }
            catch (Exception e) {
                throw new PKIException("Failure on decodeCRLTBSCertList  when readThisUpdate", e);
            }
        } else {
            throw new PKIException("Failure on decodeCRLTBSCertList  when readThisUpdate with invalid thisUpdate --> " + encoding[offset]);
        }
        Time nextUpdate = null;
        try {
            if (encoding[offset] == 24 || encoding[offset] == 23) {
                value = this.valueFrom(encoding, offset);
                nextUpdate = encoding[offset] == 24 ? Time.getInstance(ASN1GeneralizedTime.getInstance(value)) : Time.getInstance(ASN1UTCTime.getInstance(value));
                offset += value.length;
            }
        }
        catch (Exception e) {
            throw new PKIException("Failure on decodeCRLTBSCertList  when readNextUpdate", e);
        }
        CRLTag certsTag = null;
        try {
            if (encoding[offset] == 48) {
                CRLLengths lengths = CRLLengths.buildLengthsFrom(encoding, offset, 0);
                offset = fileCRL ? (offset += contextTag.begin) : (offset += lengths.headLength);
                certsTag = new CRLTag(offset, lengths.asn1Length, "CRLCertsTag");
                offset += lengths.asn1Length;
            }
        }
        catch (Exception e) {
            throw new PKIException("Failure on decodeCRLTBSCertList  when readRevokedCertificates", e);
        }
        return new CRLCertTag(version, signature, issuer, thisUpdate, nextUpdate, certsTag);
    }

    final byte[] contentPartFrom(RandomAccessFile randomFile, CRLTag contextTag, long fileLength) throws PKIException {
        byte[] encoding;
        int textLength = contextTag.length;
        try {
            randomFile.seek(contextTag.begin);
            encoding = new byte[textLength < 65536 ? textLength : 65536];
            int remain = encoding.length;
            int offset = 0;
            int length = 0;
            while ((length = randomFile.read(encoding, offset, encoding.length - offset)) > 0 && (offset += length) != encoding.length && (remain -= length) > 0) {
            }
        }
        catch (Exception e) {
            throw new PKIException("Failure on decodeCRLTBSCertList  readFile", e);
        }
        return encoding;
    }

    final byte[] valueFrom(RandomAccessFile randomFile, int position, int expectLength, byte[] encodings) throws PKIException {
        byte[] value = null;
        try {
            if (encodings != null) {
                CRLLengths lengths = CRLLengths.buildLengthsFrom(encodings, position, 0);
                value = new byte[lengths.asn1Length];
                System.arraycopy(encodings, position, value, 0, value.length);
            } else {
                value = new byte[expectLength > 65536 ? 65536 : expectLength];
                randomFile.seek(position);
                int remain = value.length;
                int length = 0;
                while ((length = randomFile.read(value, length, value.length - length)) > 0 && (remain -= length) > 0) {
                }
            }
        }
        catch (Exception e) {
            throw new PKIException("asn1CRLTag - read block failure[position=" + position + ",expectLength" + expectLength + "]", e);
        }
        catch (Throwable e) {
            throw new PKIException("asn1CRLTag - read block failure[position=" + position + "]: " + e.getMessage());
        }
        return value;
    }

    final byte[] valueFrom(byte[] encodings, int position) throws PKIException {
        byte[] value = null;
        try {
            CRLLengths lengths = CRLLengths.buildLengthsFrom(encodings, position, 0);
            value = new byte[lengths.asn1Length];
            System.arraycopy(encodings, position, value, 0, value.length);
        }
        catch (Exception e) {
            throw new PKIException("asn1CRLTag - read block failure[position=" + position + "]", e);
        }
        catch (Throwable e) {
            throw new PKIException("asn1CRLTag - read block failure[position=" + position + "]: " + e.getMessage());
        }
        return value;
    }

    final CRLTag lengthsFrom(RandomAccessFile randomFile, int asn1Tag, long fileLength, int position, String name, byte[] derCRL) throws PKIException {
        CRLLengths lens;
        long maxLength = 0L;
        try {
            if (derCRL != null) {
                maxLength = derCRL.length;
                lens = CRLLengths.buildLengthsFrom(derCRL, position, asn1Tag);
            } else {
                maxLength = fileLength;
                byte[] header = new byte[20];
                randomFile.seek(position);
                int remain = header.length;
                int length = 0;
                while ((length = randomFile.read(header, length, header.length - length)) > 0 && (remain -= length) > 0) {
                }
                lens = CRLLengths.buildLengthsFrom(header, 0, asn1Tag);
            }
        }
        catch (IOException e) {
            throw new PKIException("asn1Tag - read" + name + "Lengths failure", e);
        }
        catch (Exception e) {
            throw new PKIException("asn1Tag - read" + name + "Lengths failure", e);
        }
        CRLTag lengths = new CRLTag(position, lens.asn1Length, name);
        lengths.checkLengths(maxLength);
        return lengths;
    }
}

