/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.base;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import netbank.firm.base.Base64;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;

public class AESUtils {
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static byte[] encrypt(byte[] key, byte[] source) throws Exception {
        key = AESUtils.formatKey(key);
        Cipher cipher = Cipher.getInstance(DEFAULT_ALGORITHM);
        SecretKeySpec skey = new SecretKeySpec(key, KEY_ALGORITHM);
        cipher.init(1, skey);
        return cipher.doFinal(source);
    }

    public static byte[] decrypt(byte[] key, byte[] cipher) throws Exception {
        key = AESUtils.formatKey(key);
        Cipher cipher0 = Cipher.getInstance(DEFAULT_ALGORITHM);
        SecretKeySpec skey = new SecretKeySpec(key, KEY_ALGORITHM);
        cipher0.init(2, skey);
        return cipher0.doFinal(cipher);
    }

    public static String encryptWithBase64(byte[] key, byte[] source) throws Exception {
        byte[] ret = AESUtils.encrypt(key, source);
        return Base64.encode(ret);
    }

    public static byte[] decryptWithBase64(byte[] key, String cipherByBase64) throws Exception {
        byte[] orginal = Base64.decode(cipherByBase64);
        return AESUtils.decrypt(key, orginal);
    }

    public static byte[] formatKey(byte[] key) throws DcfirmException {
        if (key == null) {
            throw new DcfirmException(ExceptionCode.U108);
        }
        if (key.length > 16) {
            byte[] ret = new byte[16];
            System.arraycopy(key, 0, ret, 0, 16);
            return ret;
        }
        if (key.length == 16) {
            return key;
        }
        byte[] ret = new byte[16];
        System.arraycopy(key, 0, ret, 0, key.length);
        for (int i = 0; i < 16 - key.length; ++i) {
            ret[key.length + i] = 32;
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        byte[] ret = AESUtils.encrypt("1100343164".getBytes(), "hello".getBytes());
        System.out.println(new String(ret));
        byte[] ret0 = AESUtils.decrypt("1100343164      ".getBytes(), ret);
        System.out.println("\u7528\u79d8\u94a5[1100343164      ]\u89e3\u5bc6:" + new String(ret0));
        String retByBase64 = AESUtils.encryptWithBase64("1100343164      1".getBytes(), "hello".getBytes());
        System.out.println(retByBase64);
        byte[] ret1 = AESUtils.decryptWithBase64("1100343164".getBytes(), retByBase64);
        System.out.println(new String(ret1));
        byte[] ret2 = AESUtils.decryptWithBase64("1100343163".getBytes(), retByBase64);
        System.out.println(new String(ret2));
    }
}

