/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.base;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public final class SystemProperty {
    protected static final Logger logger = LoggerFactory.getLogger(SystemProperty.class);
    private Properties systProps;
    private static SystemProperty instance;
    private static String _SYST_PROPERTIES;
    private static String _KEY_SYSTNAME;
    private static String _KEY_HOSTNAME;
    private static String _MACHINE_ID;
    private String hostname = null;

    private SystemProperty() {
        this.init();
    }

    public static SystemProperty getInstance() {
        if (instance == null) {
            instance = new SystemProperty();
        }
        return instance;
    }

    private void init() {
        this.hostname = this.getHostName();
        if (this.systProps == null) {
            URL url = this.getClassLoader().getResource(_SYST_PROPERTIES);
            if (url == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("try to load syst-property from file:" + _SYST_PROPERTIES + ",but not exists!");
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("try to load syst-property from file:" + _SYST_PROPERTIES);
            }
            try {
                InputStream is = url.openStream();
                this.systProps = new Properties();
                this.systProps.load(is);
            }
            catch (Exception e) {
                logger.error("load syst-property from file:" + _SYST_PROPERTIES + " failed!the url is:" + url.toExternalForm(), (Throwable)e);
            }
        }
    }

    public String getSysName() {
        return this.getSystProperty(_KEY_SYSTNAME);
    }

    private String getHostName() {
        String hn = null;
        try {
            hn = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            logger.error("get Machineid failed for:", (Throwable)e);
        }
        return hn;
    }

    public String getMachineID() {
        _MACHINE_ID = this.getInnerSystProperty(_KEY_HOSTNAME);
        if (_MACHINE_ID == null) {
            if (this.hostname == null) {
                this.hostname = this.getHostName();
            }
            if (this.hostname != null) {
                try {
                    _MACHINE_ID = this.hostname.substring(this.hostname.length() < 2 ? 0 : this.hostname.length() - 2);
                }
                catch (Exception e) {
                    logger.error("get Machineid failed for:", (Throwable)e);
                }
            }
        }
        return _MACHINE_ID;
    }

    public String getSystProperty(String key) {
        if (this.systProps == null) {
            return this.getInnerSystProperty(key);
        }
        String value = this.systProps.getProperty(key);
        if (value == null) {
            return this.getInnerSystProperty(key);
        }
        return value;
    }

    public String getProperty(String key, boolean force) throws Exception {
        if (this.systProps == null) {
            return this.getInnerSystProperty(key);
        }
        String value = this.systProps.getProperty(key);
        if (force && StringUtils.isBlank((String)value)) {
            String message = "\u53c2\u6570[" + key + "]\u503c\u672a\u914d\u7f6e\u3002";
            throw new Exception(message);
        }
        return value;
    }

    public String getProperty(String key, String defaultValue) {
        if (this.systProps == null) {
            return this.getInnerSystProperty(key);
        }
        return this.systProps.getProperty(key, defaultValue);
    }

    private String getInnerSystProperty(String key) {
        String value = System.getProperty(key);
        return value;
    }

    private ClassLoader getClassLoader() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            return ResourceUtils.class.getClassLoader();
        }
    }

    static {
        _SYST_PROPERTIES = "system.properties";
        _KEY_SYSTNAME = "systname";
        _KEY_HOSTNAME = "hostAlias";
        _MACHINE_ID = null;
    }
}

