/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.file;

import java.io.File;
import java.io.FileNotFoundException;
import netbank.firm.file.FileUtils;
import org.apache.commons.lang.StringUtils;

public class FileService {
    private String nasPath;
    private long maxSize = 0xF00000L;

    public String updateFile4Send(String bizCode, File file) throws Exception {
        this.checkBizCode(bizCode);
        this.checkFileLength(file);
        return FileUtils.restore4Send(bizCode, file, this.nasPath);
    }

    public File getFile4Receive(String fileName, String fileId) throws Exception {
        File file = FileUtils.getFile4Receive(this.nasPath, fileName, fileId);
        if (!file.exists()) {
            throw new FileNotFoundException("fileName:" + fileName + ",fileId:" + fileId + "\u6587\u4ef6\u627e\u4e0d\u5230\u3002");
        }
        return file;
    }

    public File getFile4Send(String fileName, String fileId) throws Exception {
        File file = FileUtils.getFile4Send(this.nasPath, fileId, fileName);
        if (!file.exists()) {
            throw new FileNotFoundException("fileName:" + fileName + ",fileId:" + fileId + "\u6587\u4ef6\u627e\u4e0d\u5230\u3002");
        }
        return file;
    }

    private void checkFileLength(File file) throws Exception {
        long fileLength = file.length();
        if (fileLength > this.maxSize) {
            throw new Exception("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u6700\u5927\u503c[" + this.maxSize + "]");
        }
    }

    private void checkBizCode(String bizCode) throws Exception {
        if (StringUtils.isBlank((String)bizCode)) {
            throw new Exception("\u4e1a\u52a1\u79cd\u7c7b\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        if (bizCode.length() != 3 || !StringUtils.isNumeric((String)bizCode)) {
            throw new Exception("\u4e1a\u52a1\u79cd\u7c7b\u503c\u975e\u6cd5\uff01");
        }
    }

    public String getNasPath() {
        return this.nasPath;
    }

    public void setNasPath(String nasPath) {
        this.nasPath = nasPath;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public static void main(String[] args) throws Exception {
        File file = new File("d:\\activemq-parent-5.14.1-source-release.zip");
        System.out.println(file.length());
    }
}

