/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.handler;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import netbank.firm.base.GzipUtil;
import netbank.firm.base.MD5Util;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.FileBlockRequest;
import netbank.firm.model.FileErrorResponse;
import netbank.firm.model.FileResponse;
import netbank.firm.model.FileResponseType;
import netbank.firm.model.FileStaticErrorResponse;
import netbank.firm.model.FileStaticRequest;
import netbank.firm.model.UploadResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResponseFileHandler
extends SimpleChannelInboundHandler<FileResponse<?>> {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected File sendFile;
    protected RandomAccessFile fis;
    protected int totalBlockNums;
    protected int blockSize;
    protected int lastBlockSize;
    protected int sendNums;
    protected int startBlockId;
    protected String ncid;
    private Boolean compress = new Boolean(true);
    private long maxSize = 0xF00000L;
    private ChannelPromise promise;

    protected void channelRead0(ChannelHandlerContext ctx, FileResponse<?> msg) throws Exception {
        this.ncid = msg.getNcid();
        if (FileResponseType.DATA == msg.getFileResponseType()) {
            this.LOG.info("\u7ba1\u9053id\uff1a" + ctx.channel().id() + "\u54cd\u5e94\u7c7b\u578b\uff1a" + (Object)((Object)msg.getFileResponseType()));
        } else {
            this.LOG.info("\u7ba1\u9053id\uff1a" + ctx.channel().id() + "\u5ba2\u6237\u53f7\uff1a" + this.ncid + "\u54cd\u5e94\u7c7b\u578b\uff1a" + (Object)((Object)msg.getFileResponseType()));
        }
        switch (msg.getFileResponseType()) {
            case UPLOAD: {
                if (this.errorCloseChannel(ctx, msg)) {
                    return;
                }
                UploadResponse ur = (UploadResponse)msg;
                AttributeKey ak = AttributeKey.valueOf((String)"FileID");
                ctx.channel().attr(ak).set((Object)ur.getFileId());
                if (!this.sendFile.exists()) {
                    throw new FileNotFoundException();
                }
                this.checkFileLength(this.sendFile);
                if (this.compress.booleanValue()) {
                    File isCompressFile = new File(this.sendFile.getAbsolutePath() + ".gz");
                    if (!isCompressFile.exists()) {
                        GzipUtil.gzip(this.sendFile.getAbsolutePath());
                    }
                    this.sendFile = new File(this.sendFile.getAbsolutePath() + ".gz");
                }
                String md5 = MD5Util.md5Digest(this.sendFile);
                FileStaticRequest fsr = new FileStaticRequest();
                fsr.setNcid(msg.getNcid());
                fsr.setFileLength((int)this.sendFile.length());
                fsr.setBlockSize(this.blockSize);
                fsr.setStartBlockId(this.startBlockId);
                fsr.setFileName(this.sendFile.getName());
                fsr.setFileFlag("U");
                fsr.setFileId(ur.getFileId());
                fsr.setFileMd(md5);
                fsr.setCompress(this.compress);
                this.totalBlockNums = fsr.getFileLength() / fsr.getBlockSize() + 1;
                this.lastBlockSize = fsr.getFileLength() % fsr.getBlockSize();
                this.blockSize = fsr.getBlockSize();
                if (this.lastBlockSize == 0 && this.totalBlockNums != 1) {
                    --this.totalBlockNums;
                    this.lastBlockSize = fsr.getBlockSize();
                }
                this.writeAndFlush(ctx, fsr);
                break;
            }
            case DOWNLOAD: {
                if (!this.errorCloseChannel(ctx, msg)) break;
                return;
            }
            case STATIC: {
                if (this.errorCloseChannel(ctx, msg)) {
                    return;
                }
                if (this.sendFile == null) {
                    AttributeKey ak = AttributeKey.valueOf((String)"sendFilePath");
                    String filePath = (String)ctx.channel().attr(ak).get();
                    this.sendFile = new File(filePath.trim());
                }
                AttributeKey compressKey = AttributeKey.valueOf((String)"isCompress");
                String isCompress = (String)ctx.channel().attr(compressKey).get();
                if (!StringUtils.isBlank((String)isCompress)) {
                    this.compress = "Y".equals(isCompress) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
                if (!this.sendFile.exists()) {
                    this.LOG.error("\u6587\u4ef6\u4e0d\u5b58\u5728:" + this.sendFile.getAbsolutePath());
                    FileStaticErrorResponse fsres = new FileStaticErrorResponse("\u6587\u4ef6\u4e0d\u5b58\u5728:" + this.sendFile.getName());
                    this.writeAndFlush(ctx, fsres);
                    ctx.close();
                }
                this.fis = new RandomAccessFile(this.sendFile, "r");
                this.totalBlockNums = (int)this.sendFile.length() / this.blockSize + 1;
                this.lastBlockSize = (int)this.sendFile.length() % this.blockSize;
                if (this.lastBlockSize == 0 && this.totalBlockNums != 1) {
                    --this.totalBlockNums;
                    this.lastBlockSize = this.blockSize;
                }
                byte[] blockData = new byte[this.sendNums + 1 == this.totalBlockNums ? this.lastBlockSize : this.blockSize];
                if (this.startBlockId > 1) {
                    this.fis.seek((this.startBlockId - 1) * this.blockSize);
                }
                this.fis.read(blockData);
                this.sendFileBlock(ctx, blockData);
                ++this.sendNums;
                break;
            }
            case DATA: {
                if (this.errorCloseChannel(ctx, msg)) {
                    return;
                }
                if (this.sendNums == this.totalBlockNums) {
                    this.LOG.debug("\u6536\u5230\u6587\u4ef6\u5168\u90e8\u63a5\u6536\u6307\u4ee4\uff0c\u7ed3\u675f\u672c\u6b21\u901a\u8baf");
                    if (this.fis != null) {
                        this.fis.close();
                    }
                    ctx.close();
                    if (this.promise != null) {
                        this.promise.setSuccess();
                    }
                    this.successHandler("\u6587\u4ef6\u53d1\u9001\u6210\u529f");
                    break;
                }
                byte[] blockData = new byte[this.sendNums + 1 == this.totalBlockNums ? this.lastBlockSize : this.blockSize];
                this.fis.read(blockData);
                this.sendFileBlock(ctx, blockData);
                ++this.sendNums;
            }
        }
    }

    private void sendFileBlock(ChannelHandlerContext ctx, byte[] block) {
        this.LOG.debug("\u53d1\u9001\u6587\u4ef6\u5757:" + this.sendNums);
        FileBlockRequest fbr = new FileBlockRequest(block);
        fbr.setNcid(this.ncid);
        this.writeAndFlush(ctx, fbr);
    }

    private void checkFileLength(File file) throws Exception {
        long fileLength = file.length();
        if (fileLength > this.maxSize) {
            throw new Exception("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u6700\u5927\u503c[" + this.maxSize + "]");
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.fis != null) {
            this.fis.close();
        }
        ctx.close();
        this.LOG.error(cause.getMessage(), cause);
        if (this.promise != null) {
            this.promise.setFailure(cause);
        }
        if (cause instanceof DcfirmException && ExceptionCode.S001.getCode().equals(((DcfirmException)cause).getErrCode())) {
            this.timeOutHandler(cause.getMessage());
        } else {
            this.failureHandler(cause.getMessage());
        }
    }

    private boolean errorCloseChannel(ChannelHandlerContext ctx, FileResponse<?> msg) throws Exception {
        if (msg instanceof FileErrorResponse) {
            FileErrorResponse err = (FileErrorResponse)msg;
            this.LOG.error(err.getErrMsg());
            if (this.fis != null) {
                this.fis.close();
            }
            ctx.close();
            if (this.promise != null) {
                this.promise.setFailure((Throwable)new Exception(err.getErrMsg()));
            }
            this.failureHandler(err.getErrMsg());
            return true;
        }
        return false;
    }

    private void writeAndFlush(ChannelHandlerContext ctx, Object obj) {
        ChannelFuture f = ctx.writeAndFlush(obj);
        f.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    protected abstract void successHandler(String var1);

    protected abstract void failureHandler(String var1);

    protected abstract void timeOutHandler(String var1);

    public void setSendFile(File sendFile) {
        this.sendFile = sendFile;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void setStartBlockId(int startBlockId) {
        this.startBlockId = startBlockId;
    }

    public void setPromise(ChannelPromise promise) {
        this.promise = promise;
    }
}

