/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.serial;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import netbank.firm.model.BizType;
import netbank.firm.model.MagicNum;
import netbank.firm.model.SerializableMessage;
import netbank.firm.serial.FieldDefine;
import netbank.firm.serial.Serialable;
import netbank.firm.serial.TxnModel;
import netbank.firm.serial.TxnModelClzMap;
import netbank.firm.serial.tool.FixLengthComposite;

public class ReflectSerial {
    public static Object bytes2Object(MagicNum mn, BizType biz, byte[] bytes) throws Exception {
        Class<?> cls = TxnModelClzMap.get(TxnModel.valueOf(mn, biz));
        Object obj = cls.newInstance();
        if (obj instanceof SerializableMessage) {
            SerializableMessage sm = (SerializableMessage)obj;
            return sm.toObject(bytes);
        }
        return ReflectSerial.bytes2Object(cls, bytes);
    }

    public static <I> I bytes2Object(Class<I> cls, byte[] bytes) throws Exception {
        if (cls == null) {
            throw new Exception("no support type");
        }
        Serialable annoCls = cls.getAnnotation(Serialable.class);
        if (annoCls == null) {
            throw new Exception("is not serial object");
        }
        FixLengthComposite serialTool = new FixLengthComposite();
        Field[] fs = ReflectSerial.getFieldDefines(cls);
        if (fs == null || fs.length == 0) {
            throw new Exception("this object field is empty");
        }
        I result = cls.newInstance();
        int off = 0;
        for (Field f : fs) {
            Object field;
            byte[] subBytes;
            FieldDefine anno = f.getAnnotation(FieldDefine.class);
            int fieldLength = anno.length();
            if (fieldLength < 0) {
                subBytes = new byte[bytes.length - off];
                System.arraycopy(bytes, off, subBytes, 0, subBytes.length);
                field = serialTool.byte2Object(f.getType(), subBytes);
                f.setAccessible(true);
                f.set(result, field);
                return result;
            }
            if (off + fieldLength > bytes.length) {
                throw new Exception("input String length less than field define'length ,may be this field '" + f.getName() + "' was wrong defined");
            }
            subBytes = new byte[fieldLength];
            System.arraycopy(bytes, off, subBytes, 0, fieldLength);
            field = serialTool.byte2Object(f.getType(), subBytes);
            f.setAccessible(true);
            f.set(result, field);
            off += fieldLength;
        }
        return result;
    }

    public static byte[] object2bytes(Object object) throws Exception {
        Class<?> cls = Class.forName(object.getClass().getName());
        Serialable annoCls = cls.getAnnotation(Serialable.class);
        if (annoCls == null) {
            throw new Exception("is not serial object");
        }
        FixLengthComposite serialTool = new FixLengthComposite();
        Field[] fs = ReflectSerial.getFieldDefines(cls);
        if (fs == null || fs.length == 0) {
            throw new Exception("this object field is empty");
        }
        byte[] tmp = null;
        int off = 0;
        for (Field f : fs) {
            FieldDefine anno = f.getAnnotation(FieldDefine.class);
            f.setAccessible(true);
            byte[] ret = serialTool.object2bytes(f.getType(), anno, f.get(object));
            tmp = ReflectSerial.expandCapacity(tmp, ret.length);
            if (ret != null) {
                System.arraycopy(ret, 0, tmp, off, ret.length);
            }
            off += ret.length;
        }
        return tmp;
    }

    private static Field[] getFieldDefines(Class<?> cls) {
        Field[] fields = null;
        int off = 0;
        while (cls != Object.class) {
            Field[] tmp = cls.getDeclaredFields();
            if (fields == null) {
                fields = new Field[tmp.length];
                System.arraycopy(tmp, 0, fields, off, tmp.length);
                off += tmp.length;
            } else {
                fields = Arrays.copyOf(fields, tmp.length + fields.length);
                System.arraycopy(tmp, 0, fields, off, tmp.length);
                off += tmp.length;
            }
            cls = cls.getSuperclass();
        }
        if (fields == null) {
            return null;
        }
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : fields) {
            if (field.getAnnotation(FieldDefine.class) == null) continue;
            list.add(field);
        }
        fields = new Field[list.size()];
        list.toArray(fields);
        Arrays.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                FieldDefine anno1 = o1.getAnnotation(FieldDefine.class);
                FieldDefine anno2 = o2.getAnnotation(FieldDefine.class);
                return anno1.order() - anno2.order();
            }
        });
        return fields;
    }

    private static byte[] expandCapacity(byte[] tmp, int length) {
        if (tmp == null) {
            return new byte[length];
        }
        return Arrays.copyOf(tmp, tmp.length + length);
    }

    public static <I> I string2Object(String pojo, Class<I> cls) throws Exception {
        Serialable annoCls = cls.getAnnotation(Serialable.class);
        if (annoCls == null) {
            throw new Exception("is not serial object");
        }
        FixLengthComposite serialTool = new FixLengthComposite();
        Field[] fs = ReflectSerial.getFieldDefines(cls);
        if (fs == null || fs.length == 0) {
            throw new Exception("this object field is empty");
        }
        I result = cls.newInstance();
        int off = 0;
        for (Field f : fs) {
            Object field;
            String fieldStr;
            FieldDefine anno = f.getAnnotation(FieldDefine.class);
            int fieldLength = anno.length();
            if (fieldLength < 0) {
                fieldStr = pojo.substring(off);
                field = serialTool.string2Object(f.getType(), fieldStr);
                f.setAccessible(true);
                f.set(result, field);
                return result;
            }
            if (off + fieldLength > pojo.length()) {
                throw new Exception("input String length less than field define'length ,may be this field '" + f.getName() + "' was wrong defined");
            }
            fieldStr = pojo.substring(off, off + fieldLength);
            field = serialTool.string2Object(f.getType(), fieldStr);
            f.setAccessible(true);
            f.set(result, field);
            off += fieldLength;
        }
        return result;
    }

    public static String object2String(Object pojo) throws Exception {
        Class<?> cls = Class.forName(pojo.getClass().getName());
        Serialable annoCls = cls.getAnnotation(Serialable.class);
        if (annoCls == null) {
            throw new Exception("is not serial object");
        }
        FixLengthComposite serialTool = new FixLengthComposite();
        Field[] fs = ReflectSerial.getFieldDefines(cls);
        if (fs == null || fs.length == 0) {
            throw new Exception("this object field is empty");
        }
        StringBuffer sb = new StringBuffer();
        for (Field f : fs) {
            FieldDefine anno = f.getAnnotation(FieldDefine.class);
            f.setAccessible(true);
            sb.append(serialTool.object2String(f.getType(), anno, f.get(pojo)));
        }
        return sb.toString();
    }
}

