/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.service;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import netbank.firm.base.SystemProperty;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.file.FileFilter;
import netbank.firm.handler.DcfirmChannelPromise;
import netbank.firm.handler.DefaultFileChannelInitializer;
import netbank.firm.handler.DefaultRequestFileHandler;
import netbank.firm.handler.DefaultResponseFileHandler;
import netbank.firm.model.DownloadRequest;
import netbank.firm.model.UploadRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileService {
    private static final Log LOG = LogFactory.getLog(FileService.class);
    private String proxyHost;
    private int proxyPort;
    private int blockSize;
    private int startBlockId;
    private int connectionTimeOut;
    private long maxSize = 0xF00000L;

    private void init() throws DcfirmException {
        try {
            this.proxyHost = SystemProperty.getInstance().getProperty("proxy.host", true);
            this.proxyPort = Integer.parseInt(SystemProperty.getInstance().getProperty("proxy.port", true));
            this.blockSize = Integer.parseInt(SystemProperty.getInstance().getProperty("file.transfer.blockSize", "4096"));
            this.startBlockId = Integer.parseInt(SystemProperty.getInstance().getProperty("file.transfer.startBlockId", "1"));
        }
        catch (Exception e) {
            throw new DcfirmException(ExceptionCode.C004.getCode(), e.getMessage());
        }
        if (this.blockSize < 1024 || this.blockSize > 8192) {
            throw new DcfirmException(ExceptionCode.C004.getCode(), "block size between 1024 and 8192");
        }
        if (this.startBlockId < 1) {
            throw new DcfirmException(ExceptionCode.C004.getCode(), "startNum must be lager than 1");
        }
        this.connectionTimeOut = Integer.parseInt(SystemProperty.getInstance().getProperty("netty.connection.outtime.seconds", "60"));
    }

    public String uploadFile(final String bizCode, final File sendFile) throws DcfirmException {
        String fileMac = "";
        this.init();
        this.checkFileLength(sendFile);
        if (sendFile == null || sendFile.isDirectory()) {
            throw new DcfirmException(ExceptionCode.C005);
        }
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new DefaultFileChannelInitializer())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectionTimeOut);
            ChannelFuture ch = b.connect(this.proxyHost, this.proxyPort).sync();
            DcfirmChannelPromise promise = new DcfirmChannelPromise(ch.channel());
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        throw new DcfirmException(ExceptionCode.B214, future.cause());
                    }
                }
            });
            this.appendResponseFilelHandler(ch, sendFile, (ChannelPromise)promise);
            ch.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        LOG.error((Object)"error: ", future.cause());
                        throw new DcfirmException(ExceptionCode.C001.getCode(), future.cause().toString());
                    }
                    String fileName = sendFile.getName();
                    String body = fileName.substring(fileName.lastIndexOf(92) + 1);
                    UploadRequest auth = new UploadRequest(bizCode, body);
                    future.channel().writeAndFlush((Object)auth).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                }
            });
            promise.sync();
            AttributeKey ak = AttributeKey.valueOf((String)"FileID");
            fileMac = (String)ch.channel().attr(ak).get();
            LOG.info((Object)("upload filemac:" + fileMac));
            ch.channel().closeFuture().sync();
            String string = fileMac;
            return string;
        }
        catch (Exception e) {
            LOG.error((Object)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            throw new DcfirmException(ExceptionCode.C002.getCode(), e.getMessage());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    public String downloadFile(final String fileName, final String fileId) throws DcfirmException {
        String filePath = "";
        this.init();
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new DefaultFileChannelInitializer())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectionTimeOut);
            ChannelFuture ch = b.connect(this.proxyHost, this.proxyPort).sync();
            DcfirmChannelPromise promise = new DcfirmChannelPromise(ch.channel());
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        throw new DcfirmException(ExceptionCode.B214, future.cause());
                    }
                }
            });
            this.appendRequestFileHandler(ch, (ChannelPromise)promise);
            this.appendResponseFilelHandler(ch, null, (ChannelPromise)promise);
            ch.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        LOG.error((Object)"error: ", future.cause());
                        throw new DcfirmException(ExceptionCode.B001.getCode(), future.cause().toString());
                    }
                    DownloadRequest downLoadRequest = new DownloadRequest();
                    downLoadRequest.setFileId(fileId);
                    downLoadRequest.setFileName(fileName);
                    downLoadRequest.setStartNum(FileService.this.startBlockId);
                    downLoadRequest.setBlockSize(FileService.this.blockSize);
                    future.channel().writeAndFlush((Object)downLoadRequest).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                }
            });
            promise.sync();
            ch.channel().closeFuture().sync();
            AttributeKey ak = AttributeKey.valueOf((String)"recvFile");
            filePath = (String)ch.channel().attr(ak).get();
            if (filePath.substring(0, filePath.indexOf(".gz")) != null) {
                filePath = filePath.substring(0, filePath.indexOf(".gz"));
            }
            String string = filePath;
            return string;
        }
        catch (Exception e) {
            LOG.error((Object)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            throw new DcfirmException(ExceptionCode.C002.getCode(), e.getMessage());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private void appendResponseFilelHandler(ChannelFuture ch, File sendFile, ChannelPromise promise) throws Exception {
        ChannelPipeline p = ch.channel().pipeline();
        DefaultResponseFileHandler responseFileHandler = new DefaultResponseFileHandler();
        if (sendFile != null) {
            if (!sendFile.exists()) {
                throw new FileNotFoundException();
            }
            responseFileHandler.setSendFile(sendFile);
            responseFileHandler.setBlockSize(this.blockSize);
            responseFileHandler.setStartBlockId(this.startBlockId);
        }
        responseFileHandler.setPromise(promise);
        p.addLast("sendFile", (ChannelHandler)responseFileHandler);
    }

    private void appendRequestFileHandler(ChannelFuture ch, ChannelPromise promise) throws Exception {
        ChannelPipeline p = ch.channel().pipeline();
        String receivePath = SystemProperty.getInstance().getProperty("file.receive.path", true);
        DefaultRequestFileHandler requestFileHandler = new DefaultRequestFileHandler();
        requestFileHandler.setPath(receivePath);
        requestFileHandler.setPromise(promise);
        p.addLast("re", (ChannelHandler)requestFileHandler);
    }

    private int getStartBlockId(File dir, String fullName) {
        int startBlockId = 1;
        try {
            String tempName = null;
            String filterName = fullName + ".";
            FileFilter filter = new FileFilter(filterName);
            String[] names = dir.list(filter);
            if (names != null && names.length > 0) {
                if (LOG.isDebugEnabled()) {
                    for (int i = 0; i < names.length; ++i) {
                        LOG.debug((Object)("fileName:" + names[i]));
                    }
                }
                tempName = names[0];
            }
            String index = tempName.substring(filterName.length() + 1);
            startBlockId = Integer.parseInt(index);
        }
        catch (Exception e) {
            LOG.error((Object)("\u8ba1\u7b97\u6587\u4ef6\u3010" + fullName + "]\u4f20\u8f93\u8d77\u59cb\u4f4d\u7f6e\u5f02\u5e38\uff0c\u9ed8\u8ba4\u4ece\u5934\u5f00\u59cb\u3002"));
            startBlockId = 1;
        }
        return startBlockId;
    }

    private void checkFileLength(File file) throws DcfirmException {
        long fileLength = file.length();
        if (fileLength > this.maxSize) {
            throw new DcfirmException(ExceptionCode.C004.getCode(), "\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u6700\u5927\u503c[" + this.maxSize + "]");
        }
    }
}

