/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.operator.jcajce;

import com.icbc.bcpkix.org.bouncycastle.cert.X509CertificateHolder;
import com.icbc.bcpkix.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import com.icbc.bcpkix.org.bouncycastle.operator.ContentVerifier;
import com.icbc.bcpkix.org.bouncycastle.operator.ContentVerifierProvider;
import com.icbc.bcpkix.org.bouncycastle.operator.OperatorCreationException;
import com.icbc.bcpkix.org.bouncycastle.operator.RawContentVerifier;
import com.icbc.bcpkix.org.bouncycastle.operator.RuntimeOperatorException;
import com.icbc.bcpkix.org.bouncycastle.operator.jcajce.OperatorHelper;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.icbc.bcprov.org.bouncycastle.jcajce.io.OutputStreamFactory;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class JcaContentVerifierProviderBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());

    public JcaContentVerifierProviderBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaContentVerifierProviderBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public ContentVerifierProvider build(X509CertificateHolder x509CertificateHolder) throws OperatorCreationException, CertificateException {
        return this.build(this.helper.convertCertificate(x509CertificateHolder));
    }

    public ContentVerifierProvider build(final X509Certificate x509Certificate) throws OperatorCreationException {
        JcaX509CertificateHolder jcaX509CertificateHolder;
        try {
            jcaX509CertificateHolder = new JcaX509CertificateHolder(x509Certificate);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new OperatorCreationException("cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
        }
        return new ContentVerifierProvider(){

            @Override
            public boolean hasAssociatedCertificate() {
                return true;
            }

            @Override
            public X509CertificateHolder getAssociatedCertificate() {
                return jcaX509CertificateHolder;
            }

            @Override
            public ContentVerifier get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                Signature signature;
                try {
                    signature = JcaContentVerifierProviderBuilder.this.helper.createSignature(algorithmIdentifier);
                    signature.initVerify(x509Certificate.getPublicKey());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new OperatorCreationException("exception on setup: " + generalSecurityException, generalSecurityException);
                }
                Signature signature2 = JcaContentVerifierProviderBuilder.this.createRawSig(algorithmIdentifier, x509Certificate.getPublicKey());
                if (signature2 != null) {
                    return new RawSigVerifier(algorithmIdentifier, signature, signature2);
                }
                return new SigVerifier(algorithmIdentifier, signature);
            }
        };
    }

    public ContentVerifierProvider build(final PublicKey publicKey) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            @Override
            public boolean hasAssociatedCertificate() {
                return false;
            }

            @Override
            public X509CertificateHolder getAssociatedCertificate() {
                return null;
            }

            @Override
            public ContentVerifier get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                Signature signature = JcaContentVerifierProviderBuilder.this.createSignature(algorithmIdentifier, publicKey);
                Signature signature2 = JcaContentVerifierProviderBuilder.this.createRawSig(algorithmIdentifier, publicKey);
                if (signature2 != null) {
                    return new RawSigVerifier(algorithmIdentifier, signature, signature2);
                }
                return new SigVerifier(algorithmIdentifier, signature);
            }
        };
    }

    public ContentVerifierProvider build(SubjectPublicKeyInfo subjectPublicKeyInfo) throws OperatorCreationException {
        return this.build(this.helper.convertPublicKey(subjectPublicKeyInfo));
    }

    private Signature createSignature(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) throws OperatorCreationException {
        try {
            Signature signature = this.helper.createSignature(algorithmIdentifier);
            signature.initVerify(publicKey);
            return signature;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException("exception on setup: " + generalSecurityException, generalSecurityException);
        }
    }

    private Signature createRawSig(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) {
        Signature signature;
        try {
            signature = this.helper.createRawSignature(algorithmIdentifier);
            if (signature != null) {
                signature.initVerify(publicKey);
            }
        }
        catch (Exception exception) {
            signature = null;
        }
        return signature;
    }

    private class RawSigVerifier
    extends SigVerifier
    implements RawContentVerifier {
        private Signature rawSignature;

        RawSigVerifier(AlgorithmIdentifier algorithmIdentifier, Signature signature, Signature signature2) {
            super(algorithmIdentifier, signature);
            this.rawSignature = signature2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean verify(byte[] byArray) {
            try {
                boolean bl = super.verify(byArray);
                return bl;
            }
            finally {
                try {
                    this.rawSignature.verify(byArray);
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public boolean verify(byte[] byArray, byte[] byArray2) {
            try {
                this.rawSignature.update(byArray);
                boolean bl = this.rawSignature.verify(byArray2);
                return bl;
            }
            catch (SignatureException signatureException) {
                throw new RuntimeOperatorException("exception obtaining raw signature: " + signatureException.getMessage(), signatureException);
            }
            finally {
                try {
                    this.rawSignature.verify(byArray2);
                }
                catch (Exception exception) {}
            }
        }
    }

    private class SigVerifier
    implements ContentVerifier {
        private final AlgorithmIdentifier algorithm;
        private final Signature signature;
        protected final OutputStream stream;

        SigVerifier(AlgorithmIdentifier algorithmIdentifier, Signature signature) {
            this.algorithm = algorithmIdentifier;
            this.signature = signature;
            this.stream = OutputStreamFactory.createStream(signature);
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithm;
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.stream == null) {
                throw new IllegalStateException("verifier not initialised");
            }
            return this.stream;
        }

        @Override
        public boolean verify(byte[] byArray) {
            try {
                return this.signature.verify(byArray);
            }
            catch (SignatureException signatureException) {
                throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
            }
        }
    }
}

