/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.crypto.tls;

import com.icbc.bcprov.org.bouncycastle.crypto.tls.SessionParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.TlsSession;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;

class TlsSessionImpl
implements TlsSession {
    final byte[] sessionID;
    final SessionParameters sessionParameters;
    boolean resumable;

    TlsSessionImpl(byte[] byArray, SessionParameters sessionParameters) {
        if (byArray == null) {
            throw new IllegalArgumentException("'sessionID' cannot be null");
        }
        if (byArray.length > 32) {
            throw new IllegalArgumentException("'sessionID' cannot be longer than 32 bytes");
        }
        this.sessionID = Arrays.clone(byArray);
        this.sessionParameters = sessionParameters;
        this.resumable = byArray.length > 0 && null != sessionParameters && sessionParameters.isExtendedMasterSecret();
    }

    @Override
    public synchronized SessionParameters exportSessionParameters() {
        return this.sessionParameters == null ? null : this.sessionParameters.copy();
    }

    @Override
    public synchronized byte[] getSessionID() {
        return this.sessionID;
    }

    @Override
    public synchronized void invalidate() {
        this.resumable = false;
    }

    @Override
    public synchronized boolean isResumable() {
        return this.resumable;
    }
}

