/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.crypto.util;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1EncodableVector;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Integer;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.DERSequence;
import com.icbc.bcprov.org.bouncycastle.asn1.DERTaggedObject;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.icbc.bcprov.org.bouncycastle.asn1.sec.ECPrivateKey;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.X9ECParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.params.DSAParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECDomainParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import com.icbc.bcprov.org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import com.icbc.bcprov.org.bouncycastle.crypto.util.SSHBuffer;
import com.icbc.bcprov.org.bouncycastle.crypto.util.SSHBuilder;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import com.icbc.bcprov.org.bouncycastle.util.BigIntegers;
import com.icbc.bcprov.org.bouncycastle.util.Strings;
import java.io.IOException;
import java.math.BigInteger;

public class OpenSSHPrivateKeyUtil {
    static final byte[] AUTH_MAGIC = Strings.toByteArray("openssh-key-v1\u0000");

    private OpenSSHPrivateKeyUtil() {
    }

    public static byte[] encodePrivateKey(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("param is null");
        }
        if (asymmetricKeyParameter instanceof RSAPrivateCrtKeyParameters) {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter);
            return privateKeyInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter);
            return privateKeyInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(new ASN1Integer(0L));
            aSN1EncodableVector.add(new ASN1Integer(((DSAPrivateKeyParameters)asymmetricKeyParameter).getParameters().getP()));
            aSN1EncodableVector.add(new ASN1Integer(((DSAPrivateKeyParameters)asymmetricKeyParameter).getParameters().getQ()));
            aSN1EncodableVector.add(new ASN1Integer(((DSAPrivateKeyParameters)asymmetricKeyParameter).getParameters().getG()));
            BigInteger bigInteger = ((DSAPrivateKeyParameters)asymmetricKeyParameter).getParameters().getG().modPow(((DSAPrivateKeyParameters)asymmetricKeyParameter).getX(), ((DSAPrivateKeyParameters)asymmetricKeyParameter).getParameters().getP());
            aSN1EncodableVector.add(new ASN1Integer(bigInteger));
            aSN1EncodableVector.add(new ASN1Integer(((DSAPrivateKeyParameters)asymmetricKeyParameter).getX()));
            try {
                return new DERSequence(aSN1EncodableVector).getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("unable to encode DSAPrivateKeyParameters " + exception.getMessage());
            }
        }
        if (asymmetricKeyParameter instanceof Ed25519PrivateKeyParameters) {
            SSHBuilder sSHBuilder = new SSHBuilder();
            sSHBuilder.write(AUTH_MAGIC);
            sSHBuilder.writeString("none");
            sSHBuilder.writeString("none");
            sSHBuilder.u32(0L);
            sSHBuilder.u32(1L);
            Ed25519PublicKeyParameters ed25519PublicKeyParameters = ((Ed25519PrivateKeyParameters)asymmetricKeyParameter).generatePublicKey();
            byte[] byArray = OpenSSHPublicKeyUtil.encodePublicKey(ed25519PublicKeyParameters);
            sSHBuilder.rawArray(byArray);
            SSHBuilder sSHBuilder2 = new SSHBuilder();
            sSHBuilder2.u32(0xFF00FFL);
            sSHBuilder2.u32(0xFF00FFL);
            sSHBuilder2.writeString("ssh-ed25519");
            byte[] byArray2 = ((Ed25519PrivateKeyParameters)asymmetricKeyParameter).generatePublicKey().getEncoded();
            sSHBuilder2.rawArray(byArray2);
            sSHBuilder2.rawArray(Arrays.concatenate(((Ed25519PrivateKeyParameters)asymmetricKeyParameter).getEncoded(), byArray2));
            sSHBuilder2.u32(0L);
            sSHBuilder.rawArray(sSHBuilder2.getBytes());
            return sSHBuilder.getBytes();
        }
        throw new IllegalArgumentException("unable to convert " + asymmetricKeyParameter.getClass().getName() + " to openssh private key");
    }

    public static AsymmetricKeyParameter parsePrivateKeyBlob(byte[] byArray) {
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        if (byArray[0] == 48) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(byArray);
            if (aSN1Sequence.size() == 6) {
                if (OpenSSHPrivateKeyUtil.allIntegers(aSN1Sequence) && ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    asymmetricKeyParameter = new DSAPrivateKeyParameters(((ASN1Integer)aSN1Sequence.getObjectAt(5)).getPositiveValue(), new DSAParameters(((ASN1Integer)aSN1Sequence.getObjectAt(1)).getPositiveValue(), ((ASN1Integer)aSN1Sequence.getObjectAt(2)).getPositiveValue(), ((ASN1Integer)aSN1Sequence.getObjectAt(3)).getPositiveValue()));
                }
            } else if (aSN1Sequence.size() == 9) {
                if (OpenSSHPrivateKeyUtil.allIntegers(aSN1Sequence) && ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    RSAPrivateKey rSAPrivateKey = RSAPrivateKey.getInstance(aSN1Sequence);
                    asymmetricKeyParameter = new RSAPrivateCrtKeyParameters(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getPrime1(), rSAPrivateKey.getPrime2(), rSAPrivateKey.getExponent1(), rSAPrivateKey.getExponent2(), rSAPrivateKey.getCoefficient());
                }
            } else if (aSN1Sequence.size() == 4 && aSN1Sequence.getObjectAt(3) instanceof DERTaggedObject && aSN1Sequence.getObjectAt(2) instanceof DERTaggedObject) {
                ECPrivateKey eCPrivateKey = ECPrivateKey.getInstance(aSN1Sequence);
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)eCPrivateKey.getParameters();
                X9ECParameters x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
                asymmetricKeyParameter = new ECPrivateKeyParameters(eCPrivateKey.getKey(), (ECDomainParameters)new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed()));
            }
        } else {
            int n;
            SSHBuffer sSHBuffer = new SSHBuffer(AUTH_MAGIC, byArray);
            String string = Strings.fromByteArray(sSHBuffer.readString());
            if (!"none".equals(string)) {
                throw new IllegalStateException("encrypted keys not supported");
            }
            sSHBuffer.readString();
            sSHBuffer.readString();
            long l = sSHBuffer.readU32();
            int n2 = 0;
            while ((long)n2 != l) {
                OpenSSHPublicKeyUtil.parsePublicKey(sSHBuffer.readString());
                ++n2;
            }
            SSHBuffer sSHBuffer2 = new SSHBuffer(sSHBuffer.readPaddedString());
            int n3 = sSHBuffer2.readU32();
            if (n3 != (n = sSHBuffer2.readU32())) {
                throw new IllegalStateException("private key check values are not the same");
            }
            String string2 = Strings.fromByteArray(sSHBuffer2.readString());
            if ("ssh-ed25519".equals(string2)) {
                sSHBuffer2.readString();
                byte[] byArray2 = sSHBuffer2.readString();
                asymmetricKeyParameter = new Ed25519PrivateKeyParameters(byArray2, 0);
            } else {
                throw new IllegalStateException("can not parse private key of type " + string2);
            }
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("unable to parse key");
        }
        return asymmetricKeyParameter;
    }

    private static boolean allIntegers(ASN1Sequence aSN1Sequence) {
        for (int i = 0; i < aSN1Sequence.size(); ++i) {
            if (aSN1Sequence.getObjectAt(i) instanceof ASN1Integer) continue;
            return false;
        }
        return true;
    }
}

