/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.apiLib;

import com.icbc.bcprov.org.bouncycastle.crypto.BlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.AESEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.DESEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.DESedeEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.SM4Engine;
import com.icbc.hsm.json.bean.EncipherHashBean;
import com.icbc.hsm.json.bean.SealHashBean;
import com.icbc.hsm.software.apiLib.Hash;
import com.icbc.hsm.software.apiLib.internal.KeyManager;
import com.icbc.hsm.software.basic.AsymmetricCipher;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.basic.PBEkeyGenerate;
import com.icbc.hsm.software.basic.Rules;
import com.icbc.hsm.software.basic.SymmetricCipher;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.external.ClearKeyFunction;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.TempKeyBuilder;
import com.icbc.hsm.utils.encoders.Hex;
import com.icbc.hsm.utils.encoders.UrlBase64;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public class Cipher {
    private static final String apiName = "cipher";
    private String algorithm = null;
    private String chainMode = null;
    private String padMode = null;
    private byte[] iv = null;

    private Cipher(String string, String string2, String string3, byte[] byArray) {
        this.algorithm = string;
        this.chainMode = string2;
        this.padMode = string3;
        if (byArray != null) {
            this.iv = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.iv, 0, byArray.length);
        }
    }

    public static Cipher getInstance(String string) {
        if ("SM2".equalsIgnoreCase(string) || "RSA".equalsIgnoreCase(string) || "RSA-OAEP".equalsIgnoreCase(string)) {
            return new Cipher(string, null, null, null);
        }
        return Cipher.getInstance(string, "CBC", "PKCS5PADDING", null);
    }

    public static Cipher getInstance(String string, String string2, String string3) {
        return Cipher.getInstance(string, string2, string3, null);
    }

    public static Cipher getInstance(String string, String string2, String string3, byte[] byArray) {
        Cipher cipher = new Cipher(string, string2, string3, byArray);
        return cipher;
    }

    public byte[] encipher(HsmKeyParameter hsmKeyParameter, byte[] byArray) throws Exception {
        return this.cipher(hsmKeyParameter, byArray, true);
    }

    public long encipher(HsmKeyParameter hsmKeyParameter, InputStream inputStream, OutputStream outputStream) throws Exception {
        return this.cipher(hsmKeyParameter, inputStream, outputStream, true);
    }

    public byte[] decipher(HsmKeyParameter hsmKeyParameter, byte[] byArray) throws Exception {
        return this.cipher(hsmKeyParameter, byArray, false);
    }

    public long decipher(HsmKeyParameter hsmKeyParameter, InputStream inputStream, OutputStream outputStream) throws Exception {
        return this.cipher(hsmKeyParameter, inputStream, outputStream, false);
    }

    private byte[] cipher(HsmKeyParameter hsmKeyParameter, byte[] byArray, boolean bl) throws Exception {
        if (!Rules.parmCheck(this.algorithm, hsmKeyParameter, apiName)) {
            throw new ParmErrorException("key type error!");
        }
        byte[] byArray2 = SymmetricCipher.blockCipher(this.algorithm, this.chainMode, this.padMode, bl, hsmKeyParameter, this.iv, byArray);
        return byArray2;
    }

    private long cipher(HsmKeyParameter hsmKeyParameter, InputStream inputStream, OutputStream outputStream, boolean bl) throws Exception {
        if (!Rules.parmCheck(this.algorithm, hsmKeyParameter, apiName)) {
            throw new ParmErrorException("key type error!");
        }
        long l = SymmetricCipher.streamCipher(this.algorithm, this.chainMode, this.padMode, bl, hsmKeyParameter, this.iv, inputStream, outputStream);
        return l;
    }

    public SealedPackage seal(HsmKeyParameter hsmKeyParameter, byte[] byArray, String string) throws Exception {
        int n = 0;
        if ("DES".equalsIgnoreCase(this.algorithm)) {
            n = 8;
        } else if ("DESede".equalsIgnoreCase(this.algorithm)) {
            n = 24;
        } else if ("AES".equalsIgnoreCase(this.algorithm)) {
            n = 32;
        } else if ("SM4".equalsIgnoreCase(this.algorithm)) {
            n = 16;
        }
        byte[] byArray2 = this.generateRandom(n);
        byte[] byArray3 = null;
        if ("RSA".equalsIgnoreCase(hsmKeyParameter.getAlgorithm())) {
            if (string == null) {
                string = "PKCS1PADDING";
            }
            byArray3 = AsymmetricCipher.encipher(string, true, hsmKeyParameter, byArray2);
        }
        if ("SM2".equalsIgnoreCase(hsmKeyParameter.getAlgorithm())) {
            if (string == null) {
                string = "SM2";
            }
            byArray3 = AsymmetricCipher.encipher(string, true, hsmKeyParameter, byArray2);
        }
        ClearKeyParameter clearKeyParameter = null;
        clearKeyParameter = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)this.algorithm, (boolean)false, (byte[])byArray2) : ClearKeyParameter.getInstance(this.algorithm, false, byArray2);
        byte[] byArray4 = SymmetricCipher.blockCipher(this.algorithm, this.chainMode, this.padMode, true, clearKeyParameter, this.iv, byArray);
        String string2 = string + ";" + this.algorithm + "/" + this.chainMode + "/" + this.padMode;
        return new SealedPackage(byArray3, byArray4, string2);
    }

    public byte[] unseal(HsmKeyParameter hsmKeyParameter, byte[] byArray, byte[] byArray2, String string) throws Exception {
        byte[] byArray3 = null;
        byArray3 = AsymmetricCipher.encipher(string, false, hsmKeyParameter, byArray);
        ClearKeyParameter clearKeyParameter = null;
        clearKeyParameter = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)this.algorithm, (boolean)false, (byte[])byArray3) : ClearKeyParameter.getInstance(this.algorithm, false, byArray3);
        byte[] byArray4 = this.cipher(clearKeyParameter, byArray2, false);
        return byArray4;
    }

    public long unseal(HsmKeyParameter hsmKeyParameter, byte[] byArray, String string, InputStream inputStream, OutputStream outputStream) throws Exception {
        byte[] byArray2 = null;
        byArray2 = AsymmetricCipher.encipher(string, false, hsmKeyParameter, byArray);
        ClearKeyParameter clearKeyParameter = null;
        clearKeyParameter = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)this.algorithm, (boolean)false, (byte[])byArray2) : ClearKeyParameter.getInstance(this.algorithm, false, byArray2);
        long l = this.cipher(clearKeyParameter, inputStream, outputStream, false);
        return l;
    }

    public String encipherHash(HsmKeyParameter hsmKeyParameter, byte[] byArray) throws Exception {
        String string = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        EncipherHashBean encipherHashBean = new EncipherHashBean();
        EncipherHashBean encipherHashBean2 = new EncipherHashBean(null);
        encipherHashBean.setVer("E0");
        encipherHashBean2.setVer("E0");
        if (!Rules.parmCheck(this.algorithm, hsmKeyParameter, apiName)) {
            throw new ParmErrorException("encipherHash:key&algorithm&apiName inconformity!");
        }
        if (byArray != null && byArray.length > 0) {
            Object object;
            BlockCipher blockCipher = null;
            if ("SM4".equalsIgnoreCase(this.algorithm)) {
                blockCipher = new SM4Engine();
            } else if ("DES".equalsIgnoreCase(this.algorithm)) {
                blockCipher = new DESEngine();
            } else if ("DESede".equalsIgnoreCase(this.algorithm)) {
                blockCipher = new DESedeEngine();
            } else if ("AES".equalsIgnoreCase(this.algorithm)) {
                blockCipher = new AESEngine();
            } else {
                throw new ParmErrorException("encipherHash:symmetrical key Algorithm Name error:" + this.algorithm);
            }
            encipherHashBean.setEncAlg(this.algorithm + "/" + this.chainMode + "/" + this.padMode);
            encipherHashBean2.setEncAlg(this.algorithm + "/" + this.chainMode + "/" + this.padMode);
            if (this.iv == null) {
                int n = blockCipher.getBlockSize();
                this.iv = new byte[n];
                object = new SecureRandom();
                ((SecureRandom)object).nextBytes(this.iv);
            }
            encipherHashBean.setIv(UrlBase64.toBase64String(this.iv));
            encipherHashBean2.setIv(UrlBase64.toBase64String(this.iv));
            try {
                byArray2 = SymmetricCipher.blockCipher(this.algorithm, this.chainMode, this.padMode, true, hsmKeyParameter, this.iv, byArray);
                encipherHashBean2.setEncData(UrlBase64.toBase64String(byArray2));
            }
            catch (Exception exception) {
                throw new ParmErrorException("encipherHash:encipher fail!" + exception.getMessage());
            }
            byArray3 = SymmetricCipher.getCheckValue(this.algorithm, hsmKeyParameter);
            encipherHashBean.setKid(UrlBase64.toBase64String(byArray3));
            encipherHashBean2.setKid(UrlBase64.toBase64String(byArray3));
            Hash hash = Hash.getInstance("SM3");
            try {
                byArray4 = hash.GenerateHash(byArray);
            }
            catch (Exception exception) {
                throw new ParmErrorException("encipherHash:first Hash fail!" + exception.getMessage());
            }
            encipherHashBean.setEncData(UrlBase64.toBase64String(byArray4));
            object = encipherHashBean.mapToString();
            try {
                byArray5 = hash.GenerateHash(((String)object).getBytes("UTF-8"));
                encipherHashBean2.setMac(UrlBase64.toBase64String(byArray5));
            }
            catch (Exception exception) {
                throw new ParmErrorException("encipherHash:second Hash fail!" + exception.getMessage());
            }
        }
        throw new ParmErrorException("encipherHash:encipher data is empty\uff01");
        string = UrlBase64.toBase64String(encipherHashBean2.mapToString().getBytes("UTF-8"));
        return string;
    }

    public byte[] decipherHash(HsmKeyParameter hsmKeyParameter, String string) throws Exception {
        byte[] byArray = null;
        String string2 = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        String string3 = null;
        String string4 = null;
        byte[] byArray4 = null;
        EncipherHashBean encipherHashBean = new EncipherHashBean(null);
        if (!Rules.parmCheck(this.algorithm, hsmKeyParameter, apiName)) {
            throw new ParmErrorException("decipherHash:key&algorithm&apiName inconformity!");
        }
        if (string != null || string.length() > 0) {
            try {
                string2 = new String(UrlBase64.decode(string));
            }
            catch (Exception exception) {
                throw new ParmErrorException("decipherHash:data from Base64String to JsonString fail!" + exception.getMessage());
            }
            try {
                encipherHashBean.stringToMap(string2);
            }
            catch (Exception exception) {
                throw new ParmErrorException("decipherHash:stringToMap fail!" + exception.getMessage());
            }
            string3 = encipherHashBean.getMac();
            try {
                byArray2 = UrlBase64.decode(encipherHashBean.getEncData());
                this.iv = UrlBase64.decode(encipherHashBean.getIv());
                byArray3 = SymmetricCipher.blockCipher(this.algorithm, this.chainMode, this.padMode, false, hsmKeyParameter, this.iv, byArray2);
            }
            catch (Exception exception) {
                throw new ParmErrorException("decipherHash:decipher fail!" + exception.getMessage());
            }
            Hash hash = Hash.getInstance("SM3");
            try {
                byArray4 = hash.GenerateHash(byArray3);
            }
            catch (Exception exception) {
                throw new ParmErrorException("decipherHash:first Hash fail!" + exception.getMessage());
            }
            try {
                encipherHashBean.removeKey("mac");
                encipherHashBean.setEncData(UrlBase64.toBase64String(byArray4));
            }
            catch (Exception exception) {
                throw new ParmErrorException("decipherHash:modify hash data fail!" + exception.getMessage());
            }
            String string5 = encipherHashBean.mapToString();
            try {
                byte[] byArray5 = hash.GenerateHash(string5.getBytes("UTF-8"));
                string4 = UrlBase64.toBase64String(byArray5);
            }
            catch (Exception exception) {
                throw new ParmErrorException("decipherHash:second Hash fail! maybe the hashData is error" + exception.getMessage());
            }
            if (!string3.equalsIgnoreCase(string4)) {
                throw new ParmErrorException("decipherHash:hash verify fail\uff01");
            }
        } else {
            throw new ParmErrorException("decipherHash:encipher data is empty\uff01");
        }
        byArray = byArray3;
        return byArray;
    }

    public String sealHash(String string, byte[] byArray) throws Exception {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        SealHashBean sealHashBean = new SealHashBean();
        SealHashBean sealHashBean2 = new SealHashBean(null);
        HsmKeyParameter hsmKeyParameter = null;
        if (string != null && string.length() > 0 && byArray != null && byArray.length > 0) {
            if (this.algorithm.equals("SM4") || this.algorithm.equals("DESede") || this.algorithm.equals("DES") || this.algorithm.equals("AES")) {
                Object object;
                Object object2;
                String[] stringArray = null;
                try {
                    if (IcbcEnvironment.isICBCEnvironment()) {
                        object2 = KeyManager.getInstance((String)this.algorithm);
                        stringArray = object2.generateEnvelope(string);
                    } else {
                        object2 = ClearKeyFunction.getInstance(this.algorithm);
                        stringArray = ((ClearKeyFunction)object2).generateEnvelope(string);
                    }
                    string3 = stringArray[0];
                    string4 = stringArray[1];
                }
                catch (Exception exception) {
                    throw new ParmErrorException("sealHash:generateEnvelope to get random symmetric key fail!" + exception.getMessage());
                }
                try {
                    if (IcbcEnvironment.isICBCEnvironment()) {
                        object2 = KeyManager.restoreKeyHolder((String)string3);
                        hsmKeyParameter = object2.getHsmKeyParameter();
                    } else {
                        object2 = ClearKeyFunction.restoreKeyHolder(string3);
                        hsmKeyParameter = ((ClearKeyFunction.KeyHolder)object2).getHsmKeyParameter();
                    }
                }
                catch (Exception exception) {
                    throw new ParmErrorException("sealHash:Get symmetric key object fail!" + exception.getMessage());
                }
                sealHashBean.setVer("E0");
                sealHashBean2.setVer("E0");
                object2 = null;
                if ("SM4".equalsIgnoreCase(this.algorithm)) {
                    object2 = new SM4Engine();
                } else if ("DES".equalsIgnoreCase(this.algorithm)) {
                    object2 = new DESEngine();
                } else if ("DESede".equalsIgnoreCase(this.algorithm)) {
                    object2 = new DESedeEngine();
                } else if ("AES".equalsIgnoreCase(this.algorithm)) {
                    object2 = new AESEngine();
                }
                sealHashBean.setEncAlg(this.algorithm + "/" + this.chainMode + "/" + this.padMode);
                sealHashBean2.setEncAlg(this.algorithm + "/" + this.chainMode + "/" + this.padMode);
                if (this.iv == null) {
                    int n = object2.getBlockSize();
                    this.iv = new byte[n];
                    object = new SecureRandom();
                    ((SecureRandom)object).nextBytes(this.iv);
                }
                sealHashBean.setIv(UrlBase64.toBase64String(this.iv));
                sealHashBean2.setIv(UrlBase64.toBase64String(this.iv));
                try {
                    byArray2 = SymmetricCipher.blockCipher(this.algorithm, this.chainMode, this.padMode, true, hsmKeyParameter, this.iv, byArray);
                    sealHashBean2.setEncData(UrlBase64.toBase64String(byArray2));
                }
                catch (Exception exception) {
                    throw new ParmErrorException("sealHash:encipher fail!" + exception.getMessage());
                }
                sealHashBean.setCEK(string4);
                sealHashBean2.setCEK(string4);
                Hash hash = Hash.getInstance("SM3");
                try {
                    byArray4 = hash.GenerateHash(byArray);
                }
                catch (Exception exception) {
                    throw new ParmErrorException("sealHash:first Hash fail!" + exception.getMessage());
                }
                sealHashBean.setEncData(UrlBase64.toBase64String(byArray4));
                object = sealHashBean.mapToString();
                try {
                    byArray3 = hash.GenerateHash(((String)object).getBytes("UTF-8"));
                    sealHashBean2.setMac(UrlBase64.toBase64String(byArray3));
                }
                catch (Exception exception) {
                    throw new ParmErrorException("sealHash:second Hash fail!" + exception.getMessage());
                }
            }
            throw new ParmErrorException("sealHash:algorithm is error!");
        }
        throw new ParmErrorException("sealHash:key is empty !");
        string2 = UrlBase64.toBase64String(sealHashBean2.mapToString().getBytes("UTF-8"));
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] unSealHash(HsmKeyParameter hsmKeyParameter, String string) throws Exception {
        Object object;
        byte[] byArray = null;
        String string2 = null;
        HsmKeyParameter hsmKeyParameter2 = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        String string3 = null;
        String string4 = null;
        SealHashBean sealHashBean = new SealHashBean(null);
        if (string == null) return byArray;
        if (string.length() <= 0) return byArray;
        try {
            string2 = new String(UrlBase64.decode(string));
        }
        catch (Exception exception) {
            throw new ParmErrorException("unSealHash:data from UrlBase64String to JsonString fail!" + exception.getMessage());
        }
        try {
            sealHashBean.stringToMap(string2);
        }
        catch (Exception exception) {
            throw new ParmErrorException("unSealHash:stringToMap fail!");
        }
        string3 = sealHashBean.getMac();
        String string5 = sealHashBean.getCEK();
        String string6 = sealHashBean.getEncData();
        if (string5 == null) throw new ParmErrorException("unSealHash:from SealHashBean map to get data is empty!");
        if (string5.length() <= 0) throw new ParmErrorException("unSealHash:from SealHashBean map to get data is empty!");
        if (string6 == null) throw new ParmErrorException("unSealHash:from SealHashBean map to get data is empty!");
        if (string6.length() <= 0) {
            throw new ParmErrorException("unSealHash:from SealHashBean map to get data is empty!");
        }
        if (!(this.algorithm.equals("SM4") || this.algorithm.equals("DESede") || this.algorithm.equals("DES"))) {
            if (!this.algorithm.equals("AES")) throw new ParmErrorException("unSealHash:algorithm is error!");
        }
        try {
            if (IcbcEnvironment.isICBCEnvironment()) {
                object = KeyManager.getInstance((String)this.algorithm);
                hsmKeyParameter2 = object.decryptEnvelope(hsmKeyParameter, string5);
            } else {
                object = ClearKeyFunction.getInstance(this.algorithm);
                hsmKeyParameter2 = ((ClearKeyFunction)object).decryptEnvelope((ClearKeyParameter)hsmKeyParameter, string5);
            }
        }
        catch (Exception exception) {
            throw new ParmErrorException("unSealHash:decryptEnvelope to get random symmetric key fail!" + exception.getMessage());
        }
        try {
            this.iv = UrlBase64.decode(sealHashBean.getIv());
            object = UrlBase64.decode(string6);
            byArray2 = SymmetricCipher.blockCipher(this.algorithm, this.chainMode, this.padMode, false, hsmKeyParameter2, this.iv, (byte[])object);
        }
        catch (Exception exception) {
            throw new ParmErrorException("unSealHash:decipher business ciphertext fail!" + exception.getMessage());
        }
        object = Hash.getInstance("SM3");
        try {
            byArray4 = ((Hash)object).GenerateHash(byArray2);
        }
        catch (Exception exception) {
            throw new ParmErrorException("unSealHash:first Hash fail!" + exception.getMessage());
        }
        try {
            sealHashBean.removeKey("mac");
            sealHashBean.setEncData(UrlBase64.toBase64String(byArray4));
        }
        catch (Exception exception) {
            throw new ParmErrorException("unSealHash:modify hash data fail!" + exception.getMessage());
        }
        String string7 = sealHashBean.mapToString();
        try {
            byArray3 = ((Hash)object).GenerateHash(string7.getBytes("UTF-8"));
            string4 = UrlBase64.toBase64String(byArray3);
        }
        catch (Exception exception) {
            throw new ParmErrorException("unSealHash:second Hash fail! maybe the hashData is error" + exception.getMessage());
        }
        if (!string3.equalsIgnoreCase(string4)) throw new ParmErrorException("unSealHash:hash verify fail\uff01");
        return byArray2;
    }

    private byte[] generateRandom(int n) throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[20];
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = new byte[32];
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = PBEkeyGenerate.generatePBEKey("PBKDF2", "SM3", null, n, byArray, byArray2, 16);
        return byArray3;
    }

    public String getParameter() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("algorithm: ").append(this.algorithm).append("; ");
        stringBuffer.append("chainMode: ").append(this.chainMode).append("; ");
        stringBuffer.append("padMode: ").append(this.padMode).append("; ");
        stringBuffer.append("iv: ").append(this.iv == null ? "null" : Hex.toHexString(this.iv));
        return stringBuffer.toString();
    }

    public String[] rsaDigitalEnvelope(HsmKeyParameter hsmKeyParameter, byte[] byArray) throws Exception {
        if (hsmKeyParameter == null || byArray == null) {
            throw new Exception("Rsa public key or data is null. Please check.");
        }
        SealedPackage sealedPackage = this.seal(hsmKeyParameter, byArray, "OAEPWITHSHA-256ANDMGF1PADDING");
        byte[] byArray2 = sealedPackage.getEncryptedData();
        return new String[]{Hex.toHexString(sealedPackage.getEncryptedKey()), Hex.toHexString(byArray2, byArray2.length - 16, 16), Hex.toHexString(byArray2, 0, byArray2.length - 16)};
    }

    public byte[] getIV() {
        return this.iv;
    }

    public void setIV(byte[] byArray) {
        this.iv = byArray;
    }

    public class SealedPackage {
        private byte[] encryptedKey = null;
        private byte[] encryptedData = null;
        private String cipherParameters = null;

        SealedPackage(byte[] byArray, byte[] byArray2, String string) {
            this.encryptedKey = byArray;
            this.encryptedData = byArray2;
            this.cipherParameters = string;
        }

        public byte[] getEncryptedKey() {
            return this.encryptedKey;
        }

        public byte[] getEncryptedData() {
            return this.encryptedData;
        }

        public String getCipherParameters() {
            return this.cipherParameters;
        }
    }
}

