/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.apiLib;

import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.basic.MessageAuthenticate;
import com.icbc.hsm.software.basic.Rules;
import com.icbc.hsm.software.exception.ParmErrorException;
import java.util.Arrays;

public class Mac {
    private static final String apiName = "mac";
    private String macAlgorithm = null;
    private byte[] iv = null;

    private Mac(String string, byte[] byArray) {
        this.macAlgorithm = string;
        if (byArray != null) {
            this.iv = Arrays.copyOfRange(byArray, 0, byArray.length);
        }
    }

    public static Mac getInstance(String string) {
        return Mac.getInstance(string, null);
    }

    public static Mac getInstance(String string, byte[] byArray) {
        Mac mac = new Mac(string, byArray);
        return mac;
    }

    public byte[] generate(HsmKeyParameter hsmKeyParameter, byte[] byArray) throws Exception {
        if (!Rules.parmCheck(this.macAlgorithm, hsmKeyParameter, apiName)) {
            throw new ParmErrorException("key type error!");
        }
        byte[] byArray2 = MessageAuthenticate.authenticate(hsmKeyParameter.getAlgorithm(), this.macAlgorithm, hsmKeyParameter, this.iv, byArray);
        return byArray2;
    }

    public boolean verify(HsmKeyParameter hsmKeyParameter, byte[] byArray, byte[] byArray2) throws Exception {
        if (!Rules.parmCheck(this.macAlgorithm, hsmKeyParameter, apiName)) {
            throw new ParmErrorException("key type error!");
        }
        byte[] byArray3 = MessageAuthenticate.authenticate(hsmKeyParameter.getAlgorithm(), this.macAlgorithm, hsmKeyParameter, this.iv, byArray);
        return Arrays.equals(byArray2, byArray3);
    }

    public String getParameter() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("macAlgorithm: ").append(this.macAlgorithm);
        return stringBuffer.toString();
    }
}

