/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.ExtendedDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.MD5Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA1Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA224Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA256Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA384Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA512Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SM3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.macs.HMac;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.utils.Helper;
import java.io.InputStream;

public class MessageDigest {
    private MessageDigest() {
    }

    public static byte[] digest(String string, byte[] byArray) throws Exception {
        int n;
        ExtendedDigest extendedDigest = null;
        if ("MD5".equalsIgnoreCase(string)) {
            extendedDigest = new MD5Digest();
        } else if ("SHA1".equalsIgnoreCase(string)) {
            extendedDigest = new SHA1Digest();
        } else if ("SHA224".equalsIgnoreCase(string)) {
            extendedDigest = new SHA224Digest();
        } else if ("SHA256".equalsIgnoreCase(string)) {
            extendedDigest = new SHA256Digest();
        } else if ("SHA384".equalsIgnoreCase(string)) {
            extendedDigest = new SHA384Digest();
        } else if ("SHA512".equalsIgnoreCase(string)) {
            extendedDigest = new SHA512Digest();
        } else if (string != null && string.startsWith("SHA3-")) {
            n = Integer.parseInt(string.substring("SHA3-".length()));
            extendedDigest = new SHA3Digest(n);
        } else if ("SM3".equalsIgnoreCase(string)) {
            extendedDigest = new SM3Digest();
        } else {
            throw new ParmErrorException("Digest Algorithm Name error:" + string);
        }
        n = extendedDigest.getDigestSize();
        byte[] byArray2 = new byte[n];
        if (byArray != null) {
            extendedDigest.update(byArray, 0, byArray.length);
        }
        extendedDigest.doFinal(byArray2, 0);
        extendedDigest.reset();
        return byArray2;
    }

    public static byte[] streamDigest(String string, InputStream inputStream) throws Exception {
        int n;
        ExtendedDigest extendedDigest = null;
        if ("MD5".equalsIgnoreCase(string)) {
            extendedDigest = new MD5Digest();
        } else if ("SHA1".equalsIgnoreCase(string)) {
            extendedDigest = new SHA1Digest();
        } else if ("SHA224".equalsIgnoreCase(string)) {
            extendedDigest = new SHA224Digest();
        } else if ("SHA256".equalsIgnoreCase(string)) {
            extendedDigest = new SHA256Digest();
        } else if ("SHA384".equalsIgnoreCase(string)) {
            extendedDigest = new SHA384Digest();
        } else if ("SHA512".equalsIgnoreCase(string)) {
            extendedDigest = new SHA512Digest();
        } else if (string != null && string.startsWith("SHA3-")) {
            n = Integer.parseInt(string.substring("SHA3-".length()));
            extendedDigest = new SHA3Digest(n);
        } else if ("SM3".equalsIgnoreCase(string)) {
            extendedDigest = new SM3Digest();
        } else {
            throw new ParmErrorException("Digest Algorithm Name error:" + string);
        }
        n = extendedDigest.getDigestSize();
        byte[] byArray = new byte[n];
        Long l = new Long(0L);
        int n2 = 4096;
        byte[] byArray2 = new byte[n2];
        try {
            int n3;
            while ((n3 = inputStream.read(byArray2, 0, n2)) > 0) {
                extendedDigest.update(byArray2, 0, n3);
                l = l + (long)n3;
            }
        }
        catch (Exception exception) {
            extendedDigest.reset();
            throw exception;
        }
        extendedDigest.doFinal(byArray, 0);
        extendedDigest.reset();
        return byArray;
    }

    public static byte[] hashingMAC(CipherParameters cipherParameters, String string, byte[] byArray) throws Exception {
        CipherParameters cipherParameters2 = Helper.toBCkey(cipherParameters);
        ExtendedDigest extendedDigest = null;
        if ("MD5".equalsIgnoreCase(string)) {
            extendedDigest = new MD5Digest();
        } else if ("SHA1".equalsIgnoreCase(string)) {
            extendedDigest = new SHA1Digest();
        } else if ("SHA224".equalsIgnoreCase(string)) {
            extendedDigest = new SHA224Digest();
        } else if ("SHA256".equalsIgnoreCase(string)) {
            extendedDigest = new SHA256Digest();
        } else if ("SHA384".equalsIgnoreCase(string)) {
            extendedDigest = new SHA384Digest();
        } else if ("SHA512".equalsIgnoreCase(string)) {
            extendedDigest = new SHA512Digest();
        } else if (string != null && string.startsWith("SHA3-")) {
            int n = Integer.parseInt(string.substring("SHA3-".length()));
            extendedDigest = new SHA3Digest(n);
        } else if ("SM3".equalsIgnoreCase(string)) {
            extendedDigest = new SM3Digest();
        } else {
            throw new ParmErrorException("Digest Algorithm Name error:" + string);
        }
        HMac hMac = new HMac(extendedDigest);
        byte[] byArray2 = new byte[hMac.getMacSize()];
        hMac.init(cipherParameters2);
        if (byArray != null) {
            hMac.update(byArray, 0, byArray.length);
        }
        hMac.doFinal(byArray2, 0);
        hMac.reset();
        return byArray2;
    }

    public static byte[] streamHashingMAC(CipherParameters cipherParameters, String string, InputStream inputStream) throws Exception {
        CipherParameters cipherParameters2 = Helper.toBCkey(cipherParameters);
        ExtendedDigest extendedDigest = null;
        if ("MD5".equalsIgnoreCase(string)) {
            extendedDigest = new MD5Digest();
        } else if ("SHA1".equalsIgnoreCase(string)) {
            extendedDigest = new SHA1Digest();
        } else if ("SHA224".equalsIgnoreCase(string)) {
            extendedDigest = new SHA224Digest();
        } else if ("SHA256".equalsIgnoreCase(string)) {
            extendedDigest = new SHA256Digest();
        } else if ("SHA384".equalsIgnoreCase(string)) {
            extendedDigest = new SHA384Digest();
        } else if ("SHA512".equalsIgnoreCase(string)) {
            extendedDigest = new SHA512Digest();
        } else if (string != null && string.startsWith("SHA3-")) {
            int n = Integer.parseInt(string.substring("SHA3-".length()));
            extendedDigest = new SHA3Digest(n);
        } else if ("SM3".equalsIgnoreCase(string)) {
            extendedDigest = new SM3Digest();
        } else {
            throw new ParmErrorException("Digest Algorithm Name error:" + string);
        }
        HMac hMac = new HMac(extendedDigest);
        byte[] byArray = new byte[hMac.getMacSize()];
        hMac.init(cipherParameters2);
        Long l = new Long(0L);
        int n = 4096;
        byte[] byArray2 = new byte[n];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray2, 0, n)) > 0) {
                hMac.update(byArray2, 0, n2);
                l = l + (long)n2;
            }
        }
        catch (Exception exception) {
            hMac.reset();
            throw exception;
        }
        hMac.doFinal(byArray, 0);
        hMac.reset();
        return byArray;
    }
}

