/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.crypto.BlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.BufferedBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.DataLengthException;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.AESEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.DESEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.DESedeEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.SM4Engine;
import com.icbc.bcprov.org.bouncycastle.crypto.modes.CBCBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.modes.CFBBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.modes.GCMBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.modes.OFBBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.paddings.BlockCipherPadding;
import com.icbc.bcprov.org.bouncycastle.crypto.paddings.PKCS7Padding;
import com.icbc.bcprov.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.paddings.X923Padding;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ParametersWithIV;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.utils.Helper;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public class SymmetricCipher {
    private SymmetricCipher() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] blockCipher(String string, String string2, String string3, boolean bl, CipherParameters cipherParameters, byte[] byArray, byte[] byArray2) throws Exception {
        Object object;
        CipherParameters cipherParameters2 = Helper.toBCkey(cipherParameters);
        BlockCipher blockCipher = null;
        if ("AES".equalsIgnoreCase(string)) {
            blockCipher = new AESEngine();
        } else if ("DES".equalsIgnoreCase(string)) {
            blockCipher = new DESEngine();
        } else if ("DESede".equalsIgnoreCase(string)) {
            blockCipher = new DESedeEngine();
        } else {
            if (!"SM4".equalsIgnoreCase(string)) throw new ParmErrorException("Cipher Algorithm Name error:" + string);
            blockCipher = new SM4Engine();
        }
        int n = blockCipher.getBlockSize();
        CipherParameters cipherParameters3 = cipherParameters2;
        if ("CBC".equalsIgnoreCase(string2)) {
            blockCipher = new CBCBlockCipher(blockCipher);
            if (byArray == null) {
                object = new byte[n];
                cipherParameters3 = new ParametersWithIV(cipherParameters2, (byte[])object);
            } else {
                if (byArray.length != n) throw new ParmErrorException("initialisation vector must be the same length as cipher block size");
                cipherParameters3 = new ParametersWithIV(cipherParameters2, byArray);
            }
        } else if (!"ECB".equalsIgnoreCase(string2)) {
            if ("CFB".equalsIgnoreCase(string2)) {
                blockCipher = new CFBBlockCipher(blockCipher, 8);
                if (byArray != null && byArray.length == n) {
                    cipherParameters3 = new ParametersWithIV(cipherParameters2, byArray);
                }
            } else if ("OFB".equalsIgnoreCase(string2)) {
                blockCipher = new OFBBlockCipher(blockCipher, 8);
                if (byArray != null && byArray.length == n) {
                    cipherParameters3 = new ParametersWithIV(cipherParameters2, byArray);
                }
            } else {
                if (!"GCM".equalsIgnoreCase(string2)) throw new ParmErrorException("Cipher Algorithm Mode error:" + string2);
                GCMBlockCipher gCMBlockCipher = new GCMBlockCipher(blockCipher, null);
                gCMBlockCipher.init(true, new ParametersWithIV(cipherParameters2, byArray));
                byte[] byArray3 = new byte[gCMBlockCipher.getOutputSize(byArray2.length)];
                int n2 = gCMBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray3, 0);
                gCMBlockCipher.doFinal(byArray3, n2);
                return byArray3;
            }
        }
        object = null;
        BlockCipherPadding blockCipherPadding = null;
        if ("NOPadding".equalsIgnoreCase(string3)) {
            if (byArray2.length % blockCipher.getBlockSize() != 0) {
                throw new DataLengthException("data not block size aligned: data len:" + byArray2.length + "; block size:" + blockCipher.getBlockSize());
            }
            object = new BufferedBlockCipher(blockCipher);
        } else if ("PKCS5Padding".equalsIgnoreCase(string3)) {
            blockCipherPadding = new PKCS7Padding();
            object = new PaddedBufferedBlockCipher(blockCipher, blockCipherPadding);
        } else if ("PKCS7Padding".equalsIgnoreCase(string3)) {
            blockCipherPadding = new PKCS7Padding();
            object = new PaddedBufferedBlockCipher(blockCipher, blockCipherPadding);
        } else {
            if (!"X9.23".equalsIgnoreCase(string3)) throw new ParmErrorException("Cipher Algorithm Padding error:" + string2);
            blockCipherPadding = new X923Padding();
            blockCipherPadding.init(new SecureRandom());
            object = new PaddedBufferedBlockCipher(blockCipher, blockCipherPadding);
        }
        ((BufferedBlockCipher)object).init(bl, cipherParameters3);
        int n3 = ((BufferedBlockCipher)object).getOutputSize(byArray2.length);
        byte[] byArray4 = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        n5 = n4 = ((BufferedBlockCipher)object).processBytes(byArray2, 0, byArray2.length, byArray4, 0);
        n4 = ((BufferedBlockCipher)object).doFinal(byArray4, n4);
        ((BufferedBlockCipher)object).reset();
        if ((n5 += n4) >= byArray4.length) return byArray4;
        byte[] byArray5 = new byte[n5];
        System.arraycopy(byArray4, 0, byArray5, 0, n5);
        return byArray5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Long streamCipher(String string, String string2, String string3, boolean bl, CipherParameters cipherParameters, byte[] byArray, InputStream inputStream, OutputStream outputStream) throws Exception {
        Object object;
        CipherParameters cipherParameters2 = Helper.toBCkey(cipherParameters);
        BlockCipher blockCipher = null;
        if ("AES".equalsIgnoreCase(string)) {
            blockCipher = new AESEngine();
        } else if ("DES".equalsIgnoreCase(string)) {
            blockCipher = new DESEngine();
        } else if ("DESede".equalsIgnoreCase(string)) {
            blockCipher = new DESedeEngine();
        } else {
            if (!"SM4".equalsIgnoreCase(string)) throw new ParmErrorException("Cipher Algorithm Name error:" + string);
            blockCipher = new SM4Engine();
        }
        int n = blockCipher.getBlockSize();
        CipherParameters cipherParameters3 = cipherParameters2;
        if ("CBC".equalsIgnoreCase(string2)) {
            blockCipher = new CBCBlockCipher(blockCipher);
            if (byArray == null) {
                object = new byte[n];
                cipherParameters3 = new ParametersWithIV(cipherParameters2, (byte[])object);
            } else {
                if (byArray.length != n) throw new ParmErrorException("initialisation vector must be the same length as cipher block size");
                cipherParameters3 = new ParametersWithIV(cipherParameters2, byArray);
            }
        } else if (!"ECB".equalsIgnoreCase(string2)) {
            if ("CFB".equalsIgnoreCase(string2)) {
                blockCipher = new CFBBlockCipher(blockCipher, 8);
                if (byArray != null && byArray.length == n) {
                    cipherParameters3 = new ParametersWithIV(cipherParameters2, byArray);
                }
            } else {
                if (!"OFB".equalsIgnoreCase(string2)) throw new ParmErrorException("Cipher Algorithm Mode error:" + string2);
                blockCipher = new OFBBlockCipher(blockCipher, 8);
                if (byArray != null && byArray.length == n) {
                    cipherParameters3 = new ParametersWithIV(cipherParameters2, byArray);
                }
            }
        }
        object = null;
        BlockCipherPadding blockCipherPadding = null;
        if ("NOPadding".equalsIgnoreCase(string3)) {
            if (inputStream.available() % blockCipher.getBlockSize() != 0) {
                throw new DataLengthException("input stream data not block size aligned: data len:" + inputStream.available() + "; block size:" + blockCipher.getBlockSize());
            }
            object = new BufferedBlockCipher(blockCipher);
        } else if ("PKCS5Padding".equalsIgnoreCase(string3)) {
            blockCipherPadding = new PKCS7Padding();
            object = new PaddedBufferedBlockCipher(blockCipher, blockCipherPadding);
        } else if ("PKCS7Padding".equalsIgnoreCase(string3)) {
            blockCipherPadding = new PKCS7Padding();
            object = new PaddedBufferedBlockCipher(blockCipher, blockCipherPadding);
        } else {
            if (!"X9.23".equalsIgnoreCase(string3)) throw new ParmErrorException("Cipher Algorithm Padding error:" + string2);
            blockCipherPadding = new X923Padding();
            blockCipherPadding.init(new SecureRandom());
            object = new PaddedBufferedBlockCipher(blockCipher, blockCipherPadding);
        }
        ((BufferedBlockCipher)object).init(bl, cipherParameters3);
        Long l = new Long(0L);
        int n2 = 4096;
        int n3 = ((BufferedBlockCipher)object).getOutputSize(n2);
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n3];
        try {
            int n4 = 0;
            int n5 = 0;
            while (inputStream.available() > 0) {
                n4 = inputStream.read(byArray2, 0, n2);
                n5 = ((BufferedBlockCipher)object).processBytes(byArray2, 0, n4, byArray3, 0);
                l = l + (long)n4;
                if (n5 <= 0) continue;
                outputStream.write(byArray3, 0, n5);
            }
            n5 = ((BufferedBlockCipher)object).doFinal(byArray3, 0);
            if (n5 > 0) {
                outputStream.write(byArray3, 0, n5);
            }
        }
        catch (Exception exception) {
            ((BufferedBlockCipher)object).reset();
            throw exception;
        }
        ((BufferedBlockCipher)object).reset();
        return l;
    }

    public static byte[] getCheckValue(String string, CipherParameters cipherParameters) throws Exception {
        byte[] byArray = null;
        if ("SM4".equalsIgnoreCase(string)) {
            byArray = new byte[16];
        }
        if ("AES".equalsIgnoreCase(string)) {
            byArray = new byte[16];
        }
        if ("DES".equalsIgnoreCase(string)) {
            byArray = new byte[8];
        }
        if ("DESede".equalsIgnoreCase(string)) {
            byArray = new byte[8];
        }
        if (byArray == null) {
            throw new ParmErrorException("key type error!");
        }
        byte[] byArray2 = SymmetricCipher.blockCipher(string, "ECB", "NOPADDING", true, cipherParameters, null, byArray);
        return byArray2;
    }
}

