/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic.extend;

import com.icbc.bcprov.org.bouncycastle.crypto.engines.AESEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.modes.GCMBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AEADParameters;

public class AesGcmCipherOfICBC {
    private GCMBlockCipher cipher = null;
    private AEADParameters parameters = null;

    public static AesGcmCipherOfICBC getInstance() {
        return new AesGcmCipherOfICBC();
    }

    public void init(boolean bl, AEADParameters aEADParameters) {
        this.init(null, bl, aEADParameters);
    }

    private void init(GCMMultiplier gCMMultiplier, boolean bl, AEADParameters aEADParameters) {
        this.parameters = aEADParameters;
        this.cipher = new GCMBlockCipher(new AESEngine(), gCMMultiplier);
        this.cipher.init(bl, aEADParameters);
    }

    public byte[] docipher(byte[] byArray) throws Exception {
        if (this.cipher == null) {
            throw new Exception("cipher instance not initialized!");
        }
        byte[] byArray2 = new byte[this.cipher.getOutputSize(byArray.length)];
        int n = this.cipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
        int n2 = this.cipher.doFinal(byArray2, n);
        n += n2;
        return byArray2;
    }

    public byte[] getMac() {
        return this.cipher.getMac();
    }

    public void reset() {
        this.cipher.reset();
        this.parameters = null;
    }
}

