/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.config;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public final class IcbcEnvironment {
    private static final String ICBC_CLASS_NAME = "com.icbc.hsm.software.parms.icbc.IcbcKeyParameter";
    private static byte[] uniqueId = new byte[32];
    public static AtomicBoolean AVAILABLE = new AtomicBoolean(false);

    private IcbcEnvironment() {
    }

    private static void enableIcbcIfPossible() {
        if (AVAILABLE.get()) {
            return;
        }
        try {
            Class.forName(ICBC_CLASS_NAME);
            AVAILABLE.set(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void generateUniqueId() {
        try {
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(uniqueId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isICBCEnvironment() {
        return AVAILABLE.get();
    }

    public static byte[] getUniqueId() {
        return Arrays.copyOfRange(uniqueId, 0, uniqueId.length);
    }

    static {
        IcbcEnvironment.enableIcbcIfPossible();
        IcbcEnvironment.generateUniqueId();
    }
}

