/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.external;

import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.KeyParameter;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint;
import com.icbc.bcprov.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.icbc.hsm.json.bean.GenerateEnvelopeBean;
import com.icbc.hsm.software.apiLib.Cipher;
import com.icbc.hsm.software.basic.AsymmetricCipher;
import com.icbc.hsm.software.basic.Generator;
import com.icbc.hsm.software.basic.PBEkeyGenerate;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.utils.encoders.Hex;
import com.icbc.hsm.utils.encoders.UrlBase64;
import java.security.SecureRandom;
import java.util.HashMap;

public class ClearKeyFunction {
    private String algorithmType;

    private ClearKeyFunction(String string) {
        this.algorithmType = string;
    }

    public static ClearKeyFunction getInstance(String string) {
        ClearKeyFunction clearKeyFunction2 = new ClearKeyFunction(string);
        return clearKeyFunction2;
    }

    public static ClearKeyParameter loadClear(String string, String string2) throws Exception {
        if (IcbcEnvironment.isICBCEnvironment()) {
            throw new Exception("ClearKeyFunction not permit");
        }
        ClearKeyParameter clearKeyParameter = null;
        if ("DES".equalsIgnoreCase(string2) || "DESede".equalsIgnoreCase(string2) || "AES".equalsIgnoreCase(string2) || "SM4".equalsIgnoreCase(string2)) {
            clearKeyParameter = ClearKeyParameter.getInstance(string2, false, Hex.decode(string));
        } else if ("SM2private".equalsIgnoreCase(string2)) {
            clearKeyParameter = ClearKeyParameter.getInstance("SM2", true, Hex.decode(string));
        } else if ("RSAprivate".equalsIgnoreCase(string2)) {
            clearKeyParameter = ClearKeyParameter.getInstance("RSA", true, Hex.decode(string));
        } else if ("SM2public".equalsIgnoreCase(string2)) {
            clearKeyParameter = ClearKeyParameter.getInstance("SM2", false, Hex.decode(string));
        } else if ("RSApublic".equalsIgnoreCase(string2)) {
            clearKeyParameter = ClearKeyParameter.getInstance("RSA", false, Hex.decode(string));
        }
        return clearKeyParameter;
    }

    public static HashMap<String, String> generateSM2KeyPair() throws Exception {
        if (IcbcEnvironment.isICBCEnvironment()) {
            throw new Exception("ClearKeyFunction not permit");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = Generator.generateSM2KeyPair();
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        String string = String.format("%1$064x", eCPrivateKeyParameters.getD());
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        String string2 = "04" + String.format("%1$064x", eCPublicKeyParameters.getQ().getAffineXCoord().toBigInteger()) + String.format("%1$064x", eCPublicKeyParameters.getQ().getAffineYCoord().toBigInteger());
        hashMap.put("privateKey", string);
        hashMap.put("publicKey", string2);
        return hashMap;
    }

    public static String getSM2PublicKey(ClearKeyParameter clearKeyParameter) {
        String string = null;
        if ("SM2private".equalsIgnoreCase(clearKeyParameter.getKeyType())) {
            CipherParameters cipherParameters = null;
            try {
                cipherParameters = clearKeyParameter.getBCkey();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cipherParameters instanceof ECPrivateKeyParameters) {
                ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)cipherParameters;
                ECPoint eCPoint = new FixedPointCombMultiplier().multiply(eCPrivateKeyParameters.getParameters().getG(), eCPrivateKeyParameters.getD()).normalize();
                string = "04" + String.format("%1$064x", eCPoint.getAffineXCoord().toBigInteger()) + String.format("%1$064x", eCPoint.getAffineYCoord().toBigInteger());
            }
        } else if ("SM2public".equalsIgnoreCase(clearKeyParameter.getKeyType())) {
            string = "04" + clearKeyParameter.getPublicKey().toUpperCase();
        }
        return string;
    }

    public KeyHolder generateKey(ClearKeyParameter clearKeyParameter, int n) throws Exception {
        if (IcbcEnvironment.isICBCEnvironment()) {
            throw new Exception("ClearKeyFunction not permit");
        }
        byte[] byArray = this.generateRandom(n);
        byte[] byArray2 = null;
        ClearKeyParameter clearKeyParameter2 = null;
        if ("RSA".equalsIgnoreCase(clearKeyParameter.getAlgorithm())) {
            if ("SM4".equalsIgnoreCase(this.algorithmType)) {
                throw new Exception("generating SymmetricKey type error! allow type: DES/DESede/AES");
            }
            byArray2 = AsymmetricCipher.encipher("PKCS1PADDING", true, clearKeyParameter, byArray);
            clearKeyParameter2 = ClearKeyFunction.loadClear(Hex.toHexString(byArray), this.algorithmType);
        }
        if ("SM2".equalsIgnoreCase(clearKeyParameter.getAlgorithm())) {
            if (!"SM4".equalsIgnoreCase(this.algorithmType)) {
                throw new Exception("generating SymmetricKey type error! allow type: SM4");
            }
            byArray2 = AsymmetricCipher.encipher("SM2", true, clearKeyParameter, byArray);
            clearKeyParameter2 = ClearKeyFunction.loadClear(Hex.toHexString(byArray), this.algorithmType);
        }
        KeyHolder keyHolder = new KeyHolder(clearKeyParameter2, Hex.toHexString(byArray2).toUpperCase());
        return keyHolder;
    }

    public ClearKeyParameter importKey(ClearKeyParameter clearKeyParameter, String string) throws Exception {
        if (IcbcEnvironment.isICBCEnvironment()) {
            throw new Exception("ClearKeyFunction not permit");
        }
        byte[] byArray = Hex.decode(string);
        byte[] byArray2 = null;
        if ("RSA".equalsIgnoreCase(clearKeyParameter.getAlgorithm())) {
            if ("SM4".equalsIgnoreCase(this.algorithmType)) {
                throw new Exception("generating SymmetricKey type error! allow type: DES/DESede/AES");
            }
            byArray2 = AsymmetricCipher.encipher("PKCS1PADDING", false, clearKeyParameter, byArray);
        }
        if ("SM2".equalsIgnoreCase(clearKeyParameter.getAlgorithm())) {
            if (!"SM4".equalsIgnoreCase(this.algorithmType)) {
                throw new Exception("generating SymmetricKey type error! allow type: SM4");
            }
            byArray2 = AsymmetricCipher.encipher("SM2", false, clearKeyParameter, byArray);
        }
        ClearKeyParameter clearKeyParameter2 = null;
        clearKeyParameter2 = ClearKeyFunction.loadClear(Hex.toHexString(byArray2), this.algorithmType);
        return clearKeyParameter2;
    }

    private byte[] generateRandom(int n) throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[20];
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = new byte[32];
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = PBEkeyGenerate.generatePBEKey("PBKDF2", "SM3", null, n, byArray, byArray2, 16);
        return byArray3;
    }

    public static String getCheckValue(ClearKeyParameter clearKeyParameter) {
        String string = null;
        byte[] byArray = null;
        Cipher cipher = Cipher.getInstance(clearKeyParameter.getAlgorithm(), "ECB", "NOPADDING");
        if ("DES".equalsIgnoreCase(clearKeyParameter.getAlgorithm())) {
            byArray = new byte[8];
        }
        if ("DESede".equalsIgnoreCase(clearKeyParameter.getAlgorithm())) {
            byArray = new byte[8];
        }
        if ("AES".equalsIgnoreCase(clearKeyParameter.getAlgorithm())) {
            byArray = new byte[16];
        }
        if ("SM4".equalsIgnoreCase(clearKeyParameter.getAlgorithm())) {
            byArray = new byte[16];
        }
        try {
            byte[] byArray2 = cipher.encipher(clearKeyParameter, byArray);
            string = Hex.toHexString(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static KeyHolder restoreKeyHolder(String string) {
        ClearKeyFunction clearKeyFunction2;
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split(";");
        if (stringArray.length != 3) {
            return null;
        }
        ClearKeyParameter clearKeyParameter = null;
        try {
            clearKeyParameter = ClearKeyFunction.loadClear(stringArray[1], stringArray[0]);
        }
        catch (Exception exception) {
            return null;
        }
        ClearKeyFunction clearKeyFunction3 = clearKeyFunction2 = ClearKeyFunction.getInstance(stringArray[0]);
        clearKeyFunction3.getClass();
        KeyHolder keyHolder = clearKeyFunction3.new KeyHolder(clearKeyParameter, stringArray[2]);
        return keyHolder;
    }

    public String[] generateEnvelope(String string) throws Exception {
        if (IcbcEnvironment.isICBCEnvironment()) {
            throw new Exception("ClearKeyFunction not permit");
        }
        String[] stringArray = new String[2];
        KeyHolder keyHolder = null;
        String string2 = null;
        String string3 = null;
        GenerateEnvelopeBean generateEnvelopeBean = new GenerateEnvelopeBean();
        ClearKeyParameter clearKeyParameter = null;
        String string4 = null;
        if (string != null && string.length() > 0) {
            if (!string.matches("(\\p{XDigit}{130})") || !string.substring(0, 2).equals("04")) {
                throw new ParmErrorException("generateEnvelope:PublicKey plaintext is error !" + string);
            }
            string4 = "SM2PUBLIC";
            generateEnvelopeBean.setKid(string);
            int n = 0;
            if (this.algorithmType.equals("SM4")) {
                n = 16;
            } else if (this.algorithmType.equals("DES")) {
                n = 8;
            } else if (this.algorithmType.equals("DESede")) {
                n = 24;
            } else if (this.algorithmType.equals("AES")) {
                n = 32;
            } else {
                throw new ParmErrorException("generateEnvelope:Symmetric key algorithmType is error !" + this.algorithmType);
            }
            try {
                clearKeyParameter = ClearKeyFunction.loadClear(string, string4);
                keyHolder = this.generateKey(clearKeyParameter, n);
            }
            catch (Exception exception) {
                throw new ParmErrorException("generateEnvelope:generateKey fail!" + exception.getMessage());
            }
            try {
                string2 = keyHolder.backupKeyHolder();
                string3 = keyHolder.getWappedExportedKey();
            }
            catch (Exception exception) {
                throw new ParmErrorException("generateEnvelope:From KeyHolder object to get key fail!" + exception.getMessage());
            }
        }
        throw new ParmErrorException("generateEnvelope:key is empty !");
        stringArray[0] = string2;
        String string5 = UrlBase64.toBase64String(Hex.decode(string3));
        generateEnvelopeBean.setVer("K0");
        generateEnvelopeBean.setKwAlg("SM2/ANS1");
        generateEnvelopeBean.setEncKey(string5);
        stringArray[1] = UrlBase64.toBase64String(generateEnvelopeBean.mapToString().getBytes("UTF-8"));
        return stringArray;
    }

    public ClearKeyParameter decryptEnvelope(ClearKeyParameter clearKeyParameter, String string) throws Exception {
        if (IcbcEnvironment.isICBCEnvironment()) {
            throw new Exception("ClearKeyFunction not permit");
        }
        ClearKeyParameter clearKeyParameter2 = null;
        String string2 = null;
        byte[] byArray = null;
        GenerateEnvelopeBean generateEnvelopeBean = new GenerateEnvelopeBean();
        if (string != null && string.length() > 0) {
            try {
                string2 = new String(UrlBase64.decode(string));
            }
            catch (Exception exception) {
                throw new ParmErrorException("decryptEnvelope:Data from UrlBase64String to JsonString fail!" + exception.getMessage());
            }
            try {
                generateEnvelopeBean.stringToMap(string2);
            }
            catch (Exception exception) {
                throw new ParmErrorException("decryptEnvelope:StringToMap fail!" + exception.getMessage());
            }
            String string3 = generateEnvelopeBean.getEncKey();
            if (string3 == null || string3.length() <= 0) {
                throw new ParmErrorException("decryptEnvelope:Key cryptograph is empty!" + string3);
            }
            byArray = UrlBase64.decode(string3);
            try {
                String string4 = Hex.toHexString(byArray);
                clearKeyParameter2 = this.importKey(clearKeyParameter, string4);
            }
            catch (Exception exception) {
                throw new ParmErrorException("decryptEnvelope:Decipher key cryptograph fail!" + exception.getMessage());
            }
        }
        throw new ParmErrorException("decryptEnvelope:Decipher data is empty\uff01" + string);
        return clearKeyParameter2;
    }

    public class KeyHolder {
        private ClearKeyParameter internalKey = null;
        private String ExportedKey = null;

        KeyHolder(ClearKeyParameter clearKeyParameter, String string) {
            this.internalKey = clearKeyParameter;
            this.ExportedKey = string;
        }

        public ClearKeyParameter getHsmKeyParameter() {
            return this.internalKey;
        }

        public String getWappedExportedKey() {
            return this.ExportedKey;
        }

        public String backupKeyHolder() {
            String string = this.internalKey.getAlgorithm();
            byte[] byArray = null;
            try {
                byArray = ((KeyParameter)this.internalKey.getBCkey()).getKey();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder(1024);
            stringBuilder.append(string).append(";").append(Hex.toHexString(byArray)).append(";").append(this.ExportedKey);
            return stringBuilder.toString();
        }
    }
}

