/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.parms;

import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.PBEParametersGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SM3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.params.KeyParameter;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.basic.MessageDigest;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.utils.CallerCheck;
import com.icbc.hsm.software.utils.Helper;
import com.icbc.hsm.utils.encoders.Hex;
import java.security.SecureRandom;
import java.util.Arrays;

public class ClearKeyParameter
implements HsmKeyParameter {
    private transient String algorithmType;
    private transient Long keyLengthInBit;
    private transient boolean isPrivate;
    private transient byte[] key;
    private transient byte[] password;
    private transient byte[] salt = null;
    private byte[] id;

    @Override
    public String getAlgorithm() {
        return this.algorithmType;
    }

    public int getKeySize() {
        return this.keyLengthInBit.intValue();
    }

    public CipherParameters getBCkey() throws Exception {
        byte[] byArray = this.getPassword(this.password, this.key.length * 8);
        byte[] byArray2 = this.key;
        byte[] byArray3 = null;
        byArray3 = ("SM2".equalsIgnoreCase(this.algorithmType) || "RSA".equalsIgnoreCase(this.algorithmType)) && !this.isPrivate ? Arrays.copyOfRange(byArray2, 0, byArray2.length) : this.unwapKey(byArray2, byArray);
        CipherParameters cipherParameters = null;
        cipherParameters = "SM2".equalsIgnoreCase(this.algorithmType) || "RSA".equalsIgnoreCase(this.algorithmType) ? Helper.toAsymmetricKey(byArray3, this.getKeyType()) : new KeyParameter(byArray3);
        return cipherParameters;
    }

    public static ClearKeyParameter getInstance(String string, byte[] byArray) throws Exception {
        ClearKeyParameter clearKeyParameter = ClearKeyParameter.getInstance(string, false, byArray);
        return clearKeyParameter;
    }

    public static ClearKeyParameter getInstance(String string, boolean bl, byte[] byArray) throws Exception {
        if (IcbcEnvironment.isICBCEnvironment() && !CallerCheck.check(ClearKeyParameter.class.getName())) {
            throw new Exception("clear key function not permit");
        }
        ClearKeyParameter clearKeyParameter = new ClearKeyParameter(string, bl, byArray);
        return clearKeyParameter;
    }

    protected ClearKeyParameter() {
    }

    protected ClearKeyParameter(String string, byte[] byArray) {
        this(string, false, byArray);
    }

    protected ClearKeyParameter(String string, boolean bl, byte[] byArray) {
        this.algorithmType = string;
        this.keyLengthInBit = byArray.length * 8;
        this.isPrivate = bl;
        try {
            this.password = MessageDigest.digest("SM3", byArray);
        }
        catch (Exception exception) {
            this.password = new byte[0];
        }
        if (("SM2".equalsIgnoreCase(string) || "RSA".equalsIgnoreCase(string)) && !bl) {
            this.key = Arrays.copyOf(byArray, byArray.length);
        } else {
            byte[] byArray2 = this.getPassword(this.password, byArray.length * 8);
            this.key = this.wapKey(byArray, byArray2);
        }
    }

    public void setId(byte[] byArray) {
        if (byArray == null) {
            this.id = null;
            return;
        }
        this.id = Arrays.copyOf(byArray, byArray.length);
    }

    public byte[] getId() {
        if (this.id == null) {
            return null;
        }
        return Arrays.copyOf(this.id, this.id.length);
    }

    public String toString() {
        return null;
    }

    public String getPublicKey() {
        if (!this.isPrivate) {
            return Hex.toHexString(this.key);
        }
        return null;
    }

    private byte[] getPassword(byte[] byArray, int n) {
        Object object;
        if (this.salt == null) {
            object = new SecureRandom();
            this.salt = new byte[32];
            ((SecureRandom)object).nextBytes(this.salt);
        }
        object = new PKCS5S2ParametersGenerator(new SM3Digest());
        ((PBEParametersGenerator)object).init(byArray, this.salt, 16);
        KeyParameter keyParameter = (KeyParameter)((PKCS5S2ParametersGenerator)object).generateDerivedParameters(n);
        return keyParameter.getKey();
    }

    private byte[] wapKey(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)((byArray[i] ^ byArray2[i]) & 0xFF);
        }
        return byArray3;
    }

    private byte[] unwapKey(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[this.key.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)((this.key[i] ^ byArray2[i]) & 0xFF);
        }
        return byArray3;
    }

    public String getKeyType() {
        if ("SM2".equalsIgnoreCase(this.algorithmType)) {
            if (this.isPrivate) {
                return "SM2private";
            }
            return "SM2public";
        }
        if ("RSA".equalsIgnoreCase(this.algorithmType)) {
            if (this.isPrivate) {
                return "RSAprivate";
            }
            return "RSApublic";
        }
        return null;
    }
}

