/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.utils;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Object;
import com.icbc.bcprov.org.bouncycastle.asn1.gm.GMNamedCurves;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.X9ECParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECDomainParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECCurve;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint;
import com.icbc.bcprov.org.bouncycastle.util.encoders.Hex;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcAsymmetricKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcSymmetricKeyParameter;
import com.icbc.hsm.software.parms.icbc.TempKeyBuilder;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class Helper {
    private Helper() {
    }

    public static AsymmetricKeyParameter toAsymmetricKey(byte[] byArray, String string) throws Exception {
        if ("SM2private".equalsIgnoreCase(string)) {
            X9ECParameters x9ECParameters = GMNamedCurves.getByName("sm2p256v1");
            ECCurve eCCurve = x9ECParameters.getCurve();
            ECPoint eCPoint = x9ECParameters.getG();
            ECDomainParameters eCDomainParameters = new ECDomainParameters(eCCurve, eCPoint, eCCurve.getOrder());
            BigInteger bigInteger = new BigInteger(1, byArray);
            ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(bigInteger, eCDomainParameters);
            return eCPrivateKeyParameters;
        }
        if ("SM2public".equalsIgnoreCase(string)) {
            X9ECParameters x9ECParameters = GMNamedCurves.getByName("sm2p256v1");
            ECCurve eCCurve = x9ECParameters.getCurve();
            ECPoint eCPoint = x9ECParameters.getG();
            ECDomainParameters eCDomainParameters = new ECDomainParameters(eCCurve, eCPoint, eCCurve.getOrder());
            String string2 = Hex.toHexString(byArray);
            if (!string2.startsWith("04")) {
                throw new Exception("key data error!");
            }
            String string3 = string2.substring(2, 66);
            String string4 = string2.substring(66);
            ECPoint eCPoint2 = eCCurve.createPoint(new BigInteger(string3, 16), new BigInteger(string4, 16));
            ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(eCPoint2, eCDomainParameters);
            return eCPublicKeyParameters;
        }
        if ("RSAprivate".equalsIgnoreCase(string)) {
            RSAPrivateKey rSAPrivateKey = RSAPrivateKey.getInstance(byArray);
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getPrime1(), rSAPrivateKey.getPrime2(), rSAPrivateKey.getExponent1(), rSAPrivateKey.getExponent2(), rSAPrivateKey.getCoefficient());
            return rSAPrivateCrtKeyParameters;
        }
        if ("RSApublic".equalsIgnoreCase(string)) {
            RSAPublicKey rSAPublicKey = RSAPublicKey.getInstance(byArray);
            RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            return rSAKeyParameters;
        }
        throw new Exception("key type not support! " + string);
    }

    public static CipherParameters toBCkey(CipherParameters cipherParameters) throws Exception {
        CipherParameters cipherParameters2 = cipherParameters;
        if (cipherParameters instanceof ClearKeyParameter) {
            cipherParameters2 = ((ClearKeyParameter)cipherParameters).getBCkey();
        }
        if (IcbcEnvironment.isICBCEnvironment()) {
            if (cipherParameters instanceof IcbcSymmetricKeyParameter) {
                cipherParameters2 = ((IcbcSymmetricKeyParameter)cipherParameters).getBCkey();
            }
            if (cipherParameters instanceof IcbcAsymmetricKeyParameter) {
                cipherParameters2 = ((IcbcAsymmetricKeyParameter)cipherParameters).getBCkey();
            }
        }
        return cipherParameters2;
    }

    public static CipherParameters toClearRsaKey(byte[] byArray) {
        Object object;
        Key key;
        EncodedKeySpec encodedKeySpec;
        KeyFactory keyFactory;
        ClearKeyParameter clearKeyParameter = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            encodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            key = (java.security.interfaces.RSAPrivateKey)keyFactory.generatePrivate(encodedKeySpec);
            if (key instanceof RSAPrivateCrtKey) {
                object = (RSAPrivateCrtKey)key;
                RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(object.getModulus(), object.getPublicExponent(), object.getPrivateExponent(), object.getPrimeP(), object.getPrimeQ(), object.getPrimeExponentP(), object.getPrimeExponentQ(), object.getCrtCoefficient());
                clearKeyParameter = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)"RSA", (boolean)true, (byte[])rSAPrivateKey.getEncoded()) : ClearKeyParameter.getInstance("RSA", true, rSAPrivateKey.getEncoded());
            } else if (key instanceof java.security.interfaces.RSAPrivateKey) {
                object = new RSAPrivateKey(key.getModulus(), new BigInteger("0"), key.getPrivateExponent(), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"));
                clearKeyParameter = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)"RSA", (boolean)true, (byte[])((ASN1Object)object).getEncoded()) : ClearKeyParameter.getInstance("RSA", true, ((ASN1Object)object).getEncoded());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clearKeyParameter == null) {
            try {
                keyFactory = KeyFactory.getInstance("RSA");
                encodedKeySpec = new X509EncodedKeySpec(byArray);
                key = (java.security.interfaces.RSAPublicKey)keyFactory.generatePublic(encodedKeySpec);
                object = new RSAPublicKey(key.getModulus(), key.getPublicExponent());
                clearKeyParameter = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)"RSA", (boolean)false, (byte[])((ASN1Object)object).getEncoded()) : ClearKeyParameter.getInstance("RSA", false, ((ASN1Object)object).getEncoded());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return clearKeyParameter;
    }

    public static byte[] toPKCS1(byte[] byArray) {
        Object object;
        Key key;
        EncodedKeySpec encodedKeySpec;
        KeyFactory keyFactory;
        byte[] byArray2 = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            encodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            key = (java.security.interfaces.RSAPrivateKey)keyFactory.generatePrivate(encodedKeySpec);
            if (key instanceof RSAPrivateCrtKey) {
                object = (RSAPrivateCrtKey)key;
                RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(object.getModulus(), object.getPublicExponent(), object.getPrivateExponent(), object.getPrimeP(), object.getPrimeQ(), object.getPrimeExponentP(), object.getPrimeExponentQ(), object.getCrtCoefficient());
                byArray2 = rSAPrivateKey.getEncoded();
            } else if (key instanceof java.security.interfaces.RSAPrivateKey) {
                object = new RSAPrivateKey(key.getModulus(), new BigInteger("0"), key.getPrivateExponent(), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"));
                byArray2 = ((ASN1Object)object).getEncoded();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray2 == null) {
            try {
                keyFactory = KeyFactory.getInstance("RSA");
                encodedKeySpec = new X509EncodedKeySpec(byArray);
                key = (java.security.interfaces.RSAPublicKey)keyFactory.generatePublic(encodedKeySpec);
                object = new RSAPublicKey(key.getModulus(), key.getPublicExponent());
                byArray2 = ((ASN1Object)object).getEncoded();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return byArray2;
    }
}

