/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.api;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.crl.X509CRL;
import com.cfca.util.pki.extension.CRLDistributionPointsExt;
import com.cfca.util.pki.extension.DistributionPointsExt;
import com.cfca.util.pki.pkcs.P7B;
import com.cfca.util.pki.pkcs.PKCS12;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class CertUtil {
    public static X509Cert getCert(byte[] pfxData, String pfxPWD) throws PKIException {
        PKCS12 p12 = new PKCS12();
        p12.load(pfxData);
        p12.decrypt(pfxPWD.toCharArray());
        return p12.getCertificate();
    }

    public static X509Cert getCert(String pfxPath, String pfxPWD) throws PKIException {
        PKCS12 p12 = new PKCS12();
        p12.load(pfxPath);
        p12.decrypt(pfxPWD.toCharArray());
        return p12.getCertificate();
    }

    public static void changePfxPWD(String oldPfxPath, String oldPfxPWD, String newPfxPath, String newPfxPWD) throws PKIException {
        PKCS12 p12 = new PKCS12();
        p12.load(oldPfxPath);
        p12.decrypt(oldPfxPWD.toCharArray());
        p12.generatePfxFile(p12.getPrivateKey(), p12.getCerts(), newPfxPWD.toCharArray(), newPfxPath);
    }

    public static X509Cert generateCert(byte[] certData) throws PKIException {
        X509Cert cert = new X509Cert(certData);
        return cert;
    }

    public static X509Cert generateCert(String certPath) throws PKIException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(certPath);
        }
        catch (FileNotFoundException ex) {
            throw new PKIException("850900", "\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728 " + ex.getMessage());
        }
        X509Cert cert = new X509Cert((InputStream)fis);
        return cert;
    }

    public static X509Cert[] parseP7b(byte[] data) throws PKIException {
        P7B p7b = new P7B();
        return p7b.parseP7b(data);
    }

    public static X509Cert[] parseP7b(String p7bPath) throws PKIException {
        P7B p7b = new P7B();
        return p7b.parseP7b(p7bPath);
    }

    public static boolean verifyCert(X509Cert userCert, X509Cert[] caCerts, String crlPath, Session session) throws PKIException {
        CertUtil.verifyCertDate(userCert);
        if (CertUtil.verifyCertSign(userCert, caCerts, session)) {
            if (crlPath != null) {
                return CertUtil.verifyCertByCRLOutLine(userCert, crlPath, caCerts, session);
            }
            return CertUtil.verifyCertByCRLOnLine(userCert);
        }
        return false;
    }

    public static boolean verifyCertSign(X509Cert userCert, X509Cert[] caCerts, Session session) throws PKIException {
        if (caCerts.length < 1) {
            throw new PKIException("850903", "\u8bc1\u4e66\u94fe\u4e3a\u7a7a");
        }
        if (caCerts.length == 1) {
            return userCert.verify(caCerts[0].getPublicKey(), session);
        }
        CertUtil.verifyCertChain(caCerts, userCert.getIssuer(), session);
        boolean userCertSignVerify = userCert.verify(caCerts[0].getPublicKey(), session);
        return userCertSignVerify;
    }

    public static boolean verifyCertDate(X509Cert userCert) throws PKIException {
        X509Certificate cert = Parser.convertX509Cert((X509Cert)userCert);
        try {
            cert.checkValidity();
        }
        catch (CertificateNotYetValidException ex) {
            throw new PKIException("850901", "\u8bc1\u4e66\u672a\u751f\u6548");
        }
        catch (CertificateExpiredException ex) {
            throw new PKIException("850902", "\u8bc1\u4e66\u5df2\u8fc7\u671f");
        }
        return true;
    }

    public static boolean verifyCertByCRLOutLine(X509Cert userCert, String crlPath, X509Cert[] caCerts, Session session) throws PKIException {
        File file = new File(crlPath);
        if (file.isDirectory()) {
            CRLDistributionPointsExt crlDistExt = userCert.getCRLDistributionPoints();
            DistributionPointsExt crlName = crlDistExt.getDistributionPoint(0);
            String crlPointName = crlName.getDistributionPointNameByFullName(0);
            int cnIndex = crlPointName.indexOf("CN=");
            int conIndex = crlPointName.indexOf(",");
            if (cnIndex != -1 && conIndex != -1) {
                crlPointName = crlPointName.substring(cnIndex + 3, conIndex);
            }
            String issuer = userCert.getIssuer();
            cnIndex = issuer.indexOf("O=");
            conIndex = issuer.indexOf(",");
            if (cnIndex != -1 && conIndex != -1) {
                issuer = issuer.substring(cnIndex + 2, conIndex);
            }
            boolean revoke = false;
            String crlFilePath = String.valueOf(crlPath) + File.separator + issuer + File.separator + crlPointName + ".crl";
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(crlFilePath);
            }
            catch (Exception ex) {
                throw new PKIException("850920", "\u8bfbCRL\u6587\u4ef6\u5931\u8d25 " + ex.getMessage(), ex);
            }
            X509CRL crl = new X509CRL((InputStream)inStream);
            try {
                ((InputStream)inStream).close();
            }
            catch (IOException ex1) {
                throw new PKIException("850920", "\u8bfbCRL\u6587\u4ef6\u5931\u8d25 " + ex1.getMessage(), (Exception)ex1);
            }
            CertUtil.verifyCertChain(caCerts, crl.getIssuer(), session);
            boolean verifySignature = crl.verify(caCerts[0].getPublicKey(), session);
            if (!verifySignature) {
                throw new PKIException("850921", "\u9a8c\u8bc1CRL\u7b7e\u540d\u5931\u8d25");
            }
            if (!crl.isRevoke(userCert.getSerialNumber())) {
                revoke = true;
            }
            return revoke;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new PKIException("850906", "CRL\u6587\u4ef6\u4e0d\u5b58\u5728", (Exception)ex);
        }
        X509CRL crl = new X509CRL((InputStream)fis);
        CertUtil.verifyCertChain(caCerts, crl.getIssuer(), session);
        boolean verifySignature = crl.verify(caCerts[0].getPublicKey(), session);
        if (!verifySignature) {
            throw new PKIException("850921", "\u9a8c\u8bc1CRL\u7b7e\u540d\u5931\u8d25");
        }
        return !crl.isRevoke(userCert);
    }

    public static boolean verifyCertByCRLOutLine(X509Cert userCert, byte[] crlData, X509Cert[] caCerts, Session session) throws PKIException {
        X509CRL crl = new X509CRL(crlData);
        CertUtil.verifyCertChain(caCerts, crl.getIssuer(), session);
        boolean verifySignature = crl.verify(caCerts[0].getPublicKey(), session);
        if (!verifySignature) {
            throw new PKIException("850921", "\u9a8c\u8bc1CRL\u7b7e\u540d\u5931\u8d25");
        }
        return !crl.isRevoke(userCert);
    }

    public static boolean verifyCertByCRLOnLine(X509Cert userCert) throws PKIException {
        CRLDistributionPointsExt crlDistExt = userCert.getCRLDistributionPoints();
        int crlDistCount = crlDistExt.getDistributionPointCount();
        String crl = null;
        int i = 0;
        while (i < crlDistCount) {
            DistributionPointsExt crlName = crlDistExt.getDistributionPoint(i);
            String crlPointName = crlName.getDistributionPointNameByFullName(0);
            if (crlPointName.indexOf("ldap://") != -1) {
                crl = crlPointName;
            }
            ++i;
        }
        if (crl == null) {
            throw new PKIException("850904", "\u7528\u6237\u8bc1\u4e66\u4e2d\u6ca1\u6709CRL\u7684\u76ee\u5f55\u4fe1\u606f");
        }
        int ldapIndex = crl.indexOf("ldap://");
        crl = crl.substring(ldapIndex + 7, crl.length());
        ldapIndex = crl.indexOf(":");
        String ip = crl.substring(0, ldapIndex);
        crl = crl.substring(ldapIndex + 1, crl.length());
        ldapIndex = crl.indexOf("/");
        String port = crl.substring(0, ldapIndex);
        crl = crl.substring(ldapIndex + 1, crl.length());
        ldapIndex = crl.indexOf("?");
        String dn = crl.substring(0, ldapIndex);
        String cn = crl.substring(crl.indexOf("=") + 1, crl.indexOf(","));
        boolean revoke = false;
        X509CRL x509Crl = null;
        try {
            x509Crl = CertUtil.getCRLFromLDAP(ip, port, dn, cn);
        }
        catch (Exception ex) {
            throw new PKIException("850905", "\u4ece\u76ee\u5f55\u670d\u52a1\u5668\u4e0b\u8f7dCRL\u5931\u8d25", ex);
        }
        revoke = x509Crl.isRevoke(userCert);
        return !revoke;
    }

    public static boolean verifyCertByCRLOnLineMirror(String mirrorLdapIp, String port, X509Cert userCert) throws PKIException {
        CRLDistributionPointsExt crlDistExt = userCert.getCRLDistributionPoints();
        int crlDistCount = crlDistExt.getDistributionPointCount();
        String crl = null;
        int i = 0;
        while (i < crlDistCount) {
            DistributionPointsExt crlName = crlDistExt.getDistributionPoint(i);
            String crlPointName = crlName.getDistributionPointNameByFullName(0);
            if (crlPointName.indexOf("ldap://") != -1) {
                crl = crlPointName;
            }
            ++i;
        }
        if (crl == null) {
            throw new PKIException("850904", "\u7528\u6237\u8bc1\u4e66\u4e2d\u6ca1\u6709CRL\u7684\u76ee\u5f55\u4fe1\u606f");
        }
        int ldapIndex = crl.indexOf("ldap://");
        crl = crl.substring(ldapIndex + 7, crl.length());
        ldapIndex = crl.indexOf(":");
        crl = crl.substring(ldapIndex + 1, crl.length());
        ldapIndex = crl.indexOf("/");
        crl = crl.substring(ldapIndex + 1, crl.length());
        ldapIndex = crl.indexOf("?");
        String dn = crl.substring(0, ldapIndex);
        String cn = crl.substring(crl.indexOf("=") + 1, crl.indexOf(","));
        boolean revoke = false;
        X509CRL x509Crl = null;
        try {
            x509Crl = CertUtil.getCRLFromLDAP(mirrorLdapIp, port, dn, cn);
        }
        catch (Exception ex) {
            throw new PKIException("850905", "\u4ece\u76ee\u5f55\u670d\u52a1\u5668\u4e0b\u8f7dCRL\u5931\u8d25", ex);
        }
        revoke = x509Crl.isRevoke(userCert);
        return !revoke;
    }

    private static X509CRL getCRLFromLDAP(String ip, String port, String dn, String cn) throws Exception {
        InitialDirContext ctx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + ip + ":" + port);
        env.put("java.naming.ldap.attributes.binary", "certificateRevocationList");
        ctx = new InitialDirContext(env);
        SearchControls tConstraints = new SearchControls();
        tConstraints.setSearchScope(2);
        NamingEnumeration<SearchResult> tResults = null;
        String filter = "(&(objectclass=cRLDistributionPoint)(cn=" + cn + "))";
        Object[] attrs = new String[]{"certificateRevocationList;binary"};
        X509CRL crl = null;
        tResults = ctx.search(dn, filter, attrs, tConstraints);
        if (tResults != null && tResults.hasMore()) {
            while (tResults.hasMore()) {
                SearchResult tSearchRel = tResults.next();
                Attributes allAttrs = tSearchRel.getAttributes();
                Attribute attCRL = allAttrs.get("certificateRevocationList;binary");
                byte[] bCRL = (byte[])attCRL.get(0);
                crl = new X509CRL(bCRL);
            }
        }
        ctx.close();
        return crl;
    }

    private static void verifyCertChain(X509Cert[] caCerts, String issuer, Session session) throws PKIException {
        if (caCerts.length == 1) {
            if (!caCerts[0].getSubject().equals(issuer)) {
                throw new PKIException("850907", "CA\u8bc1\u4e66\u94fe\u4e0d\u6b63\u786e");
            }
        } else {
            X509Cert tempCert = null;
            int i = 0;
            while (i < caCerts.length) {
                int j = caCerts.length - 1;
                while (j > i) {
                    if (caCerts[j].getIssuer().equals(caCerts[j - 1].getSubject())) {
                        tempCert = caCerts[j - 1];
                        caCerts[j - 1] = caCerts[j];
                        caCerts[j] = tempCert;
                    }
                    --j;
                }
                ++i;
            }
            if (!caCerts[0].getSubject().equals(issuer)) {
                throw new PKIException("850907", "CA\u8bc1\u4e66\u94fe\u4e0d\u6b63\u786e");
            }
            int j = 0;
            while (j < caCerts.length) {
                if (j != caCerts.length - 1) {
                    if (!caCerts[j].getIssuer().equals(caCerts[j + 1].getSubject())) {
                        throw new PKIException("850907", "CA\u8bc1\u4e66\u94fe\u4e0d\u6b63\u786e");
                    }
                    if (!caCerts[j].verify(caCerts[j + 1].getPublicKey(), session)) {
                        throw new PKIException("850908", "\u9a8c\u8bc1CA\u8bc1\u4e66\u94fe\u4e2d\u7684\u8bc1\u4e66\u7b7e\u540d\u5931\u8d25");
                    }
                } else {
                    if (!caCerts[j].getSubject().equals(caCerts[j].getIssuer())) {
                        throw new PKIException("850907", "CA\u8bc1\u4e66\u94fe\u4e0d\u6b63\u786e");
                    }
                    if (!caCerts[j].verify(caCerts[j].getPublicKey(), session)) {
                        throw new PKIException("850907", "CA\u8bc1\u4e66\u94fe\u4e0d\u6b63\u786e");
                    }
                }
                ++j;
            }
        }
    }

    public static void main(String[] args) {
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            CertUtil.changePfxPWD("c:/superChange.pfx", "1", "c:/superChange.pfx", "111");
            int a = 9;
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }
}

