/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.api;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cipher.param.CBCParam;
import com.cfca.util.pki.encoders.Base64;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class EncryptUtil {
    public static final String RC4 = "RC4";
    public static final String DES_ECB = "DES/ECB/PKCS7Padding";
    public static final String DES_CBC = "DES/CBC/PKCS7Padding";
    public static final String DES3_ECB = "DESede/ECB/PKCS7Padding";
    public static final String DES3_CBC = "DESede/CBC/PKCS7Padding";
    public static final String PBE_MD5_DES = "PBEWithMD5AndDES";
    public static final String PBE_SHA1_DES = "PBEWithSHA1AndDES";
    public static final String PBE_SHA1_RC4 = "PBEWITHSHAAND128BITRC4";
    public static final String PBE_SHA1_3DES = "PBEWITHSHAAND3-KEYTRIPLEDES-CBC";
    public static final byte[] IV_8 = new byte[]{50, 51, 52, 53, 54, 55, 56, 57};
    public static final byte[] IV_16 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};

    public static byte[] encryptByKey(String encryptType, JKey key, byte[] sourceData, Session session) throws PKIException {
        if (!(encryptType.equals(RC4) || encryptType.equals(DES_ECB) || encryptType.equals(DES_CBC) || encryptType.equals(DES3_ECB) || encryptType.equals(DES3_CBC))) {
            throw new PKIException("850916", "\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5\u7c7b\u578b");
        }
        Mechanism encryptMech = null;
        byte[] encData = null;
        if (encryptType.indexOf("CBC") > 0 && encryptType.indexOf("AES") > 0) {
            CBCParam cbc = new CBCParam();
            cbc.setIv(IV_16);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else if (encryptType.indexOf("CBC") > 0) {
            CBCParam cbc = new CBCParam();
            cbc.setIv(IV_8);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else {
            encryptMech = new Mechanism(encryptType);
        }
        encData = session.encrypt(encryptMech, key, sourceData);
        return Base64.encode((byte[])encData);
    }

    public static void encryptFileByKey(String encryptType, JKey key, String srcFile, String encFile, int bufferSize, Session session) throws PKIException {
        if (!(encryptType.equals(RC4) || encryptType.equals(DES_ECB) || encryptType.equals(DES_CBC) || encryptType.equals(DES3_ECB) || encryptType.equals(DES3_CBC))) {
            throw new PKIException("850916", "\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5\u7c7b\u578b");
        }
        Mechanism encryptMech = null;
        if (encryptType.indexOf("CBC") > 0 && encryptType.indexOf("AES") > 0) {
            CBCParam cbc = new CBCParam();
            cbc.setIv(IV_16);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else if (encryptType.indexOf("CBC") > 0) {
            CBCParam cbc = new CBCParam();
            cbc.setIv(IV_8);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else {
            encryptMech = new Mechanism(encryptType);
        }
        session.encrypt(encryptMech, key, srcFile, encFile, bufferSize);
    }

    public static byte[] decryptByKey(String encryptType, JKey key, byte[] encryptedData, Session session) throws PKIException {
        if (!(encryptType.equals(RC4) || encryptType.equals(DES_ECB) || encryptType.equals(DES_CBC) || encryptType.equals(DES3_ECB) || encryptType.equals(DES3_CBC))) {
            throw new PKIException("850916", "\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5\u7c7b\u578b");
        }
        Mechanism encryptMech = null;
        byte[] srcData = null;
        if (encryptType.indexOf("CBC") > 0 && encryptType.indexOf("AES") > 0) {
            CBCParam cbc = new CBCParam();
            cbc.setIv(IV_16);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else if (encryptType.indexOf("CBC") > 0) {
            CBCParam cbc = new CBCParam();
            cbc.setIv(IV_8);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else {
            encryptMech = new Mechanism(encryptType);
        }
        srcData = session.decrypt(encryptMech, key, Base64.decode((byte[])encryptedData));
        return srcData;
    }

    public static void decryptFileByKey(String encryptType, JKey key, String encFile, String srcFile, int bufferSize, Session session) throws PKIException {
        if (!(encryptType.equals(RC4) || encryptType.equals(DES_ECB) || encryptType.equals(DES_CBC) || encryptType.equals(DES3_ECB) || encryptType.equals(DES3_CBC))) {
            throw new PKIException("850916", "\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5\u7c7b\u578b");
        }
        Mechanism encryptMech = null;
        byte[] srcData = null;
        if (encryptType.indexOf("CBC") > 0 && encryptType.indexOf("AES") > 0) {
            CBCParam cbc = new CBCParam();
            cbc.setIv(IV_16);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else if (encryptType.indexOf("CBC") > 0) {
            CBCParam cbc = new CBCParam();
            cbc.setIv(IV_8);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else {
            encryptMech = new Mechanism(encryptType);
        }
        session.decrypt(encryptMech, key, encFile, srcFile, bufferSize);
    }

    public static byte[] encryptByPWD(String encryptType, String pwd, byte[] sourceData, Session session) throws PKIException {
        byte[] encData = EncryptUtil.pbeCipherMessage(encryptType, pwd, true, sourceData);
        return Base64.encode((byte[])encData);
    }

    public static void encryptFileByPWD(String encryptType, String pwd, String srcFile, String encFile, int bufferSize, Session session) throws PKIException {
        EncryptUtil.pbeCipherFile(encryptType, pwd, true, srcFile, encFile, bufferSize);
    }

    public static byte[] decryptByPWD(String encryptType, String pwd, byte[] encryptedData, Session session) throws PKIException {
        byte[] encData = EncryptUtil.pbeCipherMessage(encryptType, pwd, false, Base64.decode((byte[])encryptedData));
        return encData;
    }

    public static void decryptFileByPWD(String encryptType, String pwd, String encFile, String srcFile, int bufferSize, Session session) throws PKIException {
        EncryptUtil.pbeCipherFile(encryptType, pwd, false, srcFile, encFile, bufferSize);
    }

    private static byte[] pbeCipherMessage(String encryptType, String pwd, boolean isEncrypt, byte[] data) throws PKIException {
        if (!encryptType.equals(PBE_MD5_DES) && !encryptType.equals(PBE_SHA1_DES)) {
            throw new PKIException("850916", "\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5\u7c7b\u578b");
        }
        try {
            IvParameterSpec iv;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(pwd.getBytes());
            KeySpec dks = null;
            SecretKeyFactory keyFactory = null;
            Cipher cipher = null;
            if (encryptType.equals(PBE_MD5_DES) || encryptType.equals(PBE_SHA1_DES)) {
                dks = new DESKeySpec(md.digest());
                keyFactory = SecretKeyFactory.getInstance("DES");
                cipher = Cipher.getInstance("DES/CBC/PKCS5Padding", "BC");
            } else {
                dks = new DESedeKeySpec(md.digest());
                keyFactory = SecretKeyFactory.getInstance("DESede");
                cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding", "BC");
            }
            SecretKey key = keyFactory.generateSecret(dks);
            IvParameterSpec paramSpec = iv = new IvParameterSpec(IV_8);
            if (isEncrypt) {
                cipher.init(1, (Key)key, paramSpec);
            } else {
                cipher.init(2, (Key)key, paramSpec);
            }
            byte[] encryptedData = cipher.doFinal(data);
            return encryptedData;
        }
        catch (GeneralSecurityException ex) {
            throw new PKIException("850936", "\u4f7f\u7528\u53e3\u4ee4\u52a0\u89e3\u5bc6\u5b89\u5168\u53c2\u6570\u9519\u8bef", (Exception)ex);
        }
    }

    private static void pbeCipherFile(String encryptType, String pwd, boolean isEncrypt, String sourceFile, String encFile, int bufferSize) throws PKIException {
        if (!encryptType.equals(PBE_MD5_DES) && !encryptType.equals(PBE_SHA1_DES)) {
            throw new PKIException("850916", "\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5\u7c7b\u578b");
        }
        try {
            IvParameterSpec iv;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(pwd.getBytes());
            KeySpec dks = null;
            SecretKeyFactory keyFactory = null;
            Cipher cipher = null;
            if (encryptType.equals(PBE_MD5_DES) || encryptType.equals(PBE_SHA1_DES)) {
                dks = new DESKeySpec(md.digest());
                keyFactory = SecretKeyFactory.getInstance("DES");
                cipher = Cipher.getInstance("DES/CBC/PKCS5Padding", "BC");
            } else {
                dks = new DESedeKeySpec(md.digest());
                keyFactory = SecretKeyFactory.getInstance("DESede");
                cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding", "BC");
            }
            SecretKey key = keyFactory.generateSecret(dks);
            IvParameterSpec paramSpec = iv = new IvParameterSpec(IV_8);
            if (isEncrypt) {
                cipher.init(1, (Key)key, paramSpec);
            } else {
                cipher.init(2, (Key)key, paramSpec);
            }
            byte[] buffer = new byte[bufferSize];
            if (isEncrypt) {
                FileOutputStream fos = new FileOutputStream(encFile);
                BufferedOutputStream bufferOS = new BufferedOutputStream(fos, bufferSize);
                CipherInputStream cipherInputStream = new CipherInputStream(new FileInputStream(sourceFile), cipher);
                BufferedInputStream bufferIS = new BufferedInputStream(cipherInputStream, bufferSize);
                int len = 0;
                while ((len = bufferIS.read(buffer)) > 0) {
                    bufferOS.write(buffer, 0, len);
                }
                bufferOS.close();
                bufferIS.close();
            } else {
                FileOutputStream fos = new FileOutputStream(sourceFile);
                BufferedOutputStream bufferOS = new BufferedOutputStream(fos, bufferSize);
                CipherInputStream cipherInputStream = new CipherInputStream(new FileInputStream(encFile), cipher);
                BufferedInputStream bufferIS = new BufferedInputStream(cipherInputStream, bufferSize);
                int len = 0;
                while ((len = bufferIS.read(buffer)) > 0) {
                    bufferOS.write(buffer, 0, len);
                }
                bufferOS.close();
                bufferIS.close();
            }
        }
        catch (IOException ex) {
            throw new PKIException("850937", "\u4f7f\u7528\u53e3\u4ee4\u52a0\u89e3\u5bc6\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", (Exception)ex);
        }
        catch (GeneralSecurityException ex) {
            throw new PKIException("850936", "\u4f7f\u7528\u53e3\u4ee4\u52a0\u89e3\u5bc6\u5b89\u5168\u53c2\u6570\u9519\u8bef", (Exception)ex);
        }
    }

    public static void main(String[] args) {
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            byte[] cipher = EncryptUtil.encryptByPWD(PBE_SHA1_DES, "11111111", "hello".getBytes(), session);
            System.out.println(new String(cipher));
            byte[] content = EncryptUtil.decryptByPWD(PBE_SHA1_DES, "11111111", cipher, session);
            System.out.println(new String(content));
            EncryptUtil.encryptFileByPWD(PBE_SHA1_DES, "11111111", "F:\\test\\\u6d4b\u8bd5100M.doc", "F:\\test\\\u6d4b\u8bd5100M.doc.enc", 0x100000, session);
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }
}

