/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.api;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.api.SignatureUtil;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.encoders.Base64;
import com.cfca.util.pki.pkcs.PKCS8;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.security.cert.X509Certificate;
import sun.misc.BASE64Encoder;

public class JKSToKey {
    private static String sta = "";

    public void convert(String filePath, String pwd) {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream fileInput = new FileInputStream(filePath);
            keyStore.load(fileInput, pwd.toCharArray());
            Enumeration<String> enmueration = keyStore.aliases();
            while (enmueration.hasMoreElements()) {
                String alia = enmueration.nextElement();
                if (keyStore.isCertificateEntry(alia)) {
                    Certificate tmpCert = keyStore.getCertificate(alia);
                    continue;
                }
                if (!keyStore.isKeyEntry(alia)) continue;
                Key javakey = keyStore.getKey(alia, pwd.toCharArray());
                JKey jPriKey = new JKey("RSA_Private", javakey.getEncoded());
                JCrypto jcrypto = JCrypto.getInstance();
                jcrypto.initialize("JSOFT_LIB", null);
                Session session = jcrypto.openSession("JSOFT_LIB");
                byte[] priKeyData = jPriKey.getKey();
                PKCS8 p8 = new PKCS8(session);
                byte[] encryptedKey = p8.generateEPKI(jPriKey, "11111111".toCharArray());
                JKey decryptedPriKey = p8.decodeEPKI(encryptedKey, "11111111".toCharArray());
                System.out.println("1111111111");
                System.out.println(new String(Base64.encode((byte[])decryptedPriKey.getKey())));
                byte[] base64 = new String(Base64.encode((byte[])decryptedPriKey.getKey())).getBytes();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int i = 0;
                while (i < base64.length) {
                    if (i != 0 && i % 64 == 0) {
                        bos.write("\r\n".getBytes());
                    }
                    bos.write(base64[i]);
                    ++i;
                }
                base64 = bos.toByteArray();
                System.out.println(new String(base64));
                X509Cert cert = JKSToKey.javaCert2Cert(keyStore.getCertificateChain(alia)[0]);
                base64 = new String(Base64.encode((byte[])cert.getEncoded())).getBytes();
                bos = new ByteArrayOutputStream();
                int i2 = 0;
                while (i2 < base64.length) {
                    if (i2 != 0 && i2 % 64 == 0) {
                        bos.write("\r\n".getBytes());
                    }
                    bos.write(base64[i2]);
                    ++i2;
                }
                base64 = bos.toByteArray();
                System.out.println(new String(base64));
                JKey jPubKey = JKSToKey.javaCert2Cert(keyStore.getCertificateChain(alia)[0]).getPublicKey();
                System.out.println(new String(Base64.encode((byte[])jPubKey.getKey())));
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private static X509Cert javaCert2Cert(Certificate javaCert) throws Exception {
        if (javaCert == null) {
            return null;
        }
        X509Cert ret = null;
        try {
            ret = new X509Cert(javaCert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw e;
        }
        catch (PKIException e) {
            throw e;
        }
        return ret;
    }

    public void doit(String filePath, String pwd) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        String fileName = filePath;
        char[] passPhrase = pwd.toCharArray();
        BASE64Encoder myB64 = new BASE64Encoder();
        File certificateFile = new File(fileName);
        ks.load(new FileInputStream(certificateFile), passPhrase);
        KeyPair kp = this.getPrivateKey(ks, "cn=192.168.120.108", passPhrase);
        PrivateKey privKey = kp.getPrivate();
        String b64 = myB64.encode(privKey.getEncoded());
        System.out.println("-----BEGIN PRIVATE KEY-----");
        System.out.println(b64);
        System.out.println("-----END PRIVATE KEY-----");
    }

    public KeyPair getPrivateKey(KeyStore keystore, String alias, char[] password) {
        try {
            Key key = keystore.getKey(alias, password);
            if (key instanceof PrivateKey) {
                Certificate cert = keystore.getCertificate(alias);
                PublicKey publicKey = cert.getPublicKey();
                return new KeyPair(publicKey, (PrivateKey)key);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            IvParameterSpec iv;
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            SignatureUtil signUtil = new SignatureUtil();
            byte[] sourceData = null;
            FileInputStream fis = new FileInputStream("c:/src.txt");
            sourceData = new byte[fis.available()];
            fis.read(sourceData);
            fis.close();
            byte[] sign = null;
            fis = new FileInputStream("c:/sign.txt");
            sign = new byte[fis.available()];
            fis.read(sign);
            fis.close();
            boolean veric = signUtil.p7VerifySignMessageDetached(sourceData, sign, session);
            System.out.println(veric);
            byte[] IV_8 = new byte[]{50, 51, 52, 53, 54, 55, 56, 57};
            byte[] IV_16 = new byte[]{50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65};
            int bufferSize = 0x100000;
            String srcFile = "F:/100K.doc";
            String encFile = "F:\\test\\100K.doc.enc";
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update("11111111".getBytes());
            DESedeKeySpec dks = new DESedeKeySpec(md.digest());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey key = keyFactory.generateSecret(dks);
            IvParameterSpec paramSpec = iv = new IvParameterSpec(IV_8);
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding", "BC");
            cipher.init(2, (Key)key, paramSpec);
            byte[] buffer = new byte[bufferSize];
            FileOutputStream fos = new FileOutputStream(srcFile);
            BufferedOutputStream bufferOS = new BufferedOutputStream(fos, bufferSize);
            CipherInputStream cipherInputStream = new CipherInputStream(new FileInputStream(encFile), cipher);
            BufferedInputStream bufferIS = new BufferedInputStream(cipherInputStream, bufferSize);
            int len = 0;
            while ((len = bufferIS.read(buffer)) > 0) {
                bufferOS.write(buffer, 0, len);
            }
            bufferOS.close();
            bufferIS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Encrypter {
        Cipher ecipher;
        Cipher dcipher;
        private X509Certificate mUserCert;
        private PrivateKey mPrivateKey;

        Encrypter() {
            SecretKey secretKey = null;
            byte[] iv = new byte[]{-114, 18, 57, -100, 7, 114, 111, 90};
            IvParameterSpec paramSpec = new IvParameterSpec(iv);
            try {
                String password = "MichaelSiegenfeld900Mich";
                byte[] dESedePassword = password.getBytes();
                DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(dESedePassword);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede", "SunJCE");
                secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
                this.ecipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                this.dcipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                this.ecipher.init(1, (Key)secretKey, paramSpec);
                this.dcipher.init(2, (Key)secretKey, paramSpec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        Encrypter(SecretKey key) {
            byte[] iv = new byte[]{-114, 18, 57, -100, 7, 114, 111, 90};
            IvParameterSpec paramSpec = new IvParameterSpec(iv);
            try {
                this.ecipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
                this.dcipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
                this.ecipher.init(1, (Key)key, paramSpec);
                this.dcipher.init(2, (Key)key, paramSpec);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
        }
    }
}

