/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsigninterface;

import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.crypto.digests.SHA1Digest;
import cn.com.infosec.jce.PKCS7EnvelopedData;
import cn.com.infosec.jce.exception.CertificateNotMatchException;
import cn.com.infosec.jce.exception.DecryptDataException;
import cn.com.infosec.jce.exception.DecryptKeyException;
import cn.com.infosec.jce.exception.EncryptAlgException;
import cn.com.infosec.jce.exception.EncryptDataException;
import cn.com.infosec.jce.exception.EncryptKeyException;
import cn.com.infosec.jce.exception.WriteEnvDataException;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.jce.provider.JCESM2PrivateKey;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.der.util.PKCS7SignedData;
import cn.com.infosec.netsign.der.util.PKCS7SignedDataParser;
import cn.com.infosec.netsigninterface.CRLDPDEC;
import cn.com.infosec.netsigninterface.OIDUtil;
import cn.com.infosec.netsigninterface.PKCS7SignedDataUtil;
import cn.com.infosec.netsigninterface.ServerKeyStore;
import cn.com.infosec.netsigninterface.SignatureUtil;
import cn.com.infosec.netsigninterface.exceptions.InvalidCertificateException;
import cn.com.infosec.netsigninterface.exceptions.PKCS7ParseException;
import cn.com.infosec.netsigninterface.exceptions.RAWSignException;
import cn.com.infosec.netsigninterface.exceptions.ServerKeyStoreException;
import cn.com.infosec.netsigninterface.exceptions.VerifyPlainSignedMsgException;
import cn.com.infosec.netsigninterface.util.ConsoleLogger;
import cn.com.infosec.netsigninterface.util.GZipUtil;
import cn.com.infosec.netsigninterface.util.TrustCerts;
import cn.com.infosec.netsigninterface.util.TrustConfig;
import cn.com.infosec.util.Base64;
import com.infosec.NetSignServer;
import com.infosec.NetSignX509CRL;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;

public class NetSignImpl {
    private byte[] ContentData;
    private X509Certificate signingCert;
    private X509Certificate encCert;
    private String[] certinfo;
    private String[] enccertinfo;
    private static DERObjectIdentifier mdOID;
    private DateFormat df = null;
    private cn.com.infosec.jce.PKCS7SignedData p7sd = null;
    private PKCS7EnvelopedData p7ed = null;

    static {
        Security.addProvider((Provider)new InfosecProvider());
        mdOID = new DERObjectIdentifier("1.2.840.113549.1.9.4");
    }

    public void setDateFormat(DateFormat df) {
        this.df = df;
    }

    public byte[] hash1Base64(byte[] plaintext) throws IOException {
        return Base64.encode((byte[])NetSignImpl.sha1hash(plaintext)).getBytes();
    }

    private static byte[] sha1hash(byte[] plaintext) {
        SHA1Digest digest = new SHA1Digest();
        byte[] resbytes = new byte[digest.getDigestSize()];
        digest.update(plaintext, 0, plaintext.length);
        digest.doFinal(resbytes, 0);
        return resbytes;
    }

    private static String getOrg(String dn) {
        StringTokenizer str = new StringTokenizer(dn, ",");
        String value = null;
        while (str.hasMoreElements()) {
            String tmp = (String)str.nextElement();
            int j = tmp.indexOf("o=");
            if (j == -1 && (j = tmp.indexOf("O=")) == -1) continue;
            value = tmp.substring(j + 2, tmp.length());
            break;
        }
        return value;
    }

    private void getEncCert() {
        this.enccertinfo = new String[5];
        this.enccertinfo[0] = this.encCert.getSubjectDN().getName();
        this.enccertinfo[1] = this.encCert.getIssuerDN().getName();
        this.enccertinfo[2] = this.df == null ? new Date(this.encCert.getNotBefore().getTime()).toString() : this.df.format(this.encCert.getNotBefore());
        this.enccertinfo[3] = this.df == null ? new Date(this.encCert.getNotAfter().getTime()).toString() : this.df.format(this.encCert.getNotAfter());
        this.enccertinfo[4] = this.encCert.getSerialNumber().toString(16).toUpperCase();
    }

    private void getSignCert() {
        this.certinfo = new String[5];
        this.certinfo[0] = this.signingCert.getSubjectDN().getName();
        this.certinfo[1] = this.signingCert.getIssuerDN().getName();
        this.certinfo[2] = this.df == null ? new Date(this.signingCert.getNotBefore().getTime()).toString() : this.df.format(this.signingCert.getNotBefore());
        this.certinfo[3] = this.df == null ? new Date(this.signingCert.getNotAfter().getTime()).toString() : this.df.format(this.signingCert.getNotAfter());
        this.certinfo[4] = this.signingCert.getSerialNumber().toString(16).toUpperCase();
    }

    public String getCertExtensionValue(String oid) {
        return CRLDPDEC.getExtern(this.signingCert.getExtensionValue(oid));
    }

    public String getSignCertInfo(int index) {
        return this.certinfo[index - 1];
    }

    public String getEncCertInfo(int index) {
        return this.enccertinfo[index - 1];
    }

    public byte[] getContentData() {
        return this.ContentData;
    }

    public static String getVersion() {
        return "NetSignAPI(JAVA) v1.8.100.1 Build201309121600";
    }

    public X509Certificate getSignCertEntity() {
        return this.signingCert;
    }

    public byte[] GenerateSingleSignedMsg(byte[] PlainText, ServerKeyStore pfx, boolean DetachedMode) throws ServerKeyStoreException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, CertificateEncodingException, IOException {
        byte[] signedData = null;
        if (PlainText == null || PlainText.length == 0) {
            throw new InvalidParameterException("\u660e\u6587\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PrivateKey priKey = pfx.getPrivateKey();
        String digestAlg = this.getDigestAlg(priKey);
        return PKCS7SignedDataUtil.generatePKCS7SignedData(PlainText, priKey, digestAlg, NetSignServer.sm2SignID, this.getSignCert(pfx), pfx.getCertChain(), DetachedMode);
    }

    public byte[] generateILBERSignedData(byte[] plainText, ServerKeyStore pfx, boolean detached) throws ServerKeyStoreException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, CMSException {
        CMSProcessableByteArray msg = new CMSProcessableByteArray(plainText);
        X509Certificate[] signCerts = pfx.getCertChain();
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        int i = 0;
        while (i < signCerts.length) {
            list.add(signCerts[i]);
            ++i;
        }
        try {
            JcaCertStore certs = new JcaCertStore(list);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider("INFOSEC").build(pfx.getPrivateKey());
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("INFOSEC").build()).build(sha1Signer, signCerts[0]));
            gen.addCertificates((Store)certs);
            CMSSignedData sigData = gen.generate((CMSTypedData)msg, !detached);
            byte[] bs = sigData.getEncoded();
            return bs;
        }
        catch (CertificateEncodingException e) {
            throw new CMSException("CMS encode certificate failed:" + e.toString());
        }
        catch (OperatorCreationException e) {
            throw new CMSException("CMS failed:" + e.toString());
        }
        catch (IOException e) {
            throw new SignatureException("Signature failed:" + e.toString());
        }
    }

    private X509Certificate getSignCert(ServerKeyStore pfx) throws ServerKeyStoreException {
        String dn = pfx.getCertDN();
        X509Certificate[] certs = pfx.getCertChain();
        if (certs.length == 1) {
            return certs[0];
        }
        int i = 0;
        int length = certs.length;
        while (i < length) {
            if (certs[i].getSubjectDN().getName().equals(dn)) {
                return certs[i];
            }
            ++i;
        }
        return null;
    }

    private String getDigestAlg(PrivateKey prik) {
        if (prik instanceof RSAPrivateKey) {
            RSAPrivateKey rsaKey = (RSAPrivateKey)prik;
            if (rsaKey.getModulus().toByteArray().length <= 129) {
                return NetSignServer.defaultDigestAlg_RSA1024;
            }
            return NetSignServer.defaultDigestAlg_RSA2048;
        }
        if (prik instanceof JCESM2PrivateKey) {
            return NetSignServer.defaultDigestAlg_SM2;
        }
        return NetSignServer.defaultDigestAlg_RSA1024;
    }

    private String getDigestAlg(PublicKey pubk) {
        if (pubk instanceof RSAPublicKey) {
            RSAPublicKey rsaKey = (RSAPublicKey)pubk;
            if (rsaKey.getModulus().toByteArray().length <= 129) {
                return NetSignServer.defaultDigestAlg_RSA1024;
            }
            return NetSignServer.defaultDigestAlg_RSA2048;
        }
        if (pubk instanceof JCESM2PublicKey) {
            return NetSignServer.defaultDigestAlg_SM2;
        }
        return NetSignServer.defaultDigestAlg_RSA1024;
    }

    private static boolean verify(PublicKey pk, byte[] srcdata, byte[] signeddata, String digestAlg, byte[] sm2signid) throws VerifyPlainSignedMsgException {
        try {
            return SignatureUtil.verify(srcdata, signeddata, pk, digestAlg, sm2signid);
        }
        catch (Exception ce) {
            throw new VerifyPlainSignedMsgException("Verify  Error:" + ce.getMessage());
        }
    }

    public byte[] rawSign(ServerKeyStore pfx, byte[] srcData, byte[] sm2SignID) throws RAWSignException {
        try {
            PrivateKey prik = pfx.getPrivateKey();
            String digestAlg = this.getDigestAlg(prik);
            return SignatureUtil.sign(srcData, prik, digestAlg, sm2SignID, pfx.getSignCert());
        }
        catch (Exception ex1) {
            ex1.printStackTrace(System.out);
            throw new RAWSignException("Sign Error:" + ex1.getMessage());
        }
    }

    public void VerifySinglePlainSignedMsg(byte[] plainSignedMsg, byte[] PlainText, TrustCerts Tcs, Map crls, X509Certificate signedcert, byte[] sm2SignId, byte[] sm2CertId, boolean checkCRL, boolean checkValidity) throws CRLException, InvalidCertificateException, VerifyPlainSignedMsgException {
        if (plainSignedMsg == null || plainSignedMsg.length == 0) {
            throw new InvalidParameterException("\u7b7e\u540d\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean isOK = false;
        this.signingCert = signedcert;
        this.ContentData = PlainText;
        this.getSignCert();
        if (Tcs == null) {
            throw new InvalidCertificateException("-10057");
        }
        this.verifyCert(signedcert, crls, Tcs, sm2CertId, checkCRL, checkValidity);
        isOK = NetSignImpl.verify(signedcert.getPublicKey(), PlainText, plainSignedMsg, this.getDigestAlg(signedcert.getPublicKey()), sm2SignId);
        if (!isOK) {
            throw new InvalidCertificateException("-10060");
        }
    }

    public byte[] VerifySingleSignedMsg(byte[] plainText, byte[] SignedMsg, TrustCerts Tcs, Map crls, byte[] sm2signid, byte[] sm2certid, boolean verifyCRL, boolean checkValidity) throws CRLException, CertificateException, InvalidCertificateException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, PKCS7ParseException {
        if (SignedMsg == null || SignedMsg.length == 0) {
            throw new InvalidParameterException("\u7b7e\u540d\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean isOK = false;
        PKCS7SignedData p7sd = null;
        try {
            p7sd = PKCS7SignedDataParser.parse((byte[])SignedMsg, (String)"INFOSEC");
        }
        catch (CertificateException ex) {
            throw ex;
        }
        catch (NoSuchProviderException ex) {
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new PKCS7ParseException(e.toString());
        }
        this.signingCert = p7sd.getSignCert();
        this.getSignCert();
        if (Tcs == null) {
            throw new InvalidCertificateException("-10057");
        }
        this.verifyCert(this.signingCert, crls, Tcs, sm2certid, verifyCRL, checkValidity);
        String digestAlgOid = p7sd.getDigestAlgOid();
        String digestAlg = OIDUtil.getDigestAlgName(digestAlgOid);
        this.ContentData = p7sd.getContent();
        if (this.ContentData == null || this.ContentData.length == 0) {
            this.ContentData = plainText;
        }
        isOK = SignatureUtil.verify(this.ContentData, p7sd.getSignature(), this.signingCert.getPublicKey(), digestAlg, sm2signid);
        if (!isOK) {
            throw new SignatureException("\u9a8c\u7b7e\u540d\u672a\u901a\u8fc7");
        }
        return this.ContentData;
    }

    public byte[] afterwardsAttachedVerify(byte[] SignedMsg, TrustCerts Tcs) throws CRLException, CertificateException, InvalidCertificateException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException {
        if (SignedMsg == null || SignedMsg.length == 0) {
            throw new InvalidParameterException("\u7b7e\u540d\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        byte[] unziped = null;
        try {
            unziped = GZipUtil.unzip(SignedMsg);
        }
        catch (Exception e) {
            unziped = SignedMsg;
        }
        boolean isOK = false;
        try {
            this.p7sd = new cn.com.infosec.jce.PKCS7SignedData(unziped);
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (CRLException ex) {
            throw ex;
        }
        catch (InvalidKeyException ex) {
            throw ex;
        }
        catch (CertificateException ex) {
            throw ex;
        }
        catch (NoSuchProviderException ex) {
            throw ex;
        }
        catch (NoSuchAlgorithmException ex) {
            throw ex;
        }
        this.signingCert = this.p7sd.getSigningCertificate();
        this.getSignCert();
        byte[] PlainText = this.p7sd.getContentData();
        if (Tcs == null) {
            throw new InvalidCertificateException("-10057");
        }
        this.verifyCertAfterWards(this.signingCert, Tcs);
        this.p7sd.update(PlainText, 0, PlainText.length);
        isOK = this.p7sd.verify();
        if (!isOK) {
            throw new SignatureException("\u9a8c\u7b7e\u540d\u672a\u901a\u8fc7");
        }
        this.ContentData = this.p7sd.getContentData();
        return PlainText;
    }

    public byte[] MSEnvelopedandSigned(byte[] plainText, ServerKeyStore signpfx, X509Certificate enccert, int encryptAlgorithm) throws ServerKeyStoreException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, WriteEnvDataException, EncryptKeyException, EncryptDataException, EncryptAlgException, CertificateException, InvalidCertificateException, IOException {
        byte[] tmp = this.GenerateSingleSignedMsg(plainText, signpfx, false);
        return this.composeSingleEnvelopedMsg(tmp, enccert, encryptAlgorithm);
    }

    public byte[] MSDecrypedandVerify(byte[] msg, ServerKeyStore decpfx, TrustCerts tructcerts, Map crls) throws CRLException, CertificateException, InvalidCertificateException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidCertificateException, ServerKeyStoreException, DecryptKeyException, DecryptDataException, CertificateException, CertificateNotMatchException, PKCS7ParseException {
        byte[] tmp = this.decomposeSingleEnvelopedMsg(msg, decpfx);
        return this.VerifySingleSignedMsg(null, tmp, tructcerts, crls, NetSignServer.sm2SignID, NetSignServer.sm2CertID, true, true);
    }

    public String Base64Encode(byte[] input) throws IOException {
        return Base64.encode((byte[])input);
    }

    public byte[] Base64Deccode(String input) throws IOException {
        return Base64.decode((String)input);
    }

    private boolean isCertRevoked(TrustCerts tcs, X509Certificate cert, Map crls) {
        NetSignX509CRL crl = null;
        String crldp = null;
        String subject = cert.getIssuerDN().getName();
        TrustConfig t1 = (TrustConfig)tcs.getCerts().get(subject);
        String crlDir = t1.getcrldir();
        if (crlDir != null && !crlDir.equals("")) {
            String iscrlflag = t1.iscrldp();
            HashMap crltmp = (HashMap)crls.get(t1.getcrldir());
            boolean bRevoked = false;
            if (iscrlflag.equals("0")) {
                try {
                    crldp = CRLDPDEC.getcrldp(cert.getExtensionValue(X509Extensions.CRLDistributionPoints.getId()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (crldp == null) {
                    return this.verifyallcrls(cert, crltmp);
                }
                NetSignServer.lastCRLPortal = String.valueOf(crldp) + ".crl";
                crl = (NetSignX509CRL)crltmp.get(String.valueOf(crldp) + ".crl");
                if (crl == null) {
                    return false;
                }
                if (crl.isRevoked(cert)) {
                    bRevoked = true;
                }
            } else {
                return this.verifyallcrls(cert, crltmp);
            }
            return bRevoked;
        }
        return false;
    }

    private boolean isCertRevokedforyongyou(TrustConfig t1, X509Certificate cert, Map crls) {
        NetSignX509CRL crl = null;
        String crldp = null;
        String crlDir = t1.getcrldir();
        if (crlDir != null && !crlDir.equals("")) {
            String iscrlflag = t1.iscrldp();
            HashMap crltmp = (HashMap)crls.get(crlDir);
            boolean bRevoked = false;
            if (iscrlflag.equals("0")) {
                try {
                    crldp = CRLDPDEC.getcrldp(cert.getExtensionValue(X509Extensions.CRLDistributionPoints.getId()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (crldp == null) {
                    return this.verifyallcrls(cert, crltmp);
                }
                NetSignServer.lastCRLPortal = String.valueOf(crldp) + ".crl";
                crl = (NetSignX509CRL)crltmp.get(String.valueOf(crldp) + ".crl");
                if (crl == null) {
                    return false;
                }
                if (crl.isRevoked(cert)) {
                    bRevoked = true;
                }
            } else {
                return this.verifyallcrls(cert, crltmp);
            }
            return bRevoked;
        }
        return false;
    }

    private boolean verifyallcrls(X509Certificate cert, HashMap crls) {
        boolean bRevoked = false;
        Collection crlEm = crls.values();
        Object[] aa = crlEm.toArray();
        NetSignX509CRL crl = null;
        NetSignServer.lastCRLPortal = null;
        int i = 0;
        while (i < aa.length) {
            crl = (NetSignX509CRL)aa[i];
            if (crl.isRevoked(cert)) {
                bRevoked = true;
                break;
            }
            ++i;
        }
        return bRevoked;
    }

    private BigInteger getIssuerKid(X509Certificate cert) {
        byte[] issuerkid = cert.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
        if (issuerkid == null || issuerkid.length == 0) {
            return BigInteger.ZERO;
        }
        byte[] tmp = new byte[issuerkid.length - 6];
        System.arraycopy(issuerkid, 6, tmp, 0, tmp.length);
        return new BigInteger(tmp);
    }

    private void verifyCertAfterWards(X509Certificate cert, TrustCerts tcs) throws InvalidCertificateException {
        String subject = cert.getIssuerDN().toString();
        BigInteger kidbi = this.getIssuerKid(cert);
        String issuerDNAndIssuerKid = kidbi.equals(BigInteger.ZERO) ? subject : String.valueOf(subject) + ":subjectkid=" + kidbi.toString();
        TrustConfig[] t1 = tcs.getCerts().getTrustConfig(issuerDNAndIssuerKid);
        if (t1 == null) {
            StringTokenizer strtok = new StringTokenizer(subject, ",");
            String[] items = new String[strtok.countTokens()];
            int istr = 0;
            while (strtok.hasMoreElements()) {
                items[istr] = strtok.nextToken();
                ++istr;
            }
            StringBuffer sBuffer = new StringBuffer();
            int i = items.length - 1;
            while (i > 0) {
                sBuffer.append(items[i].trim());
                sBuffer.append(",");
                --i;
            }
            sBuffer.append(items[0]);
            subject = sBuffer.toString();
            issuerDNAndIssuerKid = kidbi.equals(BigInteger.ZERO) ? subject : String.valueOf(subject) + ":subjectkid=" + kidbi.toString();
            t1 = tcs.getCerts().getTrustConfig(issuerDNAndIssuerKid);
            if (t1 == null) {
                strtok = new StringTokenizer(subject, ",");
                items = new String[strtok.countTokens()];
                istr = 0;
                while (strtok.hasMoreElements()) {
                    items[istr] = strtok.nextToken();
                    ++istr;
                }
                sBuffer = new StringBuffer();
                i = items.length - 1;
                while (i > 0) {
                    sBuffer.append(items[i]);
                    sBuffer.append(",");
                    --i;
                }
                sBuffer.append(items[0]);
                subject = sBuffer.toString();
                issuerDNAndIssuerKid = kidbi.equals(BigInteger.ZERO) ? subject : String.valueOf(subject) + ":subjectkid=" + kidbi.toString();
                t1 = tcs.getCerts().getTrustConfig(issuerDNAndIssuerKid);
            }
        }
        if (t1 == null || t1.length == 0) {
            throw new InvalidCertificateException("-10054");
        }
        int error = 0;
        if (error == 0) {
            Exception e = null;
            int i = 0;
            int length = t1.length;
            while (i < length) {
                block14: {
                    error = 0;
                    PublicKey publicKey = t1[i].getrootcert().getPublicKey();
                    if (publicKey != null) {
                        try {
                            cert.verify(publicKey);
                        }
                        catch (Exception ex) {
                            e = ex;
                            error = -10055;
                            break block14;
                        }
                        if (error == 0) break;
                    }
                }
                ++i;
            }
            if (error == -10055 && e != null) {
                ConsoleLogger.logException(e);
            }
        }
        if (error != 0) {
            throw new InvalidCertificateException(String.valueOf(error));
        }
    }

    private void verifyCert(X509Certificate cert, Map crls, TrustCerts tcs, byte[] sm2CertID, boolean checkCRL, boolean checkValidity) throws InvalidCertificateException {
        String subject = cert.getIssuerDN().toString();
        BigInteger kidbi = this.getIssuerKid(cert);
        String issuerDNAndIssuerKid = kidbi.equals(BigInteger.ZERO) ? subject : String.valueOf(subject) + ":subjectkid=" + kidbi.toString();
        TrustConfig[] t1 = tcs.getCerts().getTrustConfig(issuerDNAndIssuerKid);
        if (t1 == null) {
            StringTokenizer strtok = new StringTokenizer(subject, ",");
            String[] items = new String[strtok.countTokens()];
            int istr = 0;
            while (strtok.hasMoreElements()) {
                items[istr] = strtok.nextToken();
                ++istr;
            }
            StringBuffer sBuffer = new StringBuffer();
            int i = items.length - 1;
            while (i > 0) {
                sBuffer.append(items[i].trim());
                sBuffer.append(",");
                --i;
            }
            sBuffer.append(items[0]);
            subject = sBuffer.toString();
            issuerDNAndIssuerKid = kidbi.equals(BigInteger.ZERO) ? subject : String.valueOf(subject) + ":subjectkid=" + kidbi.toString();
            t1 = tcs.getCerts().getTrustConfig(issuerDNAndIssuerKid);
            if (t1 == null) {
                strtok = new StringTokenizer(subject, ",");
                items = new String[strtok.countTokens()];
                istr = 0;
                while (strtok.hasMoreElements()) {
                    items[istr] = strtok.nextToken();
                    ++istr;
                }
                sBuffer = new StringBuffer();
                i = items.length - 1;
                while (i > 0) {
                    sBuffer.append(items[i]);
                    sBuffer.append(",");
                    --i;
                }
                sBuffer.append(items[0]);
                subject = sBuffer.toString();
                issuerDNAndIssuerKid = kidbi.equals(BigInteger.ZERO) ? subject : String.valueOf(subject) + ":subjectkid=" + kidbi.toString();
                t1 = tcs.getCerts().getTrustConfig(issuerDNAndIssuerKid);
            }
        }
        if (t1 == null || t1.length == 0) {
            throw new InvalidCertificateException("-10054");
        }
        int error = 0;
        if (checkValidity) {
            try {
                cert.checkValidity();
            }
            catch (Exception ex) {
                ConsoleLogger.logException(ex);
                error = -10055;
            }
        }
        if (error == 0) {
            Exception e = null;
            int i = 0;
            int length = t1.length;
            while (i < length) {
                block19: {
                    error = 0;
                    if (crls != null && checkCRL && this.isCertRevokedforyongyou(t1[i], cert, crls)) {
                        error = -10056;
                        break;
                    }
                    PublicKey publicKey = t1[i].getrootcert().getPublicKey();
                    try {
                        if (publicKey instanceof JCESM2PublicKey) {
                            this.verifySM2Cert(cert, publicKey, sm2CertID);
                        } else {
                            cert.verify(publicKey);
                        }
                    }
                    catch (Exception ex) {
                        e = ex;
                        error = -10055;
                        break block19;
                    }
                    if (error == 0) break;
                }
                ++i;
            }
            if (error == -10055 && e != null) {
                ConsoleLogger.logException(e);
            }
        }
        if (error != 0) {
            throw new InvalidCertificateException(String.valueOf(error));
        }
    }

    private void verifySM2Cert(X509Certificate cert, PublicKey rootKey, byte[] sm2CertID) throws SignatureException, CertificateEncodingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        byte[] signed;
        byte[] tbs = cert.getTBSCertificate();
        if (!SignatureUtil.verify(tbs, signed = cert.getSignature(), rootKey, "SM3", sm2CertID)) {
            throw new SignatureException("Certificate verify failed.");
        }
    }

    public byte[] composeSingleEnvelopedMsg(byte[] PlainText, X509Certificate enccert, int encryptAlgorithm) throws InvalidCertificateException, NoSuchProviderException, CertificateException, EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException {
        PKCS7EnvelopedData p7Env = new PKCS7EnvelopedData();
        if (enccert == null) {
            throw new InvalidCertificateException("\u8bc1\u4e66\u9519\u8bef");
        }
        byte[] envdata = p7Env.encrypt(PlainText, (Certificate)enccert, encryptAlgorithm);
        return envdata;
    }

    public byte[] decomposeSingleEnvelopedMsg(byte[] EnvelopedMsg, ServerKeyStore decpfx) throws CertificateException, InvalidCertificateException, InvalidKeyException, CertificateNotMatchException, DecryptKeyException, DecryptDataException, CRLException, ServerKeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        X509Certificate cert;
        if (EnvelopedMsg == null || EnvelopedMsg.length == 0) {
            throw new InvalidParameterException("\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u4e3a\u7a7a");
        }
        this.encCert = cert = decpfx.getCertChain()[0];
        this.getEncCert();
        PrivateKey priKey = decpfx.getPrivateKey();
        this.p7ed = new PKCS7EnvelopedData();
        byte[] decryData = null;
        try {
            decryData = this.p7ed.decrypt(EnvelopedMsg, (Certificate)cert, priKey);
        }
        catch (Exception e) {
            throw new DecryptDataException("Can not decrypt:" + e.toString());
        }
        this.ContentData = decryData;
        return decryData;
    }

    public void verifyILBERAttachedSignature(byte[] SignedMsg, TrustCerts Tcs, Map crls) throws CMSException, NoSuchAlgorithmException, IOException, SignatureException, NoSuchProviderException, InvalidCertificateException, CertificateException {
        CMSSignedData cmsP7 = new CMSSignedData(SignedMsg);
        CMSProcessableByteArray pba = (CMSProcessableByteArray)cmsP7.getSignedContent();
        if (pba == null) {
            throw new CMSException("No plaintext in the PKCS#7 signeddata");
        }
        this.ContentData = (byte[])pba.getContent();
        ConsoleLogger.logBinary("conetent", this.ContentData);
        SignerInformationStore sis = cmsP7.getSignerInfos();
        SignerInformation[] siArray = sis.getSigners().toArray(new SignerInformation[0]);
        if (siArray.length == 0) {
            throw new CMSException("No signerinfo in the PKCS#7 signeddata");
        }
        SignerInformation si = sis.getSigners().toArray(new SignerInformation[0])[0];
        byte[] esa = si.getEncodedSignedAttributes();
        ConsoleLogger.logBinary("Encoded Signed Attributes", esa);
        byte[] signed = si.getSignature();
        if ((0xFF & signed[0]) > 121) {
            byte[] tmp = new byte[signed.length + 1];
            System.arraycopy(signed, 0, tmp, 1, signed.length);
            signed = tmp;
        }
        ConsoleLogger.logBinary("signed", signed);
        SignerId sid = si.getSID();
        byte[] signCertIssuer = sid.getIssuerAsBytes();
        BigInteger signCertSN = sid.getSerialNumber();
        CollectionStore cstore = (CollectionStore)cmsP7.getCertificates();
        ArrayList certList = (ArrayList)cstore.getMatches(null);
        ConsoleLogger.logString("size of cert list:" + certList.size());
        if (certList == null || certList.size() == 0) {
            throw new CMSException("Size of certificates in the PKCS#7 signeddata is zero");
        }
        X509CertificateHolder certHolder = null;
        if (certList.size() == 1) {
            certHolder = (X509CertificateHolder)certList.get(0);
        } else {
            int i = 0;
            int size = certList.size();
            while (i < size) {
                X509CertificateHolder tmp = (X509CertificateHolder)certList.get(i);
                if (Arrays.equals(tmp.getIssuer().getEncoded(), signCertIssuer) && tmp.getSerialNumber().equals(signCertSN)) {
                    certHolder = tmp;
                    break;
                }
                ++i;
            }
        }
        if (certHolder == null) {
            throw new CMSException("No certificate whose IssuerAndSerailNumber is:" + sid.getIssuerAsString() + sid.getSerialNumber().toString(16));
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
            byte[] bscert = certHolder.getEncoded();
            this.signingCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bscert));
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            throw new CertificateException("Decode signingcert failed");
        }
        this.getSignCert();
        if (Tcs == null) {
            throw new InvalidCertificateException("-10057");
        }
        this.verifyCert(this.signingCert, crls, Tcs, null, true, true);
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] digest = null;
        digest = md.digest(this.ContentData);
        ConsoleLogger.logBinary("Content digest", digest);
        if (esa != null && esa.length > 0) {
            AttributeTable attrs = si.getSignedAttributes();
            Attribute attr = attrs.get(mdOID);
            byte[] contentDigest = attr.getEncoded();
            ConsoleLogger.logBinary("Content digest in p7", contentDigest);
            int i = 0;
            while (i < 20) {
                if (digest[19 - i] != contentDigest[contentDigest.length - 1 - i]) {
                    throw new SignatureException("Digest of the content verify failed");
                }
                ++i;
            }
            digest = md.digest(esa);
            ConsoleLogger.logBinary("Digest data of Signed Attributes", digest);
        }
        byte[] decode = null;
        try {
            SubjectPublicKeyInfo ski = certHolder.getSubjectPublicKeyInfo();
            RSAPublicKeyStructure pks = RSAPublicKeyStructure.getInstance((Object)ski.getPublicKey());
            BigInteger exponent = pks.getPublicExponent();
            BigInteger modulues = pks.getModulus();
            BigInteger signedInteger = new BigInteger(signed);
            decode = signedInteger.modPow(exponent, modulues).toByteArray();
        }
        catch (Throwable e) {
            ConsoleLogger.logException(e);
            throw new SignatureException(e.toString());
        }
        ConsoleLogger.logBinary("decoded", decode);
        int i = 0;
        while (i < 20) {
            if (digest[19 - i] != decode[decode.length - 1 - i]) {
                throw new SignatureException("Verify failed");
            }
            ++i;
        }
    }
}

