/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsigninterface.util;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsigninterface.ServerKeyStore;
import cn.com.infosec.netsigninterface.exceptions.ServerKeyStoreException;
import cn.com.infosec.netsigninterface.util.ConsoleLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class PKCS12KeyStore
implements ServerKeyStore {
    private KeyStore store;
    private String sKeyEntry;
    private String sCertEntry;
    private X509Certificate signCert;
    private PrivateKey prik;
    private String dn;
    private X509Certificate[] certChain;

    static {
        Security.addProvider((Provider)new InfosecProvider());
    }

    public PKCS12KeyStore(InputStream is, char[] password) throws ServerKeyStoreException {
        try {
            this.store = KeyStore.getInstance("PKCS12", "INFOSEC");
            this.store.load(is, password);
            Enumeration<String> en = this.store.aliases();
            String pKeyName = null;
            String pCertName = null;
            while (en.hasMoreElements()) {
                String n = en.nextElement();
                if (this.store.isKeyEntry(n)) {
                    pKeyName = n;
                }
                if (!this.store.isCertificateEntry(n)) continue;
                pCertName = n;
            }
            if (pKeyName == null && pCertName == null) {
                throw new ServerKeyStoreException("PKCS12 Key Entry Not found");
            }
            this.sCertEntry = pCertName;
            this.sKeyEntry = pKeyName;
            this.initCertDN();
            this.initCertChain();
            this.initPrivateKey();
        }
        catch (IOException ex) {
            throw new ServerKeyStoreException(ex.getMessage());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ServerKeyStoreException(ex.getMessage());
        }
        catch (CertificateException ex) {
            throw new ServerKeyStoreException(ex.getMessage());
        }
        catch (NoSuchProviderException ex) {
            throw new ServerKeyStoreException(ex.getMessage());
        }
        catch (KeyStoreException ex) {
            throw new ServerKeyStoreException(ex.getMessage());
        }
    }

    private void initCertDN() throws ServerKeyStoreException {
        this.dn = null;
        try {
            this.signCert = (X509Certificate)this.store.getCertificate(this.sKeyEntry);
            if (this.signCert == null) {
                this.signCert = (X509Certificate)this.store.getCertificate(this.sCertEntry);
            }
        }
        catch (KeyStoreException ex) {
            throw new ServerKeyStoreException(ex.getMessage());
        }
        if (this.signCert == null) {
            throw new ServerKeyStoreException("\u5728ServerKeystore\u4e2d\u4e0d\u80fd\u627e\u5230\u8bc1\u4e66");
        }
        this.dn = this.signCert.getSubjectDN().toString();
    }

    private void initCertChain() throws ServerKeyStoreException {
        Certificate[] certs1 = null;
        try {
            certs1 = this.store.getCertificateChain(this.sKeyEntry);
            if (certs1 == null) {
                certs1 = this.store.getCertificateChain(this.sCertEntry);
            }
        }
        catch (Exception ex) {
            ConsoleLogger.logException(ex);
            throw new ServerKeyStoreException(ex.getMessage());
        }
        if (certs1 == null) {
            throw new ServerKeyStoreException("\u4e0d\u80fd\u5728ServerKeystore\u4e2d\u627e\u5230\u8bc1\u4e66\u94fe");
        }
        this.certChain = new X509Certificate[certs1.length];
        int i = 0;
        while (i < certs1.length) {
            this.certChain[i] = (X509Certificate)certs1[i];
            ++i;
        }
    }

    private void initPrivateKey() throws ServerKeyStoreException {
        try {
            this.prik = (PrivateKey)this.store.getKey(this.sKeyEntry, "".toCharArray());
            if (this.prik == null) {
                throw new ServerKeyStoreException("\u4e0d\u80fd\u5728ServerKeystore\u4e2d\u627e\u5230\u79c1\u94a5");
            }
        }
        catch (UnrecoverableKeyException ex) {
            ConsoleLogger.logException(ex);
            throw new ServerKeyStoreException(ex.getMessage());
        }
        catch (NoSuchAlgorithmException ex) {
            ConsoleLogger.logException(ex);
            throw new ServerKeyStoreException(ex.getMessage());
        }
        catch (KeyStoreException ex) {
            ConsoleLogger.logException(ex);
            throw new ServerKeyStoreException(ex.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new InfosecProvider());
        KeyStore keyStore = KeyStore.getInstance("PKCS12", "INFOSEC");
        keyStore.load(new FileInputStream("c:\\shsign.pfx"), "12345678".toCharArray());
    }

    public String getCertDN() throws ServerKeyStoreException {
        return this.dn;
    }

    public X509Certificate[] getCertChain() throws ServerKeyStoreException {
        return this.certChain;
    }

    public PrivateKey getPrivateKey() throws ServerKeyStoreException {
        return this.prik;
    }

    public X509Certificate getSignCert() {
        return this.signCert;
    }
}

