/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsigninterface.util;

import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.netsigninterface.exceptions.TrustCertException;
import cn.com.infosec.netsigninterface.util.ConsoleLogger;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class TrustConfig {
    private X509Certificate rootcert;
    private String rootcertdn;
    private String iscrldp;
    private String crldir;
    private String crldownloadinterval;
    private BigInteger subjectKID;

    public void setrootcert(X509Certificate cert) throws TrustCertException {
        try {
            byte[] subkid;
            this.rootcert = cert;
            if (this.rootcert != null) {
                this.rootcertdn = this.rootcert.getSubjectDN().getName();
            }
            if ((subkid = this.getSubjectKeyId(this.rootcert)) == null || subkid.length == 0) {
                byte[] pubkey = this.getPublicKey(this.rootcert.getPublicKey());
                subkid = this.getKid(pubkey, "sha1");
            }
            this.subjectKID = new BigInteger(subkid);
        }
        catch (NoSuchProviderException ex) {
            ConsoleLogger.logException(ex);
            throw new TrustCertException("Can not found infosec provider");
        }
        catch (Exception ex) {
            ConsoleLogger.logException(ex);
            throw new TrustCertException(ex.getMessage());
        }
    }

    public void setrootcert(String _rootcertdir) throws TrustCertException {
        try {
            byte[] subkid;
            FileInputStream fis = new FileInputStream(_rootcertdir);
            CertificateFactory certFact = CertificateFactory.getInstance("X.509", "INFOSEC");
            this.rootcert = (X509Certificate)certFact.generateCertificate(fis);
            fis.close();
            if (this.rootcert != null) {
                this.rootcertdn = this.rootcert.getSubjectDN().getName();
            }
            if ((subkid = this.getSubjectKeyId(this.rootcert)) == null || subkid.length == 0) {
                byte[] pubkey = this.getPublicKey(this.rootcert.getPublicKey());
                subkid = this.getKid(pubkey, "sha1");
            }
            this.subjectKID = new BigInteger(subkid);
        }
        catch (NoSuchProviderException ex) {
            ConsoleLogger.logException(ex);
            throw new TrustCertException("Can not found infosec provider");
        }
        catch (Exception ex) {
            ConsoleLogger.logException(ex);
            throw new TrustCertException(ex.getMessage());
        }
    }

    private byte[] getSubjectKeyId(X509Certificate cert) {
        byte[] subkid = this.rootcert.getExtensionValue(X509Extensions.SubjectKeyIdentifier.getId());
        if (subkid == null || subkid.length == 0) {
            return subkid;
        }
        byte[] tmp = new byte[subkid.length - 4];
        System.arraycopy(subkid, 4, tmp, 0, tmp.length);
        return tmp;
    }

    private byte[] getKid(byte[] key, String alg) throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest d = MessageDigest.getInstance(alg, "INFOSEC");
        return d.digest(key);
    }

    private byte[] getPublicKey(PublicKey pubKey) throws IOException {
        byte[] pubkey = null;
        byte[] pubkeyinfo = pubKey.getEncoded();
        ByteArrayInputStream bIn = new ByteArrayInputStream(pubkeyinfo);
        DERInputStream dIn = new DERInputStream((InputStream)bIn);
        DERConstructedSequence derseq = null;
        derseq = (DERConstructedSequence)dIn.readObject();
        DERBitString bitpubkey = (DERBitString)derseq.getObjectAt(1);
        return bitpubkey.getBytes();
    }

    public BigInteger getSubjectKid() {
        return this.subjectKID;
    }

    public void setcrldownloadinterval(String _crldownloadinterval) {
        this.crldownloadinterval = _crldownloadinterval;
    }

    public String getcrldownloadinterval() {
        return this.crldownloadinterval;
    }

    public void setcrldir(String _crldir) {
        this.crldir = _crldir;
    }

    public void setiscrldp(String _crldp) {
        this.iscrldp = _crldp;
    }

    public X509Certificate getrootcert() {
        return this.rootcert;
    }

    public String getrootcertdn() {
        return this.rootcertdn;
    }

    public String getcrldir() {
        return this.crldir;
    }

    public String iscrldp() {
        return this.iscrldp;
    }
}

