/*
 * Decompiled with CFR 0.152.
 */
package com.infosec;

import cn.com.infosec.netsigninterface.util.ConsoleLogger;
import com.infosec.DownLoadCRLException;
import com.infosec.LogWriter;
import com.infosec.NetSignServer;
import com.infosec.ThreadManager;

public abstract class CRLDownLoader
implements Runnable {
    protected String _crldirpath = null;
    protected int _interval = 0;

    protected abstract void getCRLs() throws DownLoadCRLException;

    protected abstract String getCRLPath();

    public void run() {
        String _crlErrorLogFile = NetSignServer.logFile;
        while (!ThreadManager.isThreadsToBeStop()) {
            try {
                this.getCRLs();
                NetSignServer.updatCRLs(this._crldirpath);
                Thread.sleep(this._interval);
            }
            catch (DownLoadCRLException e) {
                LogWriter.write(_crlErrorLogFile, e.getMessage());
                break;
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
                LogWriter.write(_crlErrorLogFile, e.getMessage());
                break;
            }
            if (this._interval > 0) continue;
        }
        LogWriter.write(_crlErrorLogFile, "CRL\u4e0b\u8f7d\u7ebf\u7a0b\u6ca1\u6709\u542f\u52a8");
    }
}

