/*
 * Decompiled with CFR 0.152.
 */
package com.infosec;

import cn.com.infosec.jce.exception.CertificateNotMatchException;
import cn.com.infosec.jce.exception.DecryptDataException;
import cn.com.infosec.jce.exception.DecryptKeyException;
import cn.com.infosec.jce.exception.EncryptAlgException;
import cn.com.infosec.jce.exception.EncryptDataException;
import cn.com.infosec.jce.exception.EncryptKeyException;
import cn.com.infosec.jce.exception.WriteEnvDataException;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsigninterface.NetSignImpl;
import cn.com.infosec.netsigninterface.ServerKeyStore;
import cn.com.infosec.netsigninterface.ServerKeyStoreFactory;
import cn.com.infosec.netsigninterface.exceptions.InvalidCertificateException;
import cn.com.infosec.netsigninterface.exceptions.PKCS7ParseException;
import cn.com.infosec.netsigninterface.exceptions.RAWSignException;
import cn.com.infosec.netsigninterface.exceptions.ServerKeyStoreException;
import cn.com.infosec.netsigninterface.exceptions.TrustCertException;
import cn.com.infosec.netsigninterface.exceptions.VerifyPlainSignedMsgException;
import cn.com.infosec.netsigninterface.util.ConsoleLogger;
import cn.com.infosec.netsigninterface.util.TrustCerts;
import cn.com.infosec.netsigninterface.util.TrustConfig;
import cn.com.infosec.util.Base64;
import com.infosec.CRLDownLoader;
import com.infosec.CRLDownLoaderFactory;
import com.infosec.EncCerts;
import com.infosec.LogWriter;
import com.infosec.NetSignX509CRL;
import com.infosec.ThreadManager;
import com.infosec.TrustConfigTable;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import org.bouncycastle.cms.CMSException;

public class NetSignServer {
    byte[] AttachedSignContent;
    private static Hashtable ServkeyStoreTable = new Hashtable();
    private static Hashtable encCertTable;
    private static TrustConfigTable Trustconfgtable;
    private static TrustCerts trustCerts;
    private static HashMap CRLTables;
    private static final String crlsAndCertStoreProperties = "netsign";
    public static String logFile;
    public static byte[] sm2SignID;
    public static byte[] sm2CertID;
    public static String defaultDigestAlg_RSA1024;
    public static String defaultDigestAlg_RSA2048;
    public static String defaultDigestAlg_SM2;
    public static boolean withCertChain;
    public static int encryptAlgorithm;
    private NetSignImpl netsignapi = new NetSignImpl();
    public static final int index_CertSubject = 1;
    public static final int index_CertISSUser = 2;
    public static final int index_CertValidTime_start = 3;
    public static final int index_CertValidTime_end = 4;
    public static final int index_CertSerialnumber = 5;
    public static final int ER_ITEMDATA_ERROR = -10026;
    public static final int ER_FILEDATA_ERROR = -10025;
    public static final int ER_DATA_MISSED = -10006;
    public static final int ER_PARSEDATA_ERROR = -10024;
    public static final int ER_OUTOFLENTH_ERROR = -10027;
    public static final int ER_CERT_SIGNATURE_ERROR = -10010;
    public static final int ER_NOTFOUNDSIGNCERT_ERROR = -10028;
    public static final int ER_VeryAttached_ERROR = -10029;
    public static final int ER_VeryDetached_ERROR = -10030;
    public static final int ER_NOTFOUNDEnCCERT_ERROR = -10031;
    public static final int ER_Enveloped_ERROR = -10032;
    public static final int ER_EnvelopedDecryped_ERROR = -10033;
    public static final int ER_SIGNEANDENCRYPETDENVELOP_ERROR = -10034;
    public static final int ER_SIGNEANDDECRYPTEDENVELOP_ERROR = -10035;
    public static final int ER_CERT_INVALID = -10039;
    public static final int ER_CRL_ERROR = -10038;
    public static final int ER_CERTEXCEPTION = -10040;
    public static final int ER_InvalidCertificateException = -10041;
    public static final int ER_InvalidKeyException = -10042;
    public static final int ER_NoSuchAlgorithmException = -10043;
    public static final int ER_NoSuchProviderException = -10044;
    public static final int ER_SignatureException = -10045;
    public static final int ER_ServerKeyStoreException = -10047;
    public static final int ER_DecryptKeyException = -10048;
    public static final int ER_WriteEnvDataException = -10049;
    public static final int ER_EncryptKeyException = -10050;
    public static final int ER_EncryptDataException = -10051;
    public static final int ER_EncryptAlgException = -10052;
    public static final int ER_DecryptDataException = -10053;
    public static final int ER_ENCODEBASE64_ERROR = -10046;
    public static final int ER_NOINROOTCERTLIST_ERROR = -10054;
    public static final int ER_TIMEOUTANDNOTTRUST_ERROR = -10055;
    public static final int ER_ISREVOKED_ERROR = -10056;
    public static final int ER_NOROOTCERT_ERROR = -10057;
    public static final int ER_VerifyNukedSignMsg = -10060;
    public static final int ER_Decrypt_verifyNukedSignMsg = -10061;
    public static final int ER_RAWSIGN_NO_DATA = -10062;
    public static final int ER_RAWSIGN_ERROR = -10063;
    public static final int ER_BASE64_ENCODE = -10064;
    public static final int ER_PARSE_P7_FAILED = -10065;
    public static final int ER_OTHER_EXCEPTION = -10001;
    private byte[] m_formContents = null;
    private byte[] m_nameOfFiles = null;
    private byte[] plainText = null;
    private int totalFormLen;
    private int totalFileLen;
    private int formCounter;
    private int fileCounter;
    private Hashtable fileItems;
    private byte[][] formItems;
    private int errorNum = 0;
    private static boolean isAPIPropertySetted;
    public static String lastCRLPortal;
    private static boolean crlLoadReady;
    private static boolean firstCRLLoadReady;
    public static long debugInterval;
    public static boolean isDebug;
    private static String debugValue;

    static {
        Trustconfgtable = new TrustConfigTable();
        trustCerts = new TrustCerts();
        CRLTables = new HashMap();
        sm2SignID = null;
        sm2CertID = null;
        defaultDigestAlg_RSA1024 = "SHA1";
        defaultDigestAlg_RSA2048 = "SHA256";
        defaultDigestAlg_SM2 = "SM3";
        withCertChain = true;
        encryptAlgorithm = 4;
        isAPIPropertySetted = false;
        lastCRLPortal = null;
        crlLoadReady = false;
        firstCRLLoadReady = false;
        debugInterval = 60000L;
        isDebug = true;
        debugValue = "not null";
        Security.addProvider((Provider)new InfosecProvider());
        Runnable debugt = new Runnable(){

            public void run() {
                while (true) {
                    Date now = new Date();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    sdf.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                    System.out.println("[" + sdf.format(now) + "] NetSign1.8 INFO: isAPIPropertySetted(" + isAPIPropertySetted + ") debugValue(" + debugValue + ")");
                    try {
                        debugInterval = debugInterval > 1000L ? debugInterval : 60000L;
                        Thread.sleep(debugInterval);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
    }

    private static String getprefix4file(String fn) {
        int i = fn.lastIndexOf(".");
        return fn.substring(0, i);
    }

    public static void main(String[] args) {
        if (args[0].trim().equals("1")) {
            NetSignServer.test1(args[1], args[2]);
        } else if (args[0].trim().equals("2")) {
            NetSignServer.test2(args[1]);
        }
    }

    private static void test2(String a1) {
        try {
            String dir = a1.trim();
            File[] files = new File(dir).listFiles();
            Security.addProvider((Provider)new InfosecProvider());
            CertificateFactory crlFact = null;
            crlFact = CertificateFactory.getInstance("X.509", "INFOSEC");
            HashMap<String, NetSignX509CRL> tabtmp = new HashMap<String, NetSignX509CRL>();
            int certCount = 0;
            int i = 0;
            int length = files.length;
            while (i < length) {
                FileInputStream in;
                X509CRL crl;
                if (i % 50 == 0) {
                    System.out.println("filecount:" + i);
                    System.out.println("certcount:" + certCount);
                }
                if ((crl = (X509CRL)crlFact.generateCRL(in = new FileInputStream(files[i]))) != null) {
                    NetSignX509CRL nscrl = NetSignX509CRL.getInstance(crl);
                    certCount += nscrl.size();
                    tabtmp.put(files[i].getName(), nscrl);
                    in.close();
                }
                ++i;
            }
            System.out.println("filecount:" + i);
            System.out.println("certcount:" + certCount);
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
        }
    }

    private static void test1(String a1, String a2) {
        try {
            String f_path = a1.trim();
            int count = Integer.parseInt(a2.trim());
            HashMap<String, NetSignX509CRL> tabtmp = new HashMap<String, NetSignX509CRL>();
            CertificateFactory crlFact = null;
            Security.addProvider((Provider)new InfosecProvider());
            try {
                crlFact = CertificateFactory.getInstance("X.509", "INFOSEC");
            }
            catch (Exception ex) {
                ConsoleLogger.logException(ex);
                return;
            }
            int certCount = 0;
            int i = 0;
            while (i < count) {
                if (i % 50 == 0) {
                    System.out.println("filecount:" + i);
                    System.out.println("certcount:" + certCount);
                }
                try {
                    FileInputStream fis = new FileInputStream(f_path);
                    X509CRL x509crl = (X509CRL)crlFact.generateCRL(fis);
                    if (x509crl != null) {
                        NetSignX509CRL nscrl = NetSignX509CRL.getInstance(x509crl);
                        certCount += nscrl.size();
                        tabtmp.put(String.valueOf(i), nscrl);
                        fis.close();
                    }
                }
                catch (Exception ex) {
                    ConsoleLogger.logException(ex);
                }
                ++i;
            }
            System.out.println("filecount:" + i);
            System.out.println("certcount:" + certCount);
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void updatCRLs(String CRLDIR) {
        ConsoleLogger.logString("CRL load start");
        NetSignServer.crlLoadReady = false;
        f = new File(CRLDIR);
        ftmp = f.listFiles();
        tabtmp = (HashMap)NetSignServer.CRLTables.get(CRLDIR);
        crlFact = null;
        try {
            crlFact = CertificateFactory.getInstance("X.509", "INFOSEC");
        }
        catch (Exception ex) {
            LogWriter.write(NetSignServer.logFile, "generate Certifacte Factory of CRL Failed for" + ex.getMessage());
            return;
        }
        start = System.currentTimeMillis();
        i = 0;
        while (i < ftmp.length) {
            block26: {
                block25: {
                    fis = null;
                    fis = new FileInputStream(ftmp[i]);
                    x509crl = null;
                    try {
                        x509crl = (X509CRL)crlFact.generateCRL(fis);
                    }
                    catch (Exception e) {
                        try {
                            fis.close();
                        }
                        catch (Exception var12_15) {
                            // empty catch block
                        }
                        try {
                            Thread.sleep(10L);
                            fis = new FileInputStream(ftmp[i]);
                            x509crl = (X509CRL)crlFact.generateCRL(fis);
                        }
                        catch (Exception e2) {
                            LogWriter.write(NetSignServer.logFile, "Generate Certifacte  CRL Failed for " + ftmp[i].getName() + " " + e2.getMessage());
                            ConsoleLogger.logException(e2);
                            x509crl = null;
                        }
                    }
                    if (x509crl != null) break block25;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block26;
                    }
                    catch (Exception var14_18) {}
                    break block26;
                }
                try {
                    try {
                        tabtmp.put(ftmp[i].getName().toLowerCase(), NetSignX509CRL.getInstance(x509crl));
                        NetSignServer.CRLTables.put(CRLDIR, tabtmp);
                    }
                    catch (Exception ex) {
                        LogWriter.write(NetSignServer.logFile, "generate Certifacte  CRL Failed for" + ex.getMessage());
                        try {
                            if (fis == null) ** GOTO lbl77
                            fis.close();
                        }
                        catch (Exception var14_19) {}
                    }
                }
                catch (Throwable var13_22) {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception var14_20) {
                        // empty catch block
                    }
                    throw var13_22;
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception var14_21) {
                    // empty catch block
                }
            }
            ++i;
        }
        end = System.currentTimeMillis();
        LogWriter.write(NetSignServer.logFile, "Load CRL Cost Time " + (end - start));
        NetSignServer.crlLoadReady = true;
        NetSignServer.firstCRLLoadReady = true;
        stop = System.currentTimeMillis();
        ConsoleLogger.logString("CRL load finished , cost " + (stop - start) + "ms");
    }

    public static void saveCRLTables(String file) {
        try {
            while (!crlLoadReady) {
                Thread.sleep(100L);
            }
            FileOutputStream out = new FileOutputStream(file);
            if (lastCRLPortal == null) {
                NetSignServer.saveAllCRLTables(out);
            } else {
                NetSignServer.saveCRLTable(out);
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
        }
    }

    private static void saveCRLTable(OutputStream out) {
        try {
            Set crldirs = CRLTables.keySet();
            out.write(("CRLTables count " + CRLTables.size() + " [ save time " + new Date().toString() + "]\n").getBytes());
            out.flush();
            Object[] ks = crldirs.toArray();
            int i = 0;
            int length = ks.length;
            while (i < length) {
                String crldir = (String)ks[i];
                String crltmp = lastCRLPortal;
                out.write(("The crls of " + crltmp).getBytes());
                HashMap dircrls = (HashMap)CRLTables.get(crldir);
                NetSignX509CRL nscrl = (NetSignX509CRL)dircrls.get(crltmp);
                if (nscrl != null) {
                    nscrl.write(out);
                }
                out.write("\n".getBytes());
                out.flush();
                ++i;
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
        }
    }

    private static void saveAllCRLTables(OutputStream out) {
        try {
            Set crldirs = CRLTables.keySet();
            out.write(("CRLTables count " + CRLTables.size() + " [ save time " + new Date().toString() + "]\n").getBytes());
            out.flush();
            Object[] dirs = crldirs.toArray();
            int j = 0;
            int l = dirs.length;
            while (j < l) {
                String crldir = (String)dirs[j];
                out.write(("The crls of " + crldir).getBytes());
                out.flush();
                HashMap dircrls = (HashMap)CRLTables.get(crldir);
                if (dircrls.size() > 0) {
                    out.write((" count " + dircrls.size() + "\n").getBytes());
                    Set crls = dircrls.keySet();
                    Object[] keys = crls.toArray();
                    int i = 0;
                    int length = keys.length;
                    while (i < length) {
                        String crlPortal = (String)keys[i];
                        NetSignX509CRL nscrl = (NetSignX509CRL)dircrls.get(crlPortal);
                        out.write(("\tThe ids of " + crlPortal + " count " + nscrl.size() + "\n").getBytes());
                        nscrl.write(out);
                        out.write("\n".getBytes());
                        out.flush();
                        ++i;
                    }
                } else {
                    out.write("\n".getBytes());
                }
                out.write("\n".getBytes());
                out.flush();
                ++j;
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
        }
    }

    private static synchronized void setApi(ResourceBundle p) {
        if (isAPIPropertySetted) {
            return;
        }
        try {
            System.out.println(new Date() + "NetSignServer initializer starting...");
            if (p == null) {
                p = ResourceBundle.getBundle(crlsAndCertStoreProperties);
            }
            System.out.println("Find netsign.properties file");
            logFile = new String(p.getString("logfile").trim().getBytes("ISO8859-1"));
            System.out.println("logFile : " + logFile);
            File log = new File(logFile);
            File logP = log.getParentFile();
            if (!logP.exists()) {
                logP.mkdirs();
            }
            String trustindexs = new String(p.getString("trustindexs").trim().getBytes("ISO8859-1"));
            int trusts = Integer.parseInt(trustindexs);
            System.out.println("trusts:" + trusts);
            Runnable[] crls = new CRLDownLoader[trusts];
            int trusti = 0;
            while (trusti < trusts) {
                TrustConfig t1 = new TrustConfig();
                try {
                    String crldir = new String(p.getString("crldir" + String.valueOf(trusti)).trim().getBytes("ISO8859-1"));
                    System.out.println("crldir:" + crldir);
                    String cldpflag = new String(p.getString("cldpflag" + String.valueOf(trusti)).trim().getBytes("ISO8859-1"));
                    System.out.println("cldpflag:" + cldpflag);
                    String crldownloadinterval = new String(p.getString("crldownloadinterval" + String.valueOf(trusti)).getBytes("ISO8859-1"));
                    System.out.println("crldownloadinterval:" + crldownloadinterval);
                    t1.setcrldir(crldir);
                    t1.setiscrldp(cldpflag);
                    crls[trusti] = CRLDownLoaderFactory.generateFileCRL(crldir, Integer.parseInt(crldownloadinterval));
                    t1.setcrldownloadinterval(crldownloadinterval);
                    CRLTables.put(crldir, new HashMap());
                }
                catch (Exception e) {
                    System.out.println("No CRL configed in trust config:" + trusti);
                }
                System.out.println("set root cert");
                String trustb64 = null;
                try {
                    trustb64 = p.getString("trustencoded" + trusti).trim();
                }
                catch (Exception cldpflag) {
                    // empty catch block
                }
                if (trustb64 != null && !trustb64.equals("")) {
                    byte[] bs = Base64.decode((String)trustb64);
                    ByteArrayInputStream in = new ByteArrayInputStream(bs);
                    try {
                        CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
                        t1.setrootcert(cert);
                        System.out.println("set root cert ok");
                    }
                    catch (Exception e) {
                        throw new TrustCertException("Generate root cert with base64 encoded string failed");
                    }
                } else {
                    String truststore = new String(p.getString("truststore" + String.valueOf(trusti)).trim().getBytes("ISO8859-1"));
                    System.out.println("truststore:" + truststore);
                    t1.setrootcert(truststore);
                    System.out.println("set root cert ok");
                }
                String trustkey = String.valueOf(t1.getrootcertdn()) + ":subjectkid=" + t1.getSubjectKid().toString();
                Trustconfgtable.put(trustkey, t1);
                System.out.println("Key of trustconfgtable:" + trustkey);
                ++trusti;
            }
            trustCerts.setTrustCertConfig(Trustconfgtable);
            ThreadManager.startCRLDownload(crls);
            int pfxindexs = Integer.parseInt(p.getString("pfxindexs"));
            if (pfxindexs > 0) {
                String pfxdirpath = String.valueOf(new String(p.getString("pfxdirpath").trim().getBytes("ISO8859-1"))) + "/";
                System.out.println("pfxdirpath:" + pfxdirpath);
                ServerKeyStore[] keystores = new ServerKeyStore[pfxindexs];
                FileInputStream fpfx = null;
                int j = 0;
                while (j < pfxindexs) {
                    ServerKeyStore pfxstore;
                    fpfx = new FileInputStream(String.valueOf(pfxdirpath) + new String(p.getString("pfx" + String.valueOf(j)).trim().getBytes("ISO8859-1")));
                    System.out.println("pfx dir=" + pfxdirpath + new String(p.getString("pfx" + String.valueOf(j)).trim().getBytes("ISO8859-1")));
                    String pwdpfx = p.getString("passwordpfx" + String.valueOf(j)).trim();
                    keystores[j] = pfxstore = ServerKeyStoreFactory.generatePKCS12ServerKeyStore(fpfx, pwdpfx.toCharArray());
                    System.out.println("pfx cert DN:" + pfxstore.getCertDN());
                    fpfx.close();
                    ServkeyStoreTable.put(keystores[j].getCertDN().toLowerCase(), keystores[j]);
                    ++j;
                }
            }
            System.out.println("NetSignServer initializering: Get pfx Certificate success!");
            String encCertDir = null;
            try {
                encCertDir = new String(p.getString("enccert").trim().getBytes("ISO8859-1"));
            }
            catch (Exception e) {
                System.out.println("Enccert not found in netsign.properties");
            }
            if (encCertDir != null) {
                EncCerts enccert = new EncCerts(encCertDir);
                encCertTable = enccert.getCerts();
            }
            try {
                sm2SignID = p.getString("sm2signid").trim().getBytes();
                System.out.println("SM2SignID=" + new String(sm2SignID));
            }
            catch (Exception e) {
                System.out.println("SM2SignID=null");
            }
            try {
                sm2CertID = p.getString("sm2certid").trim().getBytes();
                System.out.println("SM2CertID=" + new String(sm2CertID));
            }
            catch (Exception e) {
                System.out.println("SM2CertID=null");
            }
            try {
                defaultDigestAlg_RSA1024 = p.getString("mdalgrsa1024").trim();
                System.out.println("mdalgrsa1024=" + new String(defaultDigestAlg_RSA1024));
            }
            catch (Exception e) {
                System.out.println("mdalgrsa1024=SHA1");
            }
            try {
                defaultDigestAlg_RSA2048 = p.getString("mdalgrsa2048").trim();
                System.out.println("mdalgrsa2048=" + new String(defaultDigestAlg_RSA2048));
            }
            catch (Exception e) {
                System.out.println("mdalgrsa2048=SHA256");
            }
            try {
                defaultDigestAlg_SM2 = p.getString("mdalgsm2").trim();
                System.out.println("mdalgsm2=" + new String(defaultDigestAlg_SM2));
            }
            catch (Exception e) {
                System.out.println("mdalgsm2=SM3");
            }
            try {
                withCertChain = p.getString("withcertchain").trim().toLowerCase().equals("true");
                System.out.println("withcertchain=" + withCertChain);
            }
            catch (Exception e) {
                System.out.println("withcertchain=true");
            }
            try {
                String alg = p.getString("encryptalg").trim().toUpperCase();
                if (alg.equals("RC4")) {
                    encryptAlgorithm = 4;
                } else if (alg.equals("RC2")) {
                    encryptAlgorithm = 3;
                } else if (alg.equals("DES")) {
                    encryptAlgorithm = 2;
                } else if (alg.equals("3DES")) {
                    encryptAlgorithm = 1;
                } else if (alg.equals("AES")) {
                    encryptAlgorithm = 14;
                } else {
                    alg = "RC4";
                }
                System.out.println("encryptalg=" + alg);
            }
            catch (Exception e) {
                System.out.println("encryptalg=RC4");
            }
            System.out.println("NetSignServer initializer finished successfully!");
            LogWriter.write(logFile, "Netsign Server initializer finished successfully!");
        }
        catch (InvalidParameterException e0) {
            ConsoleLogger.logException(e0);
            LogWriter.write(logFile, "InitialParams Error! Error maybe in ServerKeystore/TrustCerts/CRLS.");
            System.out.println("NetSignServer initializer failed to start, InvalidParameterException.");
        }
        catch (FileNotFoundException e1) {
            ConsoleLogger.logException(e1);
            LogWriter.write(logFile, "Failed Initializer! Can't findout ServerKeystore.");
            System.out.println("NetSignServer initializer failed to start, cannot found Server Certificate.");
            System.out.println(e1.getMessage());
        }
        catch (ServerKeyStoreException e2) {
            ConsoleLogger.logException(e2);
            LogWriter.write(logFile, "Failed Initializer! Can't open ServerKeystore.");
            System.out.println("NetSignServer initializer failed to start,Server Certificate error.");
            System.out.println(e2.getMessage());
        }
        catch (TrustCertException tex) {
            ConsoleLogger.logException(tex);
            LogWriter.write(logFile, "Failed Initializer! Trust Cert Can not Open.");
            System.out.println("NetSignServer initializer failed to start,configuration file error.");
            System.out.println(tex.getMessage());
        }
        catch (IOException ioex) {
            ConsoleLogger.logException(ioex);
        }
        isAPIPropertySetted = true;
    }

    public NetSignServer() {
        System.out.println(NetSignServer.GetVersion());
        NetSignServer.setApi(null);
    }

    public NetSignServer(ResourceBundle res) {
        System.out.println(NetSignServer.GetVersion());
        NetSignServer.setApi(res);
    }

    public String getDefaultSignerDN() {
        Enumeration en = ServkeyStoreTable.keys();
        String defaultdn = null;
        while (en.hasMoreElements()) {
            defaultdn = (String)en.nextElement();
        }
        return defaultdn;
    }

    public String NSBase64Encode(String base64ToBeEncodedText) {
        if (base64ToBeEncodedText == null || base64ToBeEncodedText.length() == 0) {
            this.errorNum = -10006;
            return null;
        }
        this.errorNum = 0;
        String tmp = null;
        try {
            tmp = new String(this.netsignapi.Base64Encode(base64ToBeEncodedText.getBytes()));
        }
        catch (IOException ex) {
            this.errorNum = -10046;
        }
        return tmp;
    }

    public String NSBase64Encode(byte[] base64ToBeEncodedText) {
        if (base64ToBeEncodedText == null || base64ToBeEncodedText.length == 0) {
            this.errorNum = -10006;
            return null;
        }
        this.errorNum = 0;
        try {
            return Base64.encode((byte[])base64ToBeEncodedText);
        }
        catch (IOException ex) {
            this.errorNum = -10046;
            return null;
        }
    }

    public String NSBase64Decode(String base64ToBeDecodedText) {
        if (base64ToBeDecodedText == null || base64ToBeDecodedText.length() == 0) {
            this.errorNum = -10006;
            return null;
        }
        String tmp = null;
        try {
            tmp = new String(this.netsignapi.Base64Deccode(base64ToBeDecodedText));
        }
        catch (IOException ex) {
            this.errorNum = -10046;
        }
        return tmp;
    }

    public byte[] NSBase64Decode(byte[] base64ToBeDecodedText) {
        if (base64ToBeDecodedText == null || base64ToBeDecodedText.length == 0) {
            this.errorNum = -10006;
            return null;
        }
        try {
            return Base64.decode((byte[])base64ToBeDecodedText);
        }
        catch (IOException ex) {
            this.errorNum = -10046;
            return null;
        }
    }

    public String NSHashAndBase64Encode(String plainText) throws IOException {
        if (plainText == null || plainText.length() == 0) {
            this.errorNum = -10006;
            return null;
        }
        String tmp = null;
        try {
            tmp = new String(this.netsignapi.hash1Base64(plainText.getBytes()));
        }
        catch (IOException ex) {
            this.errorNum = -10046;
        }
        return tmp;
    }

    public void NSAddFormItem(String itemContent) {
        if (itemContent == null || itemContent.length() == 0) {
            this.errorNum = -10006;
            return;
        }
        String str1 = "00000000";
        int len = itemContent.length();
        if (len == 0) {
            this.errorNum = -10026;
            return;
        }
        String str2 = Integer.toString(len, 10);
        String str = this.m_formContents == null ? String.valueOf(str1.substring(0, 8 - str2.length())) + str2 + itemContent : String.valueOf(new String(this.m_formContents)) + str1.substring(0, 8 - str2.length()) + str2 + itemContent;
        this.m_formContents = str.getBytes();
    }

    public void NSAddFile(String Filename) {
        if (Filename == null || Filename.length() == 0) {
            this.errorNum = -10006;
            return;
        }
        int len = Filename.length();
        if (len == 0) {
            this.errorNum = -10025;
            return;
        }
        String str = this.m_nameOfFiles == null ? Filename : String.valueOf(new String(this.m_nameOfFiles)) + "\t" + Filename;
        this.m_nameOfFiles = str.getBytes();
    }

    public void NSSetPlainText(byte[] plaintext) {
        if (plaintext == null || plaintext.length == 0) {
            this.errorNum = -10006;
            return;
        }
        this.plainText = plaintext;
        this.errorNum = 0;
    }

    public byte[] NSGetFormItem() {
        if (this.totalFormLen == 0 || this.formCounter >= this.totalFormLen) {
            return new byte[0];
        }
        return this.formItems[this.formCounter++];
    }

    public void getTotle() {
        try {
            this.getFormFiles();
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            this.errorNum = -10024;
        }
        try {
            this.getFormItems();
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            this.errorNum = -10024;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void getFormItems() {
        block5: {
            block3: {
                block4: {
                    item = null;
                    v = new Vector<byte[]>();
                    plainContent = this.netsignapi.getContentData();
                    if (plainContent == null) break block3;
                    pos = 0;
                    formsLen = Integer.parseInt(new String(plainContent, pos, 8), 10);
                    if (formsLen != 0 && (pos += 8) <= formsLen + 7) ** GOTO lbl17
                    this.formItems = null;
                    this.errorNum = -10024;
                    break block4;
lbl-1000:
                    // 1 sources

                    {
                        iLen = Integer.parseInt(new String(plainContent, pos, 8), 10);
                        item = new byte[iLen];
                        System.arraycopy(plainContent, pos += 8, item, 0, iLen);
                        v.add(item);
                        pos += iLen;
lbl17:
                        // 2 sources

                        ** while (pos < formsLen)
                    }
                }
                size = v.size();
                this.formItems = new byte[size][];
                i = 0;
                while (i < size) {
                    this.formItems[i] = (byte[])v.get(i);
                    ++i;
                }
                v = null;
                if (this.formItems != null && this.formItems.toString().length() > 1) {
                    this.totalFormLen = this.formItems.length;
                }
                this.formCounter = 0;
                break block5;
            }
            this.errorNum = -10006;
        }
    }

    public void getFormFiles() {
        Hashtable<byte[], byte[]> items = null;
        byte[] plainContent = this.netsignapi.getContentData();
        if (plainContent != null) {
            int pos = Integer.parseInt(new String(plainContent, 0, 8), 10) + 16;
            items = new Hashtable<byte[], byte[]>();
            int fLen = 0;
            int fNameLen = 0;
            byte[] fContent = null;
            while (pos < plainContent.length) {
                fLen = Integer.parseInt(new String(plainContent, pos, 8), 10);
                fNameLen = Integer.parseInt(new String(plainContent, pos += 8, 8), 10);
                byte[] fName = new byte[fNameLen];
                System.arraycopy(plainContent, pos += 8, fName, 0, fNameLen);
                fContent = new byte[fLen - fNameLen - 8];
                System.arraycopy(plainContent, pos += fNameLen, fContent, 0, fLen - fNameLen - 8);
                pos += fLen - fNameLen - 8;
                items.put(fName, fContent);
            }
            this.fileItems = items;
            this.totalFileLen = this.fileItems.size();
            this.fileCounter = 0;
        } else {
            this.errorNum = -10006;
        }
    }

    public String getCertExtensionValue(String oid) {
        return this.netsignapi.getCertExtensionValue(oid);
    }

    public int getLastErrnum() {
        int tmp = this.errorNum;
        this.errorNum = 0;
        return tmp;
    }

    private void makePlainText() {
        int totalFormContLen = 0;
        int totalFileLen = 0;
        int totalLen = 0;
        totalFormContLen = this.m_formContents != null ? this.m_formContents.length : 0;
        String str1 = "00000000";
        String str2 = Integer.toString(totalFormContLen, 10);
        String strForm = this.m_formContents != null ? String.valueOf(str1.substring(0, 8 - str2.length())) + str2 + new String(this.m_formContents) : String.valueOf(str1.substring(0, 8 - str2.length())) + str2;
        String strFile = "";
        if (this.m_nameOfFiles != null) {
            int startIndex = 0;
            int searchedIndex = 0;
            int fileLenSubTotal = 0;
            int MAXFILELENGTH = 0x100000;
            String StrFileNameParse = String.valueOf(new String(this.m_nameOfFiles)) + "\t";
            while ((searchedIndex = StrFileNameParse.indexOf("\t", startIndex)) != -1) {
                String fileName = StrFileNameParse.substring(startIndex, searchedIndex);
                int nameLen = fileName.length();
                File f = new File(fileName);
                long fileLen = f.length();
                if (fileLen > (long)MAXFILELENGTH) {
                    System.out.println("File size should not be larger than " + Integer.toString(MAXFILELENGTH, 10));
                    this.errorNum = -10027;
                    return;
                }
                byte[] filecontent = new byte[(int)fileLen];
                try {
                    FileInputStream fis = new FileInputStream(f);
                    if ((long)fis.read(filecontent) != fileLen) {
                        System.out.println("Reading of file is incomplete");
                        this.errorNum = -10025;
                        return;
                    }
                    fis.close();
                }
                catch (FileNotFoundException exc) {
                    System.out.println("File not found");
                    this.errorNum = -10025;
                    return;
                }
                catch (IOException exc) {
                    System.out.println("File not found");
                    this.errorNum = -10025;
                    return;
                }
                str2 = Integer.toString(nameLen, 10);
                String str3 = Integer.toString((int)fileLen + nameLen + 8, 10);
                String StrFileSubTotal = String.valueOf(strFile) + str1.substring(0, 8 - str3.length()) + str3 + str1.substring(0, 8 - str2.length()) + str2 + fileName + new String(filecontent);
                fileLenSubTotal = (int)((long)fileLenSubTotal + ((long)(16 + nameLen) + fileLen));
                strFile = StrFileSubTotal;
                startIndex = searchedIndex + 1;
            }
            totalFileLen = fileLenSubTotal;
        } else {
            totalFileLen = 0;
        }
        str2 = Integer.toString(totalFileLen, 10);
        String strFinal = String.valueOf(strForm) + str1.substring(0, 8 - str2.length()) + str2 + strFile;
        totalLen = totalFormContLen + totalFileLen + 16;
        this.AttachedSignContent = strFinal.getBytes();
        this.m_formContents = null;
        this.m_nameOfFiles = null;
    }

    public String NSGetSignerCertInfo(int type) {
        if (type < 1 || type > 5) {
            return null;
        }
        return this.netsignapi.getSignCertInfo(type);
    }

    public String NSGetReciptCertInfo(int type) {
        if (type < 1 || type > 5) {
            return null;
        }
        return this.netsignapi.getEncCertInfo(type);
    }

    public byte[][] NSGetFileInfo() {
        byte[][] fileInfo = new byte[2][];
        if (this.totalFileLen == 0 || this.fileCounter >= this.totalFileLen) {
            return new byte[0][];
        }
        Enumeration tmpEnu = this.fileItems.keys();
        int k = 0;
        while (k < this.fileCounter) {
            tmpEnu.nextElement();
            ++k;
        }
        fileInfo[0] = (byte[])tmpEnu.nextElement();
        fileInfo[1] = (byte[])this.fileItems.get(fileInfo[0]);
        ++this.fileCounter;
        return fileInfo;
    }

    public byte[] NSGetPlainText() {
        return this.netsignapi.getContentData();
    }

    public byte[] NSAttachedSign(String deSignerDN) {
        byte[] tmp;
        if (deSignerDN == null || deSignerDN.length() == 0) {
            this.errorNum = -10006;
            return null;
        }
        this.errorNum = 0;
        Object obj = ServkeyStoreTable.get(deSignerDN.toLowerCase());
        if (obj == null) {
            this.errorNum = -10028;
            return null;
        }
        ServerKeyStore pfx = (ServerKeyStore)obj;
        byte[] tmp1 = null;
        if (this.plainText == null) {
            this.makePlainText();
            tmp = this.AttachedSignContent;
        } else {
            tmp = this.plainText;
        }
        if (this.errorNum != 0) {
            return null;
        }
        try {
            tmp1 = Base64.encode((byte[])this.netsignapi.GenerateSingleSignedMsg(tmp, pfx, false)).getBytes();
        }
        catch (ServerKeyStoreException expfx) {
            ConsoleLogger.logException(expfx);
            this.errorNum = -10047;
        }
        catch (InvalidKeyException exin) {
            this.errorNum = -10042;
        }
        catch (NoSuchProviderException exp) {
            this.errorNum = -10044;
        }
        catch (NoSuchAlgorithmException exa) {
            exa.printStackTrace();
            this.errorNum = -10043;
        }
        catch (SignatureException exs) {
            this.errorNum = -10045;
        }
        catch (IOException exbase) {
            this.errorNum = -10046;
        }
        catch (Exception ex) {
            ConsoleLogger.logException(ex);
            this.errorNum = -10045;
        }
        return tmp1;
    }

    public int NetSignCommonSignVerify(String msg) {
        int tmpInt = -1;
        try {
            byte[] tempB = Base64.decode((String)msg);
            this.netsignapi.VerifySingleSignedMsg(null, tempB, trustCerts, CRLTables, sm2SignID, sm2CertID, true, true);
            return 1;
        }
        catch (CertificateException e0) {
            return -14;
        }
        catch (CRLException e2) {
            return -17;
        }
        catch (InvalidCertificateException e1) {
            tmpInt = -2;
            return -2;
        }
        catch (PKCS7ParseException e) {
            return -17;
        }
        catch (Exception e1) {
            ConsoleLogger.logException(e1);
            return tmpInt;
        }
    }

    public byte[] GetCommonPlainText() {
        return this.netsignapi.getContentData();
    }

    public byte[] NSRAWSign(byte[] plainText, String subject) {
        if (subject == null || subject.length() == 0) {
            this.errorNum = -10006;
            return null;
        }
        this.errorNum = 0;
        if (plainText == null || plainText.length == 0) {
            this.errorNum = -10062;
            ConsoleLogger.logString(String.valueOf(this.errorNum) + "\nDN:" + subject);
            return null;
        }
        ServerKeyStore store = (ServerKeyStore)ServkeyStoreTable.get(subject.toLowerCase());
        if (store == null) {
            this.errorNum = -10028;
            ConsoleLogger.logString(String.valueOf(this.errorNum) + "\nDN:" + subject);
            return null;
        }
        byte[] bResult = null;
        try {
            bResult = this.netsignapi.rawSign(store, plainText, sm2SignID);
        }
        catch (RAWSignException e2) {
            this.errorNum = -10063;
            LogWriter.write(logFile, "NSRAWSign error:" + e2.getMessage());
            ConsoleLogger.logString(String.valueOf(this.errorNum) + "\nDN:" + subject);
            return null;
        }
        try {
            return Base64.encode((byte[])bResult).getBytes();
        }
        catch (IOException e) {
            this.errorNum = -10064;
            ConsoleLogger.logString(String.valueOf(this.errorNum));
            return null;
        }
    }

    public void NSVerifyPlainSignedMsg(byte[] plainText, String Base64plainsignedMsg, X509Certificate SignedCert) {
        if (Base64plainsignedMsg == null || Base64plainsignedMsg.length() == 0 || plainText == null || plainText.length == 0 || SignedCert == null) {
            this.errorNum = -10006;
            return;
        }
        this.errorNum = 0;
        try {
            this.netsignapi.VerifySinglePlainSignedMsg(Base64.decode((String)Base64plainsignedMsg), plainText, trustCerts, CRLTables, SignedCert, sm2SignID, sm2CertID, true, true);
        }
        catch (IOException ioex) {
            ConsoleLogger.logException(ioex);
        }
        catch (CRLException ex1) {
            this.errorNum = -10038;
        }
        catch (InvalidCertificateException ex2) {
            this.errorNum = Integer.parseInt(ex2.getMessage());
        }
        catch (VerifyPlainSignedMsgException ex3) {
            ConsoleLogger.logException(ex3);
            this.errorNum = -10061;
        }
    }

    private static X509Certificate getX509Cert(String certpath) throws Exception {
        X509Certificate cert = null;
        FileInputStream finput = null;
        try {
            finput = new FileInputStream(certpath);
        }
        catch (FileNotFoundException fnotex) {
            throw new Exception("VerifyCert:Can not Found RootCert " + certpath);
        }
        try {
            CertificateFactory certfactory = CertificateFactory.getInstance("X.509", "INFOSEC");
            cert = (X509Certificate)certfactory.generateCertificate(finput);
        }
        catch (Exception ex) {
            throw new Exception("VerifyCert:Can not Get Root Cert" + ex.getMessage());
        }
        return cert;
    }

    public void NSAttachedVerify(byte[] signedMsg) {
        if (signedMsg == null || signedMsg.length == 0) {
            this.errorNum = -10006;
            return;
        }
        this.errorNum = 0;
        try {
            this.netsignapi.VerifySingleSignedMsg(null, Base64.decode((byte[])signedMsg), trustCerts, CRLTables, sm2SignID, sm2CertID, true, true);
        }
        catch (CertificateException ex) {
            this.errorNum = -10040;
        }
        catch (CRLException ex1) {
            this.errorNum = -10038;
        }
        catch (InvalidCertificateException ex2) {
            this.errorNum = Integer.parseInt(ex2.getMessage());
        }
        catch (SignatureException ex) {
            this.errorNum = -10029;
        }
        catch (Throwable ex3) {
            ConsoleLogger.logException(ex3);
            this.errorNum = -10029;
        }
    }

    public byte[] NSILBERAttachedSignature(String signSubject) {
        byte[] tmp;
        if (signSubject == null || signSubject.length() == 0) {
            this.errorNum = -10006;
            return null;
        }
        ConsoleLogger.logString("SignSubject input:" + signSubject);
        this.errorNum = 0;
        Object obj = ServkeyStoreTable.get(signSubject.toLowerCase());
        if (obj == null) {
            this.errorNum = -10028;
            return null;
        }
        ServerKeyStore pfx = (ServerKeyStore)obj;
        byte[] tmp1 = null;
        if (this.plainText == null) {
            this.makePlainText();
            tmp = this.AttachedSignContent;
        } else {
            tmp = this.plainText;
        }
        ConsoleLogger.logBinary("PlainText", tmp);
        if (this.errorNum != 0) {
            return null;
        }
        try {
            tmp1 = this.netsignapi.generateILBERSignedData(tmp, pfx, false);
            ConsoleLogger.logBinary("Signed", tmp1);
        }
        catch (ServerKeyStoreException expfx) {
            ConsoleLogger.logException(expfx);
            this.errorNum = -10047;
        }
        catch (InvalidKeyException exin) {
            this.errorNum = -10042;
        }
        catch (NoSuchProviderException exp) {
            this.errorNum = -10044;
        }
        catch (NoSuchAlgorithmException exa) {
            this.errorNum = -10043;
        }
        catch (SignatureException exs) {
            this.errorNum = -10045;
        }
        catch (Exception ex) {
            ConsoleLogger.logException(ex);
            this.errorNum = -10001;
        }
        return tmp1;
    }

    public void NSVerifyILBERAttachedSignature(byte[] signedMsg) {
        if (signedMsg == null || signedMsg.length == 0) {
            this.errorNum = -10006;
            return;
        }
        this.errorNum = 0;
        try {
            this.netsignapi.verifyILBERAttachedSignature(signedMsg, trustCerts, CRLTables);
        }
        catch (CertificateException ex) {
            this.errorNum = -10040;
        }
        catch (InvalidCertificateException ex2) {
            this.errorNum = Integer.parseInt(ex2.getMessage());
        }
        catch (SignatureException ex) {
            ConsoleLogger.logException(ex);
            this.errorNum = -10029;
        }
        catch (CMSException ex) {
            ConsoleLogger.logException(ex);
            this.errorNum = -10065;
        }
        catch (Throwable ex3) {
            ConsoleLogger.logException(ex3);
            this.errorNum = -10001;
        }
    }

    public void NSAttachedAfterwardVerify(String signedMsg) {
        if (signedMsg == null || signedMsg.length() == 0) {
            this.errorNum = -10006;
            return;
        }
        this.errorNum = 0;
        try {
            this.netsignapi.VerifySingleSignedMsg(null, Base64.decode((String)signedMsg), trustCerts, CRLTables, sm2SignID, sm2CertID, false, false);
        }
        catch (CertificateException ex) {
            this.errorNum = -10040;
        }
        catch (CRLException ex1) {
            this.errorNum = -10038;
        }
        catch (InvalidCertificateException ex2) {
            this.errorNum = Integer.parseInt(ex2.getMessage());
        }
        catch (SignatureException ex) {
            this.errorNum = -10029;
        }
        catch (Throwable ex3) {
            ConsoleLogger.logException(ex3);
            this.errorNum = -10029;
        }
    }

    public X509Certificate NSGetSignCert() {
        return this.netsignapi.getSignCertEntity();
    }

    public byte[] NSDetachedSign(String deSignerDN) {
        byte[] tmp;
        if (deSignerDN == null || deSignerDN.length() == 0) {
            this.errorNum = -10006;
            return null;
        }
        this.errorNum = 0;
        Object obj = ServkeyStoreTable.get(deSignerDN.toLowerCase());
        if (obj == null) {
            this.errorNum = -10028;
            return null;
        }
        ServerKeyStore pfx = (ServerKeyStore)obj;
        byte[] tmp1 = null;
        if (this.plainText == null) {
            this.makePlainText();
            tmp = this.AttachedSignContent;
        } else {
            tmp = this.plainText;
        }
        if (this.errorNum != 0) {
            return null;
        }
        try {
            tmp1 = Base64.encode((byte[])this.netsignapi.GenerateSingleSignedMsg(tmp, pfx, true)).getBytes();
        }
        catch (ServerKeyStoreException expfx) {
            this.errorNum = -10047;
        }
        catch (InvalidKeyException exin) {
            this.errorNum = -10042;
        }
        catch (NoSuchProviderException exp) {
            this.errorNum = -10044;
        }
        catch (NoSuchAlgorithmException exa) {
            this.errorNum = -10043;
        }
        catch (SignatureException exs) {
            this.errorNum = -10045;
        }
        catch (IOException exbase) {
            this.errorNum = -10046;
        }
        catch (Throwable ex) {
            ConsoleLogger.logException(ex);
            this.errorNum = -10010;
        }
        return tmp1;
    }

    public void NSDetachedVerify(byte[] signedMsg, byte[] plainText) {
        if (signedMsg == null || signedMsg.length == 0 || plainText == null || plainText.length == 0) {
            this.errorNum = -10006;
            return;
        }
        this.errorNum = 0;
        try {
            this.netsignapi.VerifySingleSignedMsg(plainText, Base64.decode((byte[])signedMsg), trustCerts, CRLTables, sm2SignID, sm2CertID, true, true);
        }
        catch (CertificateException ex) {
            this.errorNum = -10039;
        }
        catch (InvalidCertificateException ex2) {
            this.errorNum = Integer.parseInt(ex2.getMessage());
        }
        catch (SignatureException ex) {
            this.errorNum = -10030;
        }
        catch (PKCS7ParseException e) {
            ConsoleLogger.logString(e.getMessage());
            this.errorNum = -10030;
        }
        catch (IOException e) {
            this.errorNum = -10030;
        }
        catch (Throwable e) {
            ConsoleLogger.logException(e);
            this.errorNum = -10030;
        }
    }

    public byte[] NSEncryptedEnvelop(String deReciptDN) {
        byte[] tmp;
        if (deReciptDN == null || deReciptDN.length() == 0) {
            this.errorNum = -10006;
            return null;
        }
        this.errorNum = 0;
        Object obj = encCertTable.get(deReciptDN);
        if (obj == null) {
            this.errorNum = -10031;
            return null;
        }
        X509Certificate cert = (X509Certificate)obj;
        byte[] tmp1 = null;
        if (this.plainText == null) {
            this.makePlainText();
            tmp = this.AttachedSignContent;
        } else {
            tmp = this.plainText;
        }
        if (this.errorNum != 0) {
            return null;
        }
        try {
            tmp1 = Base64.encode((byte[])this.netsignapi.composeSingleEnvelopedMsg(tmp, cert, encryptAlgorithm)).getBytes();
        }
        catch (Throwable e) {
            ConsoleLogger.logException(e);
            this.errorNum = e instanceof WriteEnvDataException ? -10049 : (e instanceof EncryptKeyException ? -10050 : (e instanceof EncryptDataException ? -10051 : (e instanceof EncryptAlgException ? -10052 : (e instanceof CertificateException ? -10040 : (e instanceof InvalidCertificateException ? -10041 : (e instanceof NoSuchProviderException ? -10044 : (e instanceof IOException ? -10046 : -10032)))))));
        }
        return tmp1;
    }

    public void NSDecryptedEnvelop(byte[] envelopedMsg, String recipDN) {
        if (recipDN == null || recipDN.length() == 0 || envelopedMsg == null || envelopedMsg.length == 0) {
            this.errorNum = -10006;
            return;
        }
        this.errorNum = 0;
        Object obj = ServkeyStoreTable.get(recipDN.toLowerCase());
        if (obj == null) {
            this.errorNum = -10028;
            return;
        }
        ServerKeyStore pfx = (ServerKeyStore)obj;
        try {
            this.netsignapi.decomposeSingleEnvelopedMsg(Base64.decode((byte[])envelopedMsg), pfx);
        }
        catch (CertificateException certex) {
            this.errorNum = -10040;
        }
        catch (InvalidCertificateException invalidex) {
            this.errorNum = -10041;
        }
        catch (DecryptKeyException dekeex) {
            this.errorNum = -10048;
        }
        catch (DecryptDataException dedaex) {
            this.errorNum = -10053;
        }
        catch (CRLException crlex) {
            this.errorNum = -10038;
        }
        catch (ServerKeyStoreException pfxex) {
            this.errorNum = -10047;
        }
        catch (NoSuchAlgorithmException noalgex) {
            this.errorNum = -10043;
        }
        catch (NoSuchProviderException noprex) {
            this.errorNum = -10044;
        }
        catch (Throwable ex) {
            ConsoleLogger.logException(ex);
            this.errorNum = -10033;
        }
    }

    public byte[] NSSignedAndEncryptedEnvelop(String deSignerDN, String deReciptDN) {
        byte[] tmp;
        if (deSignerDN == null || deSignerDN.length() == 0 || deReciptDN == null || deReciptDN.length() == 0) {
            this.errorNum = -10006;
            return null;
        }
        this.errorNum = 0;
        Object obj = ServkeyStoreTable.get(deSignerDN.toLowerCase());
        if (obj == null) {
            this.errorNum = -10028;
            return null;
        }
        ServerKeyStore pfx = (ServerKeyStore)obj;
        obj = encCertTable.get(deReciptDN);
        if (obj == null) {
            this.errorNum = -10031;
            return null;
        }
        X509Certificate cert = (X509Certificate)obj;
        byte[] tmp1 = null;
        if (this.plainText == null) {
            this.makePlainText();
            tmp = this.AttachedSignContent;
        } else {
            tmp = this.plainText;
        }
        if (this.errorNum != 0) {
            return null;
        }
        try {
            tmp1 = Base64.encode((byte[])this.netsignapi.MSEnvelopedandSigned(tmp, pfx, cert, encryptAlgorithm)).getBytes();
        }
        catch (ServerKeyStoreException pfxex) {
            this.errorNum = -10047;
        }
        catch (InvalidKeyException inkeeyx) {
            this.errorNum = -10042;
        }
        catch (NoSuchProviderException noproex) {
            this.errorNum = -10044;
        }
        catch (NoSuchAlgorithmException nosuaex) {
            this.errorNum = -10043;
        }
        catch (SignatureException sigex) {
            this.errorNum = -10045;
        }
        catch (WriteEnvDataException wrdndateex) {
            this.errorNum = -10049;
        }
        catch (EncryptKeyException exenc) {
            this.errorNum = -10050;
        }
        catch (EncryptDataException encdaex) {
            this.errorNum = -10051;
        }
        catch (EncryptAlgException ealgex) {
            this.errorNum = -10052;
        }
        catch (CertificateException cex) {
            this.errorNum = -10040;
        }
        catch (InvalidCertificateException invlidex) {
            this.errorNum = -10041;
        }
        catch (Throwable ex) {
            this.errorNum = -10034;
            ConsoleLogger.logException(ex);
        }
        return tmp1;
    }

    public void NSDecryptedAndVerifiedEnvelop(byte[] signedAndEnvelopedMsg, String deReciptDN) {
        if (deReciptDN == null || deReciptDN.length() == 0 || signedAndEnvelopedMsg == null || signedAndEnvelopedMsg.length == 0) {
            this.errorNum = -10006;
            return;
        }
        this.errorNum = 0;
        Object obj = ServkeyStoreTable.get(deReciptDN.toLowerCase());
        if (obj == null) {
            this.errorNum = -10028;
            return;
        }
        ServerKeyStore pfx = (ServerKeyStore)obj;
        try {
            this.netsignapi.MSDecrypedandVerify(Base64.decode((byte[])signedAndEnvelopedMsg), pfx, trustCerts, CRLTables);
        }
        catch (CRLException crlex) {
            this.errorNum = -10038;
        }
        catch (CertificateException cerex) {
            this.errorNum = -10040;
        }
        catch (InvalidCertificateException inex) {
            this.errorNum = Integer.parseInt(inex.getMessage());
        }
        catch (InvalidKeyException exkey) {
            this.errorNum = -10042;
        }
        catch (NoSuchProviderException nosuex) {
            this.errorNum = -10044;
        }
        catch (NoSuchAlgorithmException noalg) {
            this.errorNum = -10043;
        }
        catch (SignatureException sigex) {
            this.errorNum = -10045;
        }
        catch (ServerKeyStoreException seke) {
            this.errorNum = -10047;
        }
        catch (DecryptKeyException dece) {
            this.errorNum = -10048;
        }
        catch (Throwable ex) {
            ConsoleLogger.logException(ex);
            this.errorNum = -10035;
        }
    }

    public int NetSignSignVerify(String signMsg) {
        int tmpInt = -1;
        try {
            byte[] tempB = Base64.decode((String)signMsg);
            this.netsignapi.VerifySingleSignedMsg(null, tempB, trustCerts, CRLTables, sm2SignID, sm2CertID, true, true);
            this.getTotle();
            return 1;
        }
        catch (CertificateException e0) {
            return -14;
        }
        catch (CRLException e2) {
            return -17;
        }
        catch (InvalidCertificateException e1) {
            tmpInt = -2;
            return -2;
        }
        catch (Throwable e1) {
            ConsoleLogger.logException(e1);
            return tmpInt;
        }
    }

    public int NetSignDecryptAndVerifyMessage(String envelopBuf, String decryptSub) {
        String keyStoreDN;
        byte[] tempB;
        int tmpInt;
        block14: {
            tmpInt = -1;
            String tmpCN = "CN=" + decryptSub.trim() + ",";
            try {
                tempB = Base64.decode((String)envelopBuf);
            }
            catch (IOException ex) {
                return -27;
            }
            Enumeration e = ServkeyStoreTable.keys();
            keyStoreDN = null;
            String tmpp = null;
            while (e.hasMoreElements()) {
                tmpp = (String)e.nextElement();
                System.out.println(tmpp);
                if (tmpp.indexOf(tmpCN) == -1) continue;
                keyStoreDN = tmpp;
                break;
            }
            if (keyStoreDN != null) break block14;
            System.out.println("\u8f93\u5165\u7684DN\u65e0\u6548\uff01");
            return -25;
        }
        try {
            Object obj = ServkeyStoreTable.get(keyStoreDN.toLowerCase());
            ServerKeyStore pfx = (ServerKeyStore)obj;
            this.netsignapi.MSDecrypedandVerify(tempB, pfx, trustCerts, CRLTables);
            this.getTotle();
            tmpInt = 1;
        }
        catch (DecryptDataException e) {
            return -26;
        }
        catch (DecryptKeyException e) {
            return -26;
        }
        catch (CertificateException e0) {
            return -14;
        }
        catch (InvalidCertificateException e1) {
            tmpInt = -2;
            return -2;
        }
        catch (CertificateNotMatchException e1) {
            ConsoleLogger.logException(e1);
            return -25;
        }
        catch (CRLException e2) {
            return -17;
        }
        catch (ServerKeyStoreException e) {
            return -25;
        }
        catch (Throwable e3) {
            ConsoleLogger.logException(e3);
        }
        return tmpInt;
    }

    public void NSAttachedVerify(byte[] signedMsg, boolean needVerifyCRL) {
        if (signedMsg == null || signedMsg.length == 0) {
            this.errorNum = -10006;
            return;
        }
        this.errorNum = 0;
        try {
            this.netsignapi.VerifySingleSignedMsg(null, Base64.decode((byte[])signedMsg), trustCerts, CRLTables, sm2SignID, sm2CertID, needVerifyCRL, needVerifyCRL);
        }
        catch (CertificateException ex) {
            this.errorNum = -10040;
        }
        catch (CRLException ex1) {
            this.errorNum = -10038;
        }
        catch (InvalidCertificateException ex2) {
            this.errorNum = Integer.parseInt(ex2.getMessage());
        }
        catch (SignatureException ex) {
            this.errorNum = -10029;
        }
        catch (Throwable ex3) {
            ConsoleLogger.logException(ex3);
            this.errorNum = -10029;
        }
    }

    public int NetSignDetachedSignVerify(String signature, byte[] plainText) {
        int tmpInt = -1;
        try {
            byte[] tempB = Base64.decode((String)signature);
            this.netsignapi.VerifySingleSignedMsg(plainText, tempB, trustCerts, CRLTables, sm2SignID, sm2CertID, true, true);
            tmpInt = 1;
        }
        catch (CertificateException e0) {
            return -14;
        }
        catch (InvalidCertificateException e1) {
            tmpInt = -2;
            return -2;
        }
        catch (PKCS7ParseException e2) {
            return -17;
        }
        catch (Exception e2) {
            ConsoleLogger.logException(e2);
        }
        return tmpInt;
    }

    public String GetCertIssuer() {
        return this.netsignapi.getSignCertInfo(2);
    }

    public static String GetVersion() {
        return "NetSignAPI(JAVA) v1.8.100.1 Build201309121600";
    }

    public String GetUsrID() {
        return this.netsignapi.getSignCertInfo(1);
    }

    public String GetCertSerialNumber() {
        return this.netsignapi.getSignCertInfo(5);
    }

    public String GetCertValidTime_start() {
        return this.netsignapi.getSignCertInfo(3);
    }

    public String GetCertValidTime_end() {
        return this.netsignapi.getSignCertInfo(4);
    }

    public byte[][] GetFileInfo() {
        return this.NSGetFileInfo();
    }

    public byte[] GetFormItem() {
        return this.NSGetFormItem();
    }

    public void NSSetDateFormat(DateFormat df) {
        this.netsignapi.setDateFormat(df);
    }
}

