/*
 * Decompiled with CFR 0.152.
 */
package com.infosec;

import cn.com.infosec.netsigninterface.util.ConsoleLogger;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Set;

public class NetSignX509CRL {
    private BigInteger[] ids = new BigInteger[0];

    public static NetSignX509CRL getInstance(X509CRL crl) {
        NetSignX509CRL nscrl = new NetSignX509CRL();
        try {
            if (crl != null) {
                Set<? extends X509CRLEntry> crls = crl.getRevokedCertificates();
                nscrl.ids = new BigInteger[crls.size()];
                Object[] os = crls.toArray();
                crls = null;
                int i = 0;
                int size = os.length;
                while (i < size) {
                    nscrl.ids[i] = ((X509CRLEntry)os[i]).getSerialNumber();
                    os[i] = null;
                    ++i;
                }
                os = null;
                Arrays.sort(nscrl.ids);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nscrl;
    }

    public boolean isRevoked(X509Certificate cert) {
        return Arrays.binarySearch(this.ids, cert.getSerialNumber()) > -1;
    }

    public int size() {
        return this.ids == null ? 0 : this.ids.length;
    }

    void write(OutputStream out) {
        if (this.ids != null) {
            int i = 0;
            int length = this.ids.length;
            while (i < length) {
                try {
                    out.write(("\t\t" + this.ids[i].toString() + "\n").getBytes());
                }
                catch (Exception e) {
                    ConsoleLogger.logException(e);
                }
                ++i;
            }
        }
    }
}

