/*
 * Decompiled with CFR 0.152.
 */
package com.bsz.becp.netpay;

import cn.win_trust_erpc.GMCrypto;
import cn.win_trust_erpc.bouncycastle.util.encoders.Base64;
import com.bsz.becp.signature.B2CConnection;
import com.bsz.becp.signature.BSZBCEPSetting;
import com.bsz.becp.signature.BSZJSONRequest;
import com.bsz.becp.util.Util;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class BSZBECPClient {
    private String lastErr;
    private String Message;
    private String reCode;
    private B2CConnection connection;
    private static DateFormat dateFormat14 = new SimpleDateFormat("yyyyMMddHHmmss");
    private static DateFormat dateFormat8 = new SimpleDateFormat("yyyyMMdd");
    private String returnCode;
    private String returnMessage;
    GMCrypto crypto = null;

    public String sendAndReceive(Map<String, Object> bodyMap) {
        if (!BSZBCEPSetting.isAPIInitialize) {
            return this.sendReturnError("API000000", "\u672a\u521d\u59cb\u5316\u914d\u7f6e\u6216\u521d\u59cb\u5316\u914d\u7f6e\u5f02\u5e38\u8bf7\u67e5\u770b\u65e5\u5fd7");
        }
        String SERVICE_CODE = "";
        String CONSUMER_SEQ_NO = "";
        String HOST_NO = "";
        if (bodyMap.containsKey("SERVICE_CODE")) {
            SERVICE_CODE = (String)bodyMap.get("SERVICE_CODE");
        }
        if (bodyMap.containsKey("CONSUMER_SEQ_NO")) {
            CONSUMER_SEQ_NO = (String)bodyMap.get("CONSUMER_SEQ_NO");
        }
        if (bodyMap.containsKey("HOST_NO")) {
            HOST_NO = (String)bodyMap.get("HOST_NO");
        }
        if ("".equals(SERVICE_CODE.trim()) || SERVICE_CODE == null) {
            this.log("\u8bf7\u6c42\u6570\u636e\u7ec4\u5305\u9519\u8bef{}{}", "\u7f3a\u5c11\u8bf7\u6c42\u5b57\u6bb5", "[SERVICE_CODE]\u5fc5\u8f93");
            return this.sendReturnError("API000001", "\u7f3a\u5c11\u4ea4\u6613\u7801[SERVICE_CODE]\u5b57\u6bb5");
        }
        if (SERVICE_CODE.length() != 10) {
            this.log("\u8bf7\u6c42\u6570\u636e\u7ec4\u5305\u9519\u8bef{}{}", "\u8bf7\u6c42\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef", "[SERVICE_CODE]\u957f\u5ea6\u9519\u8bef");
            return this.sendReturnError("API000002", "[SERVICE_CODE]\u957f\u5ea6\u9519\u8bef");
        }
        if ("".equals(CONSUMER_SEQ_NO.trim()) || CONSUMER_SEQ_NO == null) {
            this.log("\u8bf7\u6c42\u6570\u636e\u7ec4\u5305\u9519\u8bef{}{}", "\u7f3a\u5c11\u8bf7\u6c42\u5b57\u6bb5", "\u7f3a\u5c11\u6d41\u6c34\u53f7[CONSUMER_SEQ_NO]\u5b57\u6bb5");
            return this.sendReturnError("API000005", "\u7f3a\u5c11\u6d41\u6c34\u53f7[CONSUMER_SEQ_NO]\u5b57\u6bb5");
        }
        if ("".equals(HOST_NO.trim()) || HOST_NO == null) {
            this.log("\u8bf7\u6c42\u6570\u636e\u7ec4\u5305\u9519\u8bef{}{}", "\u7f3a\u5c11\u8bf7\u6c42\u5b57\u6bb5", "\u7f3a\u5c11\u6d41\u6c34\u53f7[HOST_NO]\u5b57\u6bb5");
            return this.sendReturnError("API000006", "\u7f3a\u5c11\u6d41\u6c34\u53f7[HOST_NO]\u5b57\u6bb5");
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("version", "1.0");
        headMap.put("SERVICE_CODE", SERVICE_CODE);
        headMap.put("transCode", SERVICE_CODE);
        headMap.put("HOST_NO", HOST_NO);
        headMap.put("CONSUMER_SEQ_NO", CONSUMER_SEQ_NO);
        bodyMap.remove("SERVICE_CODE");
        bodyMap.remove("transCode");
        bodyMap.remove("HOST_NO");
        bodyMap.remove("CONSUMER_SEQ_NO");
        requestMap.put("header", headMap);
        requestMap.put("body", bodyMap);
        BSZJSONRequest reqJson = new BSZJSONRequest();
        String requestMsg = reqJson.getRequestJson(requestMap);
        String repJsonContent = this.executeOperation(requestMsg);
        System.out.println("\u8fd4\u56de\u62a5\u6587:" + repJsonContent);
        return repJsonContent;
    }

    public String executeOperation(String requestMsg) {
        String reponseMsg = null;
        try {
            String fullURL = BSZBCEPSetting.ApiURL;
            if (this.connection == null) {
                this.connection = new B2CConnection(false);
            }
            BSZJSONRequest reponseJson = new BSZJSONRequest();
            if (BSZBCEPSetting.SignFlag) {
                requestMsg = this.getEncryption(requestMsg);
            }
            System.out.println("\u8bf7\u6c42URL:" + fullURL);
            System.out.println("\u8bf7\u6c42\u62a5\u6587:" + requestMsg);
            reponseMsg = this.connection.sendAndReceive(fullURL, requestMsg);
            if (BSZBCEPSetting.SignFlag) {
                reponseMsg = this.setDecrypt(reponseMsg);
            }
            return reponseMsg;
        }
        catch (Exception e) {
            return this.sendReturnError("999999", e.getMessage());
        }
    }

    public String getEncryption(String requestMsg) throws Exception {
        try {
            JSONArray acctArray;
            this.crypto = new GMCrypto();
            String PublicKey2 = BSZBCEPSetting.ClientPublicKey;
            String ClientSM2File = BSZBCEPSetting.ClientSM2File;
            String CertPwd = BSZBCEPSetting.CertSecretKey;
            String CertSecretFile = BSZBCEPSetting.CertSecretFile;
            JSONObject jsonContent = JSONObject.fromObject((Object)requestMsg);
            String bodyMsg = jsonContent.getString("body");
            String headerMsg = jsonContent.getString("header");
            JSONObject headerJsonMsg = JSONObject.fromObject((Object)headerMsg);
            String transCodeVal = headerJsonMsg.getString("transCode");
            JSONObject bodyJsonMsg = JSONObject.fromObject((Object)bodyMsg);
            if ("OPCB000002".equals(transCodeVal) && bodyJsonMsg.has("ACCT_ARRAY")) {
                acctArray = bodyJsonMsg.getJSONArray("ACCT_ARRAY");
                bodyJsonMsg.put((Object)"ACCT_ARRAY_YQZL", (Object)acctArray);
            }
            if ("OPCB000004".equals(transCodeVal) && bodyJsonMsg.has("ACCT_ARRAY")) {
                acctArray = bodyJsonMsg.getJSONArray("ACCT_ARRAY");
                bodyJsonMsg.put((Object)"ACCT_ARRAY_YQZL2", (Object)acctArray);
            }
            if ("OPCB000035".equals(transCodeVal) && bodyJsonMsg.has("EBILL_HOLD_ARRAY_PROMPTPAY")) {
                JSONArray ebillHoldArrayPromptpay = bodyJsonMsg.getJSONArray("EBILL_HOLD_ARRAY_PROMPTPAY");
                bodyJsonMsg.put((Object)"EBILL_HOLD_ARRAY_PROMPTPAY_YQZL", (Object)ebillHoldArrayPromptpay);
            }
            byte[] cipherSK = this.crypto.GMCrypto_ExportSessionKey(PublicKey2);
            byte[] ciphertext = this.crypto.GMCrypto_EncryptMsg(bodyJsonMsg.toString().getBytes("GBK"));
            String byteToHexCiphertext = Util.byteToHex(ciphertext);
            byte[] clientCert = BSZBECPClient.getSM2File(ClientSM2File);
            List result = this.crypto.GMCrypto_SetClientCert(new String(clientCert), CertPwd);
            byte[] signData = this.crypto.GMCrypto_P7Sign(true, ciphertext);
            String signDataBase = new String(Base64.encode((byte[])signData));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"data", (Object)byteToHexCiphertext);
            jsonObject.put((Object)"sign", (Object)signDataBase);
            jsonObject.put((Object)"cipherSK", (Object)Util.byteToHex(cipherSK));
            jsonContent.put((Object)"body", (Object)jsonObject);
            return jsonContent.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String setDecrypt(String reponseMsg) throws Exception {
        JSONObject jsonContent = JSONObject.fromObject((Object)reponseMsg);
        String jsonHeader = jsonContent.getString("header");
        String jsonBody = jsonContent.getString("body");
        JSONObject jsonHeaderData = JSONObject.fromObject((Object)jsonHeader);
        JSONObject jsonBodyData = JSONObject.fromObject((Object)jsonBody);
        if (jsonBodyData.has("returnCode") && "000000".equals(jsonBodyData.getString("returnCode"))) {
            String dataMsg = jsonBodyData.getString("data");
            String sign = jsonBodyData.getString("sign");
            boolean verifyResult = this.crypto.GMCrypto_P7Verify(Base64.decode((String)sign), dataMsg.getBytes());
            System.out.println("\u9a8c\u7b7e\u662f\u5426\u6210\u529f:" + verifyResult);
            if (verifyResult) {
                byte[] decryptData = this.crypto.GMCrypto_DecryptMsg(Util.hexToByte(dataMsg));
                String bodyStr = new String(decryptData, StandardCharsets.UTF_8);
                jsonContent.put((Object)"body", (Object)bodyStr);
                jsonBody = jsonContent.getString("body");
                jsonBodyData = JSONObject.fromObject((Object)jsonBody);
                String returnCode = jsonBodyData.getString("returnCode");
                String returnMessage = jsonBodyData.getString("returnMessage");
                jsonBodyData.remove("returnCode");
                jsonBodyData.remove("returnMessage");
                jsonBodyData.remove("errorCode");
                jsonBodyData.remove("errorMsg");
                jsonHeaderData.put((Object)"RET_CODE", (Object)returnCode);
                jsonHeaderData.put((Object)"RET_MSG", (Object)returnMessage);
                String transCodeVal = jsonHeaderData.getString("transCode");
                jsonHeaderData.remove("transCode");
                if ("OPCB000002".equals(transCodeVal) && jsonBodyData.has("RESULT_ARRAY_YQZL")) {
                    JSONArray resultArray = jsonBodyData.getJSONArray("RESULT_ARRAY_YQZL");
                    jsonBodyData.put((Object)"RESULT_ARRAY", (Object)resultArray);
                    jsonBodyData.remove("RESULT_ARRAY_YQZL");
                }
                if ("OPCB000014".equals(transCodeVal)) {
                    if (jsonBodyData.has("BILL_ARRAY_YQZL")) {
                        JSONArray billArray = jsonBodyData.getJSONArray("BILL_ARRAY_YQZL");
                        jsonBodyData.put((Object)"BILL_ARRAY", (Object)billArray);
                        jsonBodyData.remove("BILL_ARRAY_YQZL");
                    }
                    if (jsonBodyData.has("DETAIL_ARRAY_YQZL")) {
                        JSONArray detailArray = jsonBodyData.getJSONArray("DETAIL_ARRAY_YQZL");
                        jsonBodyData.put((Object)"DETAIL_ARRAY", (Object)detailArray);
                        jsonBodyData.remove("DETAIL_ARRAY_YQZL");
                    }
                }
                if ("OPCB000018".equals(transCodeVal) && jsonBodyData.has("BANK_RESULT_ARRAY_YQZL")) {
                    JSONArray bankResultArray = jsonBodyData.getJSONArray("BANK_RESULT_ARRAY_YQZL");
                    jsonBodyData.put((Object)"RESULT_ARRAY", (Object)bankResultArray);
                    jsonBodyData.remove("BANK_RESULT_ARRAY_YQZL");
                }
                if ("OPCB000024".equals(transCodeVal) && jsonBodyData.has("TRAN_LIST_ARRAY_YQZL")) {
                    JSONArray tranListArray = jsonBodyData.getJSONArray("TRAN_LIST_ARRAY_YQZL");
                    jsonBodyData.put((Object)"TRAN_LIST_ARRAY", (Object)tranListArray);
                    jsonBodyData.remove("TRAN_LIST_ARRAY_YQZL");
                }
                if ("OPCB000025".equals(transCodeVal) && jsonBodyData.has("TRAB_RESULT_ARRAY_YQZL")) {
                    JSONArray tranResultArray = jsonBodyData.getJSONArray("TRAB_RESULT_ARRAY_YQZL");
                    jsonBodyData.put((Object)"RESULT_ARRAY", (Object)tranResultArray);
                    jsonBodyData.remove("TRAB_RESULT_ARRAY_YQZL");
                }
                jsonContent.put((Object)"header", (Object)jsonHeaderData);
                jsonContent.put((Object)"body", (Object)jsonBodyData);
            } else {
                String returnCode = "999999";
                String returnMessage = "\u9a8c\u7b7e\u5931\u8d25";
                jsonHeaderData.put((Object)"RET_CODE", (Object)returnCode);
                jsonHeaderData.put((Object)"RET_MSG", (Object)returnMessage);
                jsonBodyData.remove("data");
                jsonBodyData.remove("sign");
                jsonBodyData.remove("errorCode");
                jsonBodyData.remove("errorMsg");
                jsonBodyData.remove("returnCode");
                jsonBodyData.remove("returnMessage");
                jsonContent.put((Object)"header", (Object)jsonHeaderData);
                jsonContent.put((Object)"body", (Object)jsonBodyData);
            }
        } else {
            String errorCode = jsonBodyData.getString("errorCode");
            String errorMsg = jsonBodyData.getString("errorMsg");
            jsonHeaderData.put((Object)"RET_CODE", (Object)errorCode);
            jsonHeaderData.put((Object)"RET_MSG", (Object)errorMsg);
            jsonBodyData.remove("data");
            jsonBodyData.remove("sign");
            jsonBodyData.remove("errorCode");
            jsonBodyData.remove("errorMsg");
            jsonBodyData.remove("returnCode");
            jsonBodyData.remove("returnMessage");
            jsonContent.put((Object)"header", (Object)jsonHeaderData);
            jsonContent.put((Object)"body", (Object)jsonBodyData);
        }
        reponseMsg = jsonContent.toString();
        return reponseMsg;
    }

    public void setLastErr(String lastErr) {
        this.lastErr = lastErr;
    }

    public void setMessage(String message) {
        this.Message = message;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public String getReturnMessage() {
        return this.returnMessage;
    }

    public void setReturnMessage(String returnMessage) {
        this.returnMessage = returnMessage;
    }

    public String GetLongDate() {
        return dateFormat14.format(new Date());
    }

    public String GetDate() {
        return dateFormat8.format(new Date());
    }

    public String getLastErr() {
        return this.lastErr;
    }

    public String getMessage() {
        return this.Message;
    }

    public String getReCode() {
        return this.reCode;
    }

    public void setReCode(String reCode) {
        this.reCode = reCode;
    }

    public int initialize(String fileName) {
        if (BSZBCEPSetting.isAPIInitialize) {
            return 0;
        }
        try {
            return this.initializeReal(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public synchronized int initializeReal(String fileName) throws Exception {
        if (BSZBCEPSetting.isAPIInitialize) {
            return 0;
        }
        new BSZBCEPSetting(fileName);
        this.log("API Initialize{}{}", "\u89e3\u6790\u914d\u7f6e\u6587\u4ef6", "\u521d\u59cb\u5316\u6210\u529f");
        BSZBCEPSetting.isAPIInitialize = true;
        return 0;
    }

    private void log(String dealName, String action, String msg) {
        try {
            if (BSZBCEPSetting.logWriter == null) {
                return;
            }
            long timeStamp = System.currentTimeMillis();
            Date curDate = new Date(timeStamp);
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeStampStr = fmt.format(curDate);
            String logMsg = timeStampStr + "\t" + dealName + "\t[" + action + "]\t";
            BSZBCEPSetting.logWriter.write(logMsg);
            if (msg != null && msg.trim().length() != 0) {
                BSZBCEPSetting.logWriter.write(BSZBECPClient.replace(BSZBECPClient.replace(msg, "&lt;", "<"), "&gt;", ">"));
            }
            BSZBCEPSetting.logWriter.write("\r\n");
            BSZBCEPSetting.logWriter.flush();
        }
        catch (IOException e) {
            this.reCode = "-2055";
            this.lastErr = "\u8bb0\u5f55\u65e5\u5fd7\u6587\u4ef6\u9519\u8bef:" + e.toString();
            return;
        }
    }

    public static String replace(String strSource, String strFrom, String strTo) {
        int intPos;
        String strDest = "";
        int intFromLen = strFrom.length();
        while ((intPos = strSource.indexOf(strFrom)) != -1) {
            strDest = strDest + strSource.substring(0, intPos);
            strDest = strDest + strTo;
            strSource = strSource.substring(intPos + intFromLen);
        }
        strDest = strDest + strSource;
        return strDest;
    }

    private String sendReturnError(String returnCode, String returnMessage) {
        String returnContent = "{\"header\":{\"RET_CODE\":\"" + returnCode + "\",\"RET_MSG\":\"" + returnMessage + "\"},\"body\":{}}";
        return returnContent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getSM2File(String filePath) throws Exception {
        try (FileInputStream crls = new FileInputStream(filePath);){
            int rLength;
            byte[] out = new byte[crls.available()];
            byte[] buffer = new byte[65536];
            int offset = 0;
            while ((rLength = crls.read(buffer, 0, buffer.length)) != -1) {
                System.arraycopy(buffer, 0, out, offset, rLength);
                offset += rLength;
            }
            byte[] arrayOfByte1 = out;
            crls.close();
            byte[] byArray = arrayOfByte1;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

