/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.pure.impl;

import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.ExtendedDigest;
import cfca.sadk.org.bouncycastle.util.Memoable;
import cfca.sadk.tls.pure.CryptoException;
import cfca.sadk.tls.pure.IMac;
import java.nio.ByteBuffer;
import javax.crypto.SecretKey;

public class HMac
implements IMac {
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private int digestSize;
    private int blockLength;
    private Memoable ipadState;
    private Memoable opadState;
    private byte[] inputPad;
    private byte[] outputBuf;
    private final boolean memoable;
    private final Digest digest;

    public HMac(Digest digest) throws CryptoException {
        if (digest == null || !(digest instanceof ExtendedDigest)) {
            throw new CryptoException("digest not ExtendedDigest");
        }
        this.digestSize = digest.getDigestSize();
        this.blockLength = ((ExtendedDigest)digest).getByteLength();
        this.inputPad = new byte[this.blockLength];
        this.outputBuf = new byte[this.blockLength + this.digestSize];
        this.memoable = digest instanceof Memoable;
        this.digest = digest;
    }

    @Override
    public String getAlgorithmName() {
        return this.digest.getAlgorithmName() + "/HMAC";
    }

    public Digest getUnderlyingDigest() {
        return this.digest;
    }

    @Override
    public void init(SecretKey secretKey) throws CryptoException {
        if (secretKey == null) {
            throw new CryptoException("secretKey==null");
        }
        this.digest.reset();
        byte[] key = secretKey.getEncoded();
        int keyLength = key.length;
        if (keyLength > this.blockLength) {
            this.digest.update(key, 0, keyLength);
            this.digest.doFinal(this.inputPad, 0);
            keyLength = this.digestSize;
        } else {
            System.arraycopy(key, 0, this.inputPad, 0, keyLength);
        }
        for (int i = keyLength; i < this.inputPad.length; ++i) {
            this.inputPad[i] = 0;
        }
        System.arraycopy(this.inputPad, 0, this.outputBuf, 0, this.blockLength);
        HMac.xorPad(this.inputPad, this.blockLength, (byte)54);
        HMac.xorPad(this.outputBuf, this.blockLength, (byte)92);
        if (this.memoable) {
            this.opadState = ((Memoable)this.digest).copy();
            ((Digest)this.opadState).update(this.outputBuf, 0, this.blockLength);
            this.digest.update(this.inputPad, 0, this.inputPad.length);
            this.ipadState = ((Memoable)this.digest).copy();
        } else {
            this.digest.update(this.inputPad, 0, this.inputPad.length);
        }
    }

    @Override
    public int getMacSize() {
        return this.digestSize;
    }

    @Override
    public void update(ByteBuffer input) {
        if (input.hasRemaining()) {
            if (input.hasArray()) {
                byte[] b = input.array();
                int ofs = input.arrayOffset();
                int pos = input.position();
                int lim = input.limit();
                this.update(b, ofs + pos, lim - pos);
                input.position(lim);
            } else {
                int chunk;
                int len;
                byte[] b = new byte[Math.min(4096, len)];
                for (len = input.remaining(); len > 0; len -= chunk) {
                    chunk = Math.min(len, b.length);
                    input.get(b, 0, chunk);
                    this.update(b, 0, chunk);
                }
            }
        }
    }

    @Override
    public void update(byte in) {
        this.digest.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.digest.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.digest.doFinal(this.outputBuf, this.blockLength);
        if (this.opadState != null) {
            ((Memoable)this.digest).reset(this.opadState);
            this.digest.update(this.outputBuf, this.blockLength, this.digest.getDigestSize());
        } else {
            this.digest.update(this.outputBuf, 0, this.outputBuf.length);
        }
        int len = this.digest.doFinal(out, outOff);
        for (int i = this.blockLength; i < this.outputBuf.length; ++i) {
            this.outputBuf[i] = 0;
        }
        if (this.ipadState != null) {
            ((Memoable)this.digest).reset(this.ipadState);
        } else {
            this.digest.update(this.inputPad, 0, this.inputPad.length);
        }
        return len;
    }

    @Override
    public void reset() {
        this.digest.reset();
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }

    private static void xorPad(byte[] pad, int len, byte n) {
        int i = 0;
        while (i < len) {
            int n2 = i++;
            pad[n2] = (byte)(pad[n2] ^ n);
        }
    }
}

