/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.extension;

import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.extension.ExtensionType;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtension;
import cfca.sadk.tls.util.DataHelper;
import cfca.sadk.tls.util.Hex;
import java.io.IOException;
import javax.net.ssl.SSLProtocolException;

public final class RenegotiationInfoExtension
extends HelloExtension {
    private final byte[] data;

    public RenegotiationInfoExtension(byte[] clientVerifyData, byte[] serverVerifyData) {
        super(ExtensionType.EXT_RENEGOTIATION_INFO);
        if (clientVerifyData.length != 0) {
            this.data = new byte[clientVerifyData.length + serverVerifyData.length];
            System.arraycopy(clientVerifyData, 0, this.data, 0, clientVerifyData.length);
            if (serverVerifyData.length != 0) {
                System.arraycopy(serverVerifyData, 0, this.data, clientVerifyData.length, serverVerifyData.length);
            }
        } else {
            this.data = new byte[0];
        }
    }

    RenegotiationInfoExtension(HandshakeInStream in, int len) throws IOException {
        super(ExtensionType.EXT_RENEGOTIATION_INFO);
        if (len < 1) {
            throw new SSLProtocolException("Invalid " + (Object)((Object)this.type) + " extension");
        }
        int dataLength = in.getInt8();
        if (dataLength + 1 != len) {
            throw new SSLProtocolException("Invalid " + (Object)((Object)this.type) + " extension");
        }
        this.data = new byte[dataLength];
        if (dataLength != 0) {
            in.read(this.data, 0, dataLength);
        }
    }

    @Override
    final int length() {
        return 5 + (this.data == null ? 0 : this.data.length);
    }

    @Override
    final byte[] getEncoded() throws IOException {
        byte[] encoded = new byte[this.length()];
        int dataLength = encoded.length - 5;
        DataHelper.write((short)this.type.id, encoded, 0);
        DataHelper.write((short)(dataLength + 1), encoded, 2);
        DataHelper.write((byte)dataLength, encoded, 4);
        DataHelper.write(this.data, encoded, 5);
        return encoded;
    }

    public boolean isEmpty() {
        return this.data.length == 0;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Extension ").append((Object)this.type);
        builder.append(", renegotiated_connection: ");
        builder.append(this.data.length == 0 ? "<empty>" : Hex.hexify(this.data));
        return builder.toString();
    }
}

